/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.legend;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.map.FillData;
import com.elixirtech.map.legend.DescendingSort;
import com.elixirtech.map.legend.DiscreteLegendItem;
import com.elixirtech.map.legend.ILegendView;
import com.elixirtech.map.model.Font;
import com.elixirtech.map.model.Format;
import com.elixirtech.map.model.Legend;
import com.elixirtech.map.view.AbstractView;
import com.elixirtech.ui.Icons;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.util.format.FormatUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.Icon;

public class DiscreteLegendView
extends AbstractView
implements ILegendView {
    private Legend m_Legend;
    private int m_FontAscent;
    private FillData m_FillData;
    private final List<DiscreteLegendItem> m_Items = new ArrayList<DiscreteLegendItem>();
    private Dimension m_LabelDimensions;
    private static final int BORDER_GAP = 4;
    private static final int ICON_SIZE = 8;
    private static final int ICON_LABEL_GAP = 4;
    private static final int ITEM_GAP = 6;

    @Override
    public void setLegend(Legend legend) {
        this.m_Legend = legend;
    }

    @Override
    public void setFillData(FillData fillData) {
        this.m_FillData = fillData;
    }

    @Override
    protected String getLocation() {
        return this.m_Legend.getLocation();
    }

    @Override
    public Dimension getViewSize(Rectangle rectangle) {
        this.m_Items.clear();
        if (this.m_FillData == null) {
            return new Dimension(0, 0);
        }
        TreeSet<Object> treeSet = new TreeSet<Object>();
        treeSet.addAll(this.m_FillData.getValueSet());
        for (Map.Entry<Object, Color> entry : this.m_FillData.getValueColorMap().entrySet()) {
            Color color = entry.getValue();
            if (color == null) continue;
            this.m_Items.add(new DiscreteLegendItem(entry.getKey(), color));
        }
        String string = this.m_Legend.getSort();
        if ("Ascending".equals(string)) {
            Collections.sort(this.m_Items);
        } else if ("Descending".equals(string)) {
            Collections.sort(this.m_Items, new DescendingSort());
        }
        this.buildLabels();
        this.sizeLabels();
        this.m_LabelDimensions = this.getDirection() == 1 ? this.layoutHorizontal(rectangle) : this.layoutVertical(rectangle);
        return this.m_LabelDimensions;
    }

    private Dimension layoutVertical(Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (DiscreteLegendItem discreteLegendItem : this.m_Items) {
            int n6 = 12 + discreteLegendItem.labelSize.width;
            int n7 = discreteLegendItem.labelSize.height;
            if (n4 > 0 && n4 + n7 > this.getLength(rectangle)) {
                n4 = 0;
                n3 = n3 + n5 + 6;
            }
            discreteLegendItem.labelPosition = new Point(n3, n4);
            n5 = Math.max(n5, n6);
            n = Math.max(n, n3 + n5);
            n2 = Math.max(n2, n4 += n7);
        }
        return new Dimension(n + 8, n2 + 8);
    }

    private Dimension layoutHorizontal(Rectangle rectangle) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        for (DiscreteLegendItem discreteLegendItem : this.m_Items) {
            int n6 = 12 + discreteLegendItem.labelSize.width;
            if (n3 > 0 && n3 + n6 > this.getLength(rectangle)) {
                n3 = 0;
                ++n5;
                n4 += n2;
                n2 = 0;
            }
            discreteLegendItem.labelPosition = new Point(n3, n4);
            n = Math.max(n, n3 += n6);
            n2 = Math.max(n2, discreteLegendItem.labelSize.height);
            n3 += 6;
        }
        return new Dimension(n + 8, n5 * n2 + 8);
    }

    private int getDirection() {
        String string = this.m_Legend.getLocation();
        if ("North".equals(string) || "South".equals(string)) {
            return 1;
        }
        if ("East".equals(string) || "West".equals(string)) {
            return 2;
        }
        return 0;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.m_Rect != null && this.m_Items.size() > 0) {
            graphics2D.setStroke(new BasicStroke(0.0f));
            int n = (this.m_Rect.width - this.m_LabelDimensions.width) / 2;
            int n2 = (this.m_Rect.height - this.m_LabelDimensions.height) / 2;
            Rectangle rectangle = new Rectangle(this.m_Rect.x + n, this.m_Rect.y + n2, this.m_LabelDimensions.width, this.m_LabelDimensions.height);
            String string = this.m_Legend.getBackgroundColor();
            String string2 = this.m_Legend.getBorderColor();
            if (StringUtil.notEmpty(string)) {
                graphics2D.setColor(StandardColor.lookup(string, Color.WHITE));
                graphics2D.fill(rectangle);
            }
            if (StringUtil.notEmpty(string2)) {
                graphics2D.setColor(StandardColor.lookup(string2, Color.BLACK));
                graphics2D.draw(rectangle);
            }
            graphics2D.translate(rectangle.x, rectangle.y);
            graphics2D.translate(4, 4);
            for (DiscreteLegendItem discreteLegendItem : this.m_Items) {
                this.drawItem(graphics2D, discreteLegendItem);
            }
            graphics2D.translate(-4, -4);
            graphics2D.translate(-rectangle.x, -rectangle.y);
        }
    }

    private void drawItem(Graphics2D graphics2D, DiscreteLegendItem discreteLegendItem) {
        Icon icon = Icons.getColourIcon(discreteLegendItem.value);
        int n = discreteLegendItem.labelPosition.x;
        int n2 = discreteLegendItem.labelPosition.y + this.m_FontAscent;
        icon.paintIcon(null, graphics2D, n, n2 - 8);
        Font font = this.m_Legend.getFont();
        graphics2D.setFont(font.getAWTFont());
        String string = font.getColor();
        graphics2D.setColor(StandardColor.lookup(string, Color.BLACK));
        graphics2D.drawString(discreteLegendItem.label, n + 8 + 4, n2);
    }

    private void buildLabels() {
        java.text.Format format = null;
        Format format2 = this.m_Legend.getFormat();
        if (format2 != null && FormatUtil.notNone(format2) && (format = format2.getFormatter()) == null) {
            format = FormatUtil.buildFormatter(format2, Locale.getDefault());
            format2.setFormatter(format);
        }
        if (format != null) {
            for (DiscreteLegendItem discreteLegendItem : this.m_Items) {
                try {
                    discreteLegendItem.label = format.format(discreteLegendItem.data);
                }
                catch (Throwable throwable) {
                    discreteLegendItem.label = String.valueOf(discreteLegendItem.data);
                }
            }
        } else {
            for (DiscreteLegendItem discreteLegendItem : this.m_Items) {
                discreteLegendItem.label = String.valueOf(discreteLegendItem.data);
            }
        }
    }

    private void sizeLabels() {
        BufferedImage bufferedImage = new BufferedImage(10, 10, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.m_Legend.getFont().getAWTFont());
        this.m_FontAscent = fontMetrics.getAscent();
        int n = fontMetrics.getHeight();
        for (DiscreteLegendItem discreteLegendItem : this.m_Items) {
            int n2 = fontMetrics.stringWidth(discreteLegendItem.label);
            discreteLegendItem.labelSize = new Dimension(n2, n);
        }
        graphics2D.dispose();
        bufferedImage.flush();
    }
}

