/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.sax;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.util.URLLoader;
import com.elixirtech.map.IShapeIterator;
import com.elixirtech.map.IShapes;
import com.elixirtech.map.ListShapeIterator;
import com.elixirtech.map.basic.BasicShapeLoader;
import com.elixirtech.map.ds.DSShapeLoader;
import com.elixirtech.map.model.BasicMapSource;
import com.elixirtech.map.model.DSMapSource;
import com.elixirtech.map.model.MapFile;
import com.elixirtech.map.model.MapFileSAX;
import com.elixirtech.map.model.MapSource;
import com.elixirtech.map.model.Shapefile;
import com.elixirtech.map.shapefile.SHPShapeIterator;
import com.elixirtech.map.shapefile.ShapeFileLoader;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MapFileLoader {
    public static final String MAPFILE = "MapFile";
    public static final int VERSION = 1;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(MapFileLoader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MapFile readMap(RMLFileObject rMLFileObject) throws IOException {
        m_Log.debug((Object)("readJob(" + rMLFileObject.getName() + ")"));
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            MapFileSAX mapFileSAX = new MapFileSAX();
            try (InputStream inputStream = rMLFileObject.getInputStream();){
                sAXParser.parse(inputStream, (DefaultHandler)mapFileSAX);
            }
            MapFile mapFile = (MapFile)mapFileSAX.getObject();
            mapFile.setFileObject(rMLFileObject);
            mapFile.loaded();
            return mapFile;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            m_Log.error((Object)("readJob: " + parserConfigurationException), (Throwable)parserConfigurationException);
            throw new IOException(parserConfigurationException.toString());
        }
        catch (SAXException sAXException) {
            m_Log.error((Object)("readJob: " + sAXException), (Throwable)sAXException);
            throw new IOException(sAXException.toString());
        }
    }

    public static void close(RMLFileObject rMLFileObject) {
    }

    public static IShapes loadShapes(MapSource mapSource) throws IOException {
        if (mapSource != null) {
            String string = mapSource.getTagName();
            if ("shapefile".equals(string)) {
                return MapFileLoader.loadShapefile((Shapefile)mapSource);
            }
            if ("ds-mapsource".equals(string)) {
                return MapFileLoader.loadDSMap((DSMapSource)mapSource);
            }
            if ("basic-mapsource".equals(string)) {
                return MapFileLoader.loadBasic((BasicMapSource)mapSource);
            }
        }
        return null;
    }

    public static IShapeIterator loadShapeIterator(MapSource mapSource) throws IOException {
        if (mapSource != null) {
            String string = mapSource.getTagName();
            if ("shapefile".equals(string)) {
                return MapFileLoader.loadShapefileShapeIterator((Shapefile)mapSource);
            }
            if ("ds-mapsource".equals(string)) {
                return MapFileLoader.loadDSMapIterator((DSMapSource)mapSource);
            }
        }
        return null;
    }

    private static IShapeIterator loadShapefileShapeIterator(Shapefile shapefile) throws IOException {
        String string = shapefile.getSHP();
        String string2 = shapefile.getDBF();
        InputStream inputStream = URLLoader.getInputStream(string);
        InputStream inputStream2 = URLLoader.getInputStream(string2);
        return new SHPShapeIterator(inputStream, inputStream2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IShapes loadShapefile(Shapefile shapefile) throws IOException {
        String string = shapefile.getSHP();
        String string2 = shapefile.getDBF();
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            IShapes iShapes;
            inputStream = URLLoader.getInputStream(string);
            inputStream2 = URLLoader.getInputStream(string2);
            ShapeFileLoader shapeFileLoader = new ShapeFileLoader();
            IShapes iShapes2 = iShapes = shapeFileLoader.loadShapesAndData(inputStream, inputStream2);
            return iShapes2;
        }
        finally {
            FileUtil.close(inputStream);
            FileUtil.close(inputStream2);
        }
    }

    private static IShapes loadBasic(BasicMapSource basicMapSource) throws IOException {
        BasicShapeLoader basicShapeLoader = new BasicShapeLoader();
        String string = basicMapSource.getURL();
        InputStream inputStream = URLLoader.getInputStream(string);
        IShapes iShapes = basicShapeLoader.loadShapes(inputStream);
        inputStream.close();
        return iShapes;
    }

    private static IShapes loadDSMap(DSMapSource dSMapSource) throws IOException {
        DSShapeLoader dSShapeLoader = new DSShapeLoader();
        return dSShapeLoader.loadShapes(dSMapSource.getURL());
    }

    private static IShapeIterator loadDSMapIterator(DSMapSource dSMapSource) throws IOException {
        IShapes iShapes = MapFileLoader.loadDSMap(dSMapSource);
        return new ListShapeIterator(iShapes.getShapes());
    }
}

