/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.shapefile;

import com.elixirtech.map.IShape;
import com.elixirtech.map.IShapeIterator;
import com.elixirtech.map.shapefile.SHPShape;
import com.elixirtech.map.shapefile.ShapeFileLoader;
import com.elixirtech.util.FileUtil;
import com.linuxense.javadbf.DBFField;
import com.linuxense.javadbf.DBFReader;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.InputStream;

public class SHPShapeIterator
implements IShapeIterator {
    private final InputStream m_SHPInput;
    private final InputStream m_DBFInput;
    private final Rectangle2D m_Bounds;
    private final DBFReader m_DBFReader;
    private final DBFField[] m_Fields;
    private final int[] m_FieldTypes;
    private SHPShape m_Next;

    public SHPShapeIterator(InputStream inputStream, InputStream inputStream2) throws IOException {
        this.m_SHPInput = inputStream;
        this.m_DBFInput = inputStream2;
        this.m_Bounds = ShapeFileLoader.readHeader(this.m_SHPInput);
        this.m_DBFReader = new DBFReader(this.m_DBFInput);
        int n = this.m_DBFReader.getFieldCount();
        this.m_Fields = new DBFField[n];
        this.m_FieldTypes = new int[n];
        for (int i = 0; i < n; ++i) {
            this.m_Fields[i] = this.m_DBFReader.getField(i);
            this.m_FieldTypes[i] = ShapeFileLoader.getDataType(this.m_Fields[i].getDataType()).getTypeId();
        }
        this.readNext();
    }

    public Rectangle2D getBounds() {
        return this.m_Bounds;
    }

    @Override
    public boolean hasNext() {
        return this.m_Next != null;
    }

    @Override
    public IShape next() throws IOException {
        SHPShape sHPShape = this.m_Next;
        this.readNext();
        return sHPShape;
    }

    @Override
    public void close() {
        FileUtil.close(this.m_SHPInput);
        FileUtil.close(this.m_DBFInput);
    }

    private void readNext() throws IOException {
        this.m_Next = ShapeFileLoader.readShapeRecord(this.m_SHPInput);
        if (this.m_Next != null) {
            int n;
            Object[] objectArray = this.m_DBFReader.nextRecord();
            for (n = 0; n < objectArray.length; ++n) {
                if (2 != this.m_FieldTypes[n]) continue;
                objectArray[n] = ((String)objectArray[n]).trim();
            }
            for (n = 0; n < this.m_Fields.length; ++n) {
                this.m_Next.addAttribute(this.m_Fields[n].getName(), String.valueOf(objectArray[n]).trim());
            }
        }
    }
}

