/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.map.view;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.map.FillData;
import com.elixirtech.map.IShape;
import com.elixirtech.map.Plot;
import com.elixirtech.map.model.MapFile;
import com.elixirtech.map.panel.IMapHost;
import com.elixirtech.map.view.IView;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PlotView
implements IView {
    private final IMapHost m_PlotPanel;
    private final MapFile m_MapFile;
    private Plot m_Plot;
    private Rectangle m_Rect;
    private AffineTransform m_Transform;
    private AffineTransform m_InverseTransform;
    private FillData m_FillData;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PlotView.class);

    public PlotView(IMapHost iMapHost, MapFile mapFile) {
        this.m_PlotPanel = iMapHost;
        this.m_MapFile = mapFile;
    }

    public IMapHost getPlotPanel() {
        return this.m_PlotPanel;
    }

    public void setFillData(FillData fillData) {
        this.m_FillData = fillData;
    }

    public void setPlot(Plot plot) {
        this.m_Plot = plot;
        this.m_Rect = null;
    }

    @Override
    public Rectangle doLayout(Rectangle rectangle) {
        if (this.m_Rect == null || !this.m_Rect.equals(rectangle)) {
            this.m_Rect = rectangle;
            this.buildTransform();
        }
        return rectangle;
    }

    public boolean hasPlot() {
        return this.m_Plot != null;
    }

    public Plot getPlot() {
        return this.m_Plot;
    }

    public IShape getShapeAt(Point point) {
        if (this.m_InverseTransform == null) {
            return null;
        }
        Point2D.Float float_ = new Point2D.Float();
        this.m_InverseTransform.transform(point, float_);
        return this.m_Plot.getShapeAt(float_);
    }

    public IShape getShape(int n) {
        return this.m_Plot.getShape(n);
    }

    public Rectangle getRectangle() {
        return this.m_Rect;
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.m_Plot != null) {
            AffineTransform affineTransform = graphics2D.getTransform();
            AffineTransform affineTransform2 = new AffineTransform(affineTransform);
            affineTransform2.concatenate(this.m_Transform);
            graphics2D.setTransform(affineTransform2);
            Color color = StandardColor.lookup(this.m_MapFile.getForegroundColor());
            Color color2 = StandardColor.lookup(this.m_MapFile.getLineColor());
            this.m_Plot.draw(graphics2D, color2, color, this.m_MapFile.getMapKey(), this.m_FillData);
            graphics2D.setTransform(affineTransform);
        }
    }

    public AffineTransform getTransform() {
        return this.m_Transform;
    }

    public AffineTransform getInverseTransform() {
        return this.m_InverseTransform;
    }

    protected void buildTransform() {
        if (this.m_Plot != null) {
            Rectangle2D rectangle2D = this.m_Plot.getBounds();
            this.m_Transform = new AffineTransform();
            this.m_Transform.translate(this.m_Rect.x, this.m_Rect.y);
            if (this.m_Plot.isOriginBottomLeft()) {
                this.m_Transform.translate(0.0, this.m_Rect.height);
                this.m_Transform.scale(1.0, -1.0);
            }
            double d = (double)this.m_Rect.width / rectangle2D.getWidth();
            double d2 = (double)this.m_Rect.height / rectangle2D.getHeight();
            double d3 = Math.min(d, d2);
            double d4 = ((double)this.m_Rect.width - d3 * rectangle2D.getWidth()) / 2.0;
            double d5 = ((double)this.m_Rect.height - d3 * rectangle2D.getHeight()) / 2.0;
            this.m_Transform.scale(d3, d3);
            this.m_Transform.translate(-rectangle2D.getX(), -rectangle2D.getY());
            this.m_Transform.translate(d4 / d3, d5 / d3);
            try {
                this.m_InverseTransform = this.m_Transform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                m_Log.error((Object)"Error creating inverse transform", (Throwable)noninvertibleTransformException);
            }
        } else {
            this.m_Transform = null;
            this.m_InverseTransform = null;
        }
    }
}

