/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc;

import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.Namespace;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.opc.Build;
import com.elixirtech.opc.Relationship;
import com.elixirtech.opc.XMLPart;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class RelationshipsPart
extends XMLPart {
    public static final String CONTENT_TYPE = "application/vnd.openxmlformats-package.relationships+xml";
    private int m_UniqueId;

    public RelationshipsPart(String string) {
        super(string, CONTENT_TYPE);
        this.setDocument(RelationshipsPart.buildDocument());
    }

    @Override
    public String addRelationship(Relationship relationship) {
        String string = this.nextUniqueId();
        relationship.setId(string);
        Element element = this.m_Document.getRootElement();
        Namespace namespace = element.getNamespace();
        element.addContent(RelationshipsPart.buildElement(namespace, relationship));
        return string;
    }

    public List<String> getRelIds() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Element element = this.m_Document.getRootElement();
        for (Element element2 : element.getChildren("Relationship", Build.NS_R)) {
            arrayList.add(element2.getAttributeValue("Id"));
        }
        return arrayList;
    }

    public String getTarget(String string) {
        Element element = this.getElement(string);
        if (element != null) {
            return element.getAttributeValue("Target");
        }
        return null;
    }

    public void removeRelationshipWithTarget(String string) {
        Element element = this.m_Document.getRootElement();
        for (Element element2 : element.getChildren("Relationship", Build.NS_R)) {
            if (!string.equals(element2.getAttributeValue("Target"))) continue;
            element.removeContent(element2);
            return;
        }
    }

    public void removeRelationship(String string) {
        Element element = this.getElement(string);
        if (element != null) {
            this.m_Document.getRootElement().removeContent(element);
        }
    }

    public String getPartName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("relId==null");
        }
        Element element = this.m_Document.getRootElement();
        for (Element element2 : element.getChildren("Relationship", Build.NS_R)) {
            String string2 = element2.getAttributeValue("Id");
            if (!string.equals(string2)) continue;
            return this.makeAbsolute(element2.getAttributeValue("Target"));
        }
        return null;
    }

    public void loadRelationships(InputStream inputStream) throws IOException {
        assert (this.m_UniqueId == 0) : "Can't load relationships after they have been explicitly added";
        Element element = this.m_Document.getRootElement();
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(inputStream);
            List<Element> list = document.getRootElement().getChildren("Relationship", Build.NS_R);
            for (Element element2 : list) {
                String string = element2.getAttributeValue("Id");
                String string2 = element2.getAttributeValue("Type");
                String string3 = element2.getAttributeValue("Target");
                String string4 = element2.getAttributeValue("TargetMode");
                Element element3 = new Element("Relationship", Build.NS_R);
                element3.setAttribute("Id", string);
                element3.setAttribute("Type", string2);
                element3.setAttribute("Target", string3);
                if (string4 != null) {
                    element3.setAttribute("TargetMode", string4);
                }
                element.addContent(element3);
            }
            this.m_UniqueId = list.size();
        }
        catch (JDOMException jDOMException) {
            throw new IOException("JDOMException: " + jDOMException);
        }
    }

    public void fillRelationships() {
        assert (this.m_UniqueId == 0) : "Can't fill relationships after they have been explicitly added";
        List<Element> list = this.m_Document.getRootElement().getChildren("Relationship", Build.NS_R);
        for (Element element : list) {
            String string = element.getAttributeValue("Id");
            if (!string.startsWith("rId")) continue;
            try {
                this.m_UniqueId = Math.max(this.m_UniqueId, Integer.parseInt(string.substring(3)));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected String nextUniqueId() {
        return "rId" + ++this.m_UniqueId;
    }

    protected static Document buildDocument() {
        Element element = new Element("Relationships", Build.NS_R);
        return new Document(element);
    }

    protected static Element buildElement(Namespace namespace, Relationship relationship) {
        Element element = new Element("Relationship", namespace);
        element.setAttribute("Id", relationship.getId());
        element.setAttribute("Type", relationship.getType());
        element.setAttribute("Target", relationship.getTarget());
        Relationship.TargetMode targetMode = relationship.getTargetMode();
        if (targetMode != Relationship.TargetMode.Internal) {
            element.setAttribute("TargetMode", targetMode.toString());
        }
        return element;
    }

    protected String makeAbsolute(String string) {
        if (string == null) {
            return string;
        }
        if (string.startsWith("/")) {
            return string;
        }
        String string2 = this.getName();
        int n = string2.indexOf("_rels");
        if (n >= 0) {
            return string2.substring(0, n) + string;
        }
        throw new IllegalStateException("RelationshipPart name must include _rels: " + string2);
    }

    protected Element getElement(String string) {
        Element element = this.m_Document.getRootElement();
        for (Element element2 : element.getChildren("Relationship", Build.NS_R)) {
            if (!string.equals(element2.getAttributeValue("Id"))) continue;
            return element2;
        }
        return null;
    }
}

