/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc;

import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.opc.BinaryPart;
import com.elixirtech.opc.ContentTypes;
import com.elixirtech.opc.OPCUtil;
import com.elixirtech.opc.Package;
import com.elixirtech.opc.Part;
import com.elixirtech.opc.RelationshipsPart;
import com.elixirtech.opc.XMLPart;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipReader {
    public static Package read(File file) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        return ZipReader.read(bufferedInputStream);
    }

    public static Package read(InputStream inputStream) throws IOException {
        Package package_ = ZipReader.readRaw(inputStream);
        return ZipReader.resolveContentTypes(package_);
    }

    public static Package readRaw(InputStream inputStream) throws IOException {
        ZipEntry zipEntry;
        Package package_ = new Package();
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            if (zipEntry.isDirectory()) continue;
            String string = zipEntry.getName();
            byte[] byArray = OPCUtil.loadBytes(zipInputStream);
            BinaryPart binaryPart = new BinaryPart("/" + string, "application/octet-stream", byArray);
            package_.addPart(binaryPart);
        }
        zipInputStream.close();
        return package_;
    }

    public static Package resolveContentTypes(Package package_) throws IOException {
        Part part = package_.getPart("/[Content_Types].xml");
        if (!(part instanceof BinaryPart)) {
            return package_;
        }
        Package package_2 = new Package();
        ArrayList<XMLPart> arrayList = new ArrayList<XMLPart>();
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(((BinaryPart)part).getByteStream());
            ContentTypes contentTypes = new ContentTypes(document);
            package_2.addPart(contentTypes);
            for (Part part2 : package_.getParts()) {
                if ("application/octet-stream".equals(part2.getContentType())) {
                    Document document2;
                    XMLPart xMLPart;
                    if (part2 == contentTypes) continue;
                    String string = contentTypes.getContentType(part2.getName());
                    if (string.equals("application/vnd.openxmlformats-package.relationships+xml")) {
                        xMLPart = new RelationshipsPart(part2.getName());
                        document2 = sAXBuilder.build(((BinaryPart)part2).getByteStream());
                        xMLPart.setDocument(document2);
                        arrayList.add(xMLPart);
                        continue;
                    }
                    if (string.endsWith("xml")) {
                        xMLPart = new XMLPart(part2.getName(), string);
                        document2 = sAXBuilder.build(((BinaryPart)part2).getByteStream());
                        xMLPart.setDocument(document2);
                        package_2.addPart(xMLPart);
                        continue;
                    }
                    package_2.addPart(part2);
                    continue;
                }
                package_2.addPart(part2);
            }
            for (RelationshipsPart relationshipsPart : arrayList) {
                ZipReader.setRelationships(package_2, relationshipsPart);
            }
            return package_2;
        }
        catch (JDOMException jDOMException) {
            IOException iOException = new IOException("Error reading contentTypes");
            iOException.initCause(jDOMException);
            throw iOException;
        }
    }

    private static void setRelationships(Package package_, RelationshipsPart relationshipsPart) {
        String string = relationshipsPart.getName();
        if (!string.endsWith(".rels")) {
            throw new IllegalStateException("Name must end with .rels: " + string);
        }
        if (string.equals("/_rels/.rels")) {
            package_.setRelationships(relationshipsPart);
        } else {
            String string2 = string.substring(0, string.length() - 5);
            String[] stringArray = string2.split("/");
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < stringArray.length; ++i) {
                if (i == stringArray.length - 2) continue;
                stringBuilder.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuilder.append('/');
            }
            String string3 = stringBuilder.toString();
            package_.getPart(string3).setRelationships(relationshipsPart);
        }
    }

    public static class FileFormatException
    extends IOException {
        public FileFormatException() {
            super("This file is not an Open Packaging Convention file (eg. DOCX, XLSX, PPTX)");
        }

        public FileFormatException(String string) {
            super(string);
        }

        @Override
        public String toString() {
            return "File format error";
        }
    }
}

