/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.util;

import com.elixirtech.jdom.Document;
import com.elixirtech.jdom.Element;
import com.elixirtech.jdom.JDOMException;
import com.elixirtech.jdom.input.SAXBuilder;
import com.elixirtech.opc.OPCUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;

public class Snippet {
    private final String m_ResourceName;
    private final String m_Data;

    public Snippet(String string) throws IOException {
        this.m_ResourceName = string;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
        StringWriter stringWriter = new StringWriter();
        OPCUtil.copyStream(inputStreamReader, stringWriter, false);
        this.m_Data = stringWriter.toString();
    }

    public Element getElement(Map<String, String> map) throws IOException {
        String string = OPCUtil.substitute(this.m_Data, map);
        SAXBuilder sAXBuilder = new SAXBuilder();
        try {
            Document document = sAXBuilder.build(new StringReader(string));
            Element element = document.getRootElement();
            element.detach();
            return element;
        }
        catch (JDOMException jDOMException) {
            IOException iOException = new IOException("Error processing " + this.m_ResourceName);
            iOException.initCause(jDOMException);
            throw iOException;
        }
    }
}

