/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.xls.style;

import com.elixirtech.jdom.Element;
import com.elixirtech.opc.Build;
import com.elixirtech.opc.xls.CellUtil;
import java.awt.Color;

public class Font {
    public final String name;
    public final Color color;
    public final int size;
    public final boolean bold;
    public final boolean italic;

    public Font(String string, int n) {
        this(string, n, false, false);
    }

    public Font(String string, int n, boolean bl, boolean bl2) {
        assert (string != null);
        this.name = string;
        this.size = n;
        this.bold = bl;
        this.italic = bl2;
        this.color = null;
    }

    public Font(String string, int n, boolean bl, boolean bl2, Color color) {
        assert (string != null);
        this.name = string;
        this.size = n;
        this.bold = bl;
        this.italic = bl2;
        this.color = color;
    }

    public Element getElement() {
        Element element = new Element("font", Build.NS_S);
        if (this.bold) {
            element.addContent(new Element("b", "http://schemas.openxmlformats.org/spreadsheetml/2006/main"));
        }
        if (this.italic) {
            element.addContent(new Element("i", "http://schemas.openxmlformats.org/spreadsheetml/2006/main"));
        }
        Element element2 = new Element("sz", Build.NS_S);
        Element element3 = new Element("name", Build.NS_S);
        element2.setAttribute("val", String.valueOf(this.size));
        element3.setAttribute("val", this.name);
        element.addContent(element2);
        element.addContent(element3);
        if (this.color != null && (this.color.getRGB() & 0xFFFFFF) != 0) {
            Element element4 = new Element("color", Build.NS_S);
            element4.setAttribute("rgb", CellUtil.ARGB(this.color));
            element.addContent(element4);
        }
        return element;
    }

    public boolean equals(Object object) {
        if (object instanceof Font) {
            Font font = (Font)object;
            return this.name.equals(font.name) && this.size == font.size && this.bold == font.bold && this.italic == font.italic && Font.equals(this.color, font.color);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() + this.size + (this.bold ? 200 : 0) + (this.italic ? 400 : 0) + Font.hash(this.color);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        stringBuilder.append(", ");
        stringBuilder.append(this.color);
        stringBuilder.append(", ");
        stringBuilder.append(this.size);
        stringBuilder.append(", ");
        stringBuilder.append(this.bold);
        stringBuilder.append(", ");
        stringBuilder.append(this.italic);
        stringBuilder.append(", ");
        return stringBuilder.toString();
    }

    private static boolean equals(Color color, Color color2) {
        if (color == null) {
            return color2 == null;
        }
        return color.equals(color2);
    }

    private static int hash(Color color) {
        if (color == null) {
            return 1;
        }
        return color.hashCode();
    }
}

