/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.opc.xls.style;

import com.elixirtech.jdom.Element;
import com.elixirtech.opc.Build;
import com.elixirtech.opc.xls.Styles;
import com.elixirtech.opc.xls.style.Fill;
import com.elixirtech.opc.xls.style.Font;
import com.elixirtech.opc.xls.style.FontManager;
import com.elixirtech.opc.xls.style.Format;

public class XF {
    public static final int ALIGN_UNKNOWN = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_CENTER = 2;
    public static final int ALIGN_RIGHT = 3;
    public static final int ALIGN_TOP = 4;
    public static final int ALIGN_BOTTOM = 5;
    private Font m_Font = FontManager.DEFAULT_FONT;
    private Format m_Format = null;
    private Fill m_Fill = null;
    private int m_HAlignment;
    private int m_VAlignment;

    public void setFont(Font font) {
        this.m_Font = font;
    }

    public void setFormat(Format format) {
        this.m_Format = format;
    }

    public void setFill(Fill fill) {
        this.m_Fill = fill;
    }

    public void setHAlignment(int n) {
        this.m_HAlignment = n;
    }

    public void setVAlignment(int n) {
        this.m_VAlignment = n;
    }

    public boolean equals(Object object) {
        if (object instanceof XF) {
            XF xF = (XF)object;
            return this.m_Font.equals(xF.m_Font) && this.equals(this.m_Format, xF.m_Format) && this.equals(this.m_Fill, xF.m_Fill) && this.m_HAlignment == xF.m_HAlignment && this.m_VAlignment == xF.m_VAlignment;
        }
        return false;
    }

    private boolean equals(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    public int hashCode() {
        return this.m_Font.hashCode() + this.m_Format.hashCode() * 11 + this.m_Fill.hashCode() * 23 + this.m_HAlignment * 171 + this.m_VAlignment * 233;
    }

    public Element getElement(Styles styles) {
        String string = null;
        try {
            if (this.m_Format != null && Integer.parseInt(this.m_Format.code) > 0) {
                string = this.m_Format.code;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (string == null) {
            string = String.valueOf(styles.getFormatIndex(this.m_Format));
        }
        Element element = new Element("xf", Build.NS_S);
        element.setAttribute("numFmtId", string);
        element.setAttribute("fontId", String.valueOf(styles.getFontIndex(this.m_Font)));
        element.setAttribute("fillId", String.valueOf(styles.getFillIndex(this.m_Fill)));
        element.setAttribute("borderId", "0");
        element.setAttribute("xfId", "0");
        if (this.hasNumberFormat()) {
            element.setAttribute("applyNumberFormat", "1");
        }
        if (this.hasFill()) {
            element.setAttribute("applyFill", "1");
        }
        if (this.m_HAlignment != 0 || this.m_VAlignment != 0) {
            Element element2 = new Element("alignment", Build.NS_S);
            switch (this.m_HAlignment) {
                case 1: {
                    element2.setAttribute("horizontal", "left");
                    break;
                }
                case 2: {
                    element2.setAttribute("horizontal", "center");
                    break;
                }
                case 3: {
                    element2.setAttribute("horizontal", "right");
                    break;
                }
            }
            switch (this.m_VAlignment) {
                case 4: {
                    element2.setAttribute("vertical", "left");
                    break;
                }
                case 2: {
                    element2.setAttribute("vertical", "center");
                    break;
                }
                case 5: {
                    element2.setAttribute("vertical", "right");
                    break;
                }
            }
            element.addContent(element2);
        }
        return element;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(this.m_Font));
        stringBuilder.append(", ");
        stringBuilder.append(this.m_Format);
        stringBuilder.append(", ");
        stringBuilder.append(this.m_Fill);
        stringBuilder.append(", ");
        stringBuilder.append(this.m_HAlignment);
        stringBuilder.append(", ");
        stringBuilder.append(this.m_VAlignment);
        return stringBuilder.toString();
    }

    private boolean hasNumberFormat() {
        return this.m_Format != null;
    }

    private boolean hasFill() {
        return this.m_Fill != null;
    }
}

