/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.pdf;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.GraphicsCodes;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Image;
import com.elixirtech.glint.Pen;
import com.elixirtech.glint.g2d.Glint2DContext;
import com.elixirtech.glint.g2d.URLMap;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GRectangle;
import com.elixirtech.rtf.RtfGraphicsWalker;
import com.elixirtech.rtf.RtfGroup;
import com.elixirtech.rtf.RtfReader;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.io.ByteArrayInputStream;

public class PDFGlint
implements IGlint,
GraphicsCodes {
    private Graphics2D g;
    private Glint2DContext cxt;
    private int m_Width;
    private int m_Height;
    private int m_Orientation;
    private AffineTransform m_Transform = new AffineTransform();
    private static final BasicStroke PLAIN_STROKE = new BasicStroke(20.0f);
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PDFGlint.class);

    public PDFGlint(PdfWriter pdfWriter, FontMapper fontMapper, Graphics2D graphics2D) {
        this.g = graphics2D;
        this.cxt = new Glint2DContext(graphics2D);
    }

    @Override
    public void init(int n, int n2, int n3) {
        this.m_Width = n;
        this.m_Height = n2;
        this.m_Orientation = n3;
        this.g.scale(0.05, 0.05);
    }

    @Override
    public int getWidth() {
        return this.m_Width;
    }

    @Override
    public int getHeight() {
        return this.m_Height;
    }

    @Override
    public int getOrientation() {
        return this.m_Orientation;
    }

    public URLMap getURLMap() {
        return this.cxt.getURLMap();
    }

    @Override
    public IGlint.FontId defineFont(Font font) {
        return this.cxt.addFont(font);
    }

    @Override
    public IGlint.ColorId defineColor(com.elixirtech.glint.Color color) {
        return this.cxt.addColor(color);
    }

    @Override
    public IGlint.ImageId defineImage(Image image) {
        IGlint.ImageId imageId = this.cxt.addImage(image);
        return imageId;
    }

    @Override
    public IGlint.PenId definePen(Pen pen) {
        return this.cxt.addPen(pen);
    }

    @Override
    public IGlint.StringId defineString() {
        return this.cxt.addString();
    }

    @Override
    public void setString(IGlint.StringId stringId, String string) {
        this.cxt.setString(stringId, string);
    }

    @Override
    public Font getFont(IGlint.FontId fontId) {
        return this.cxt.getFont(fontId);
    }

    @Override
    public com.elixirtech.glint.Color getColor(IGlint.ColorId colorId) {
        return this.cxt.getColor(colorId);
    }

    @Override
    public Image getImage(IGlint.ImageId imageId) {
        return this.cxt.getImage(imageId);
    }

    @Override
    public Pen getPen(IGlint.PenId penId) {
        return this.cxt.getPen(penId);
    }

    @Override
    public String getString(IGlint.StringId stringId) {
        return this.cxt.getString(stringId);
    }

    @Override
    public void drawLine(IGlint.PenId penId, int n, int n2, int n3, int n4) {
        this.cxt.setPen(penId);
        this.g.drawLine(n, n2, n3, n4);
    }

    @Override
    public void drawPolyline(IGlint.PenId penId, int[] nArray, int[] nArray2) {
        this.cxt.setPen(penId);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(nArray[0], nArray2[0]);
        for (int i = 1; i < nArray.length; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        this.g.draw(generalPath);
    }

    @Override
    public void drawRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        this.drawCellRect(penId, colorId, n, n2, n3, n4, 15);
    }

    @Override
    public void drawCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        GRectangle gRectangle = new GRectangle(rectangle);
        if (colorId.id != 0) {
            gRectangle.setBackground(this.cxt.getColor(colorId).getAWTColor());
        }
        if (penId.id != 0) {
            Pen pen = this.cxt.getPen(penId);
            gRectangle.setBorder(BorderStyle.get(pen.getStyle()), pen.getWidth(), pen.getColor().getAWTColor(), n5);
        }
        gRectangle.draw(this.g);
        this.addURLShape(this.cxt, gRectangle.getShape());
    }

    @Override
    public void drawRoundRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6) {
        this.drawRoundCellRect(penId, colorId, n, n2, n3, n4, n5, n6, 15);
    }

    @Override
    public void drawRoundCellRect(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        Rectangle rectangle = new Rectangle(n, n2, n3, n4);
        GRectangle gRectangle = new GRectangle(rectangle);
        if (colorId.id != 0) {
            gRectangle.setBackground(this.cxt.getColor(colorId).getAWTColor());
        }
        if (penId.id != 0) {
            Pen pen = this.cxt.getPen(penId);
            gRectangle.setBorder(BorderStyle.get(pen.getStyle()), pen.getWidth(), pen.getColor().getAWTColor(), n7);
            gRectangle.setBorderRadius(n5, n6);
        }
        gRectangle.draw(this.g);
        this.addURLShape(this.cxt, gRectangle.getShape());
    }

    @Override
    public void drawEllipse(IGlint.PenId penId, IGlint.ColorId colorId, int n, int n2, int n3, int n4) {
        Ellipse2D.Float float_ = new Ellipse2D.Float(n, n2, n3, n4);
        this.render(penId, colorId, float_);
    }

    @Override
    public void drawPolygon(IGlint.PenId penId, IGlint.ColorId colorId, int[] nArray, int[] nArray2) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(nArray[0], nArray2[0]);
        for (int i = 1; i < nArray.length; ++i) {
            generalPath.lineTo(nArray[i], nArray2[i]);
        }
        generalPath.closePath();
        this.render(penId, colorId, generalPath);
    }

    @Override
    public void drawImage(IGlint.ImageId imageId, int n, int n2) {
        Image image = this.cxt.getImage(imageId);
        int n3 = image.getWidth() * 20;
        int n4 = image.getHeight() * 20;
        this.g.drawImage(image.asAWTImage(), n, n2, n3, n4, null);
        if (this.cxt.hasURL()) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void drawScaledImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4) {
        Image image = this.cxt.getImage(imageId);
        this.g.drawImage(image.asAWTImage(), n, n2, n + n3, n2 + n4, 0, 0, image.getWidth(), image.getHeight(), null);
        if (this.cxt.hasURL()) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void drawSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6) {
        Image image = this.cxt.getImage(imageId);
        this.g.drawImage(image.asAWTImage(), n, n2, n + n5 * 20, n2 + n6 * 20, n3, n4, n3 + n5, n4 + n6, null);
        if (this.cxt.hasURL()) {
            Rectangle rectangle = new Rectangle(n, n2, n5 * 20, n6 * 20);
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void drawScaledSubImage(IGlint.ImageId imageId, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        Image image = this.cxt.getImage(imageId);
        this.g.drawImage(image.asAWTImage(), n, n2, n + n3, n2 + n4, n5, n6, n5 + n7, n6 + n8, null);
        if (this.cxt.hasURL()) {
            Rectangle rectangle = new Rectangle(n, n2, n3, n4);
            this.addURLShape(this.cxt, rectangle);
        }
    }

    @Override
    public void offsetOrigin(int n, int n2) {
        this.g.translate(n, n2);
        this.m_Transform.translate(n, n2);
    }

    @Override
    public void setOrigin(int n, int n2) {
        int n3 = (int)this.m_Transform.getTranslateX();
        int n4 = (int)this.m_Transform.getTranslateY();
        this.g.translate(-n3 + n, -n4 + n2);
        this.m_Transform.translate(-n3 + n, -n4 + n2);
    }

    @Override
    public int getOriginX() {
        return (int)this.m_Transform.getTranslateX();
    }

    @Override
    public int getOriginY() {
        return (int)this.m_Transform.getTranslateY();
    }

    @Override
    public void setURL(String string, String string2) {
        this.cxt.setURL(string, string2);
    }

    @Override
    public void resetURL() {
        this.cxt.resetURL();
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4) {
        this.cxt.pushClip(this.g.getClip());
        this.g.clipRect(n, n2, n3, n4);
    }

    @Override
    public void pushClip(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.cxt.pushClip(this.g.getClipBounds());
        GRectangle gRectangle = new GRectangle(new Rectangle(n, n2, n3, n4));
        gRectangle.setBorderRadius(n5, n6);
        gRectangle.setBorder(BorderStyle.SOLID, 0, Color.BLACK, n7);
        Shape shape = gRectangle.getShape();
        this.g.clip(shape);
    }

    @Override
    public void popClip() {
        Shape shape = this.cxt.popClip();
        this.g.setClip(shape);
    }

    @Override
    public void drawText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
        try {
            this.cxt.setFont(fontId);
            this.cxt.setColor(colorId.id);
            this.g.translate(n, n2);
            this.g.scale(20.0, 20.0);
            FontMetrics fontMetrics = this.g.getFontMetrics();
            int n4 = fontMetrics.stringWidth(string);
            if (this.cxt.isFontUnderlined()) {
                this.g.setStroke(PLAIN_STROKE);
            }
            if (n3 == 1) {
                this.g.drawString(string, 0, 0);
                if (this.cxt.isFontUnderlined()) {
                    this.g.drawLine(0, 1, n4, 1);
                }
            } else if (n3 == 2) {
                this.g.drawString(string, -n4, 0);
                if (this.cxt.isFontUnderlined()) {
                    this.g.drawLine(-n4, 1, 0, 1);
                }
            } else if (n3 == 3) {
                this.g.drawString(string, -n4 / 2, 0);
                if (this.cxt.isFontUnderlined()) {
                    this.g.drawLine(-n4 / 2, 1, n4 / 2, 1);
                }
            }
            this.g.scale(0.05, 0.05);
            this.g.translate(-n, -n2);
            if (this.cxt.hasURL()) {
                int n5 = fontMetrics.getHeight();
                Rectangle rectangle = new Rectangle(n, n2 - n5, n4, n5);
                this.addURLShape(this.cxt, rectangle);
            }
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error in drawText(" + fontId.id + "," + colorId.id + "," + n + "," + n2 + "," + n3 + "," + string + ") : " + exception), (Throwable)exception);
        }
    }

    @Override
    public void drawJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, String string) {
    }

    @Override
    public void drawRotatedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
        try {
            this.cxt.setFont(fontId);
            this.cxt.setColor(colorId.id);
            FontMetrics fontMetrics = this.g.getFontMetrics();
            double d = (double)(-n4) * Math.PI / 180.0;
            this.g.translate(n, n2);
            this.g.rotate(d, 0.0, 0.0);
            this.g.scale(20.0, 20.0);
            int n5 = fontMetrics.stringWidth(string);
            if (this.cxt.isFontUnderlined()) {
                this.g.setStroke(PLAIN_STROKE);
            }
            if (n3 == 1) {
                this.g.drawString(string, 0, 0);
                if (this.cxt.isFontUnderlined()) {
                    this.g.drawLine(0, 1, n5, 1);
                }
            } else if (n3 == 2) {
                this.g.drawString(string, -n5, 0);
                if (this.cxt.isFontUnderlined()) {
                    this.g.drawLine(-n5, 1, 0, 1);
                }
            } else if (n3 == 3) {
                this.g.drawString(string, -n5 / 2, 0);
                if (this.cxt.isFontUnderlined()) {
                    this.g.drawLine(-n5 / 2, 1, n5 / 2, 1);
                }
            }
            this.g.scale(0.05, 0.05);
            this.g.rotate(-d, 0.0, 0.0);
            this.g.translate(-n, -n2);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error in drawRotatedText(" + fontId.id + "," + colorId.id + "," + n + "," + n2 + "," + n3 + "," + n4 + "," + string + ") : " + exception), (Throwable)exception);
        }
    }

    @Override
    public void drawRotatedJustifiedText(IGlint.FontId fontId, IGlint.ColorId colorId, int n, int n2, int n3, int n4, String string) {
    }

    @Override
    public void drawRTF(int n, int n2, int n3, int n4, String string) {
        try {
            byte[] byArray = string.getBytes("UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            RtfReader rtfReader = new RtfReader(byteArrayInputStream);
            RtfGroup rtfGroup = rtfReader.getTreeRoot();
            Rectangle rectangle = new Rectangle(n / 20, n2 / 20, n3 / 20, n4 / 20);
            this.g.scale(20.0, 20.0);
            RtfGraphicsWalker rtfGraphicsWalker = new RtfGraphicsWalker(rectangle, this.g);
            rtfGroup.walk(rtfGraphicsWalker);
            this.g.scale(0.05, 0.05);
        }
        catch (Exception exception) {
            m_Log.error((Object)("Error in drawRTF(): " + exception), (Throwable)exception);
        }
    }

    @Override
    public void flush() {
        this.g.scale(20.0, 20.0);
    }

    private void render(IGlint.PenId penId, IGlint.ColorId colorId, Shape shape) {
        if (colorId.id != 0) {
            this.cxt.setColor(colorId.id);
            this.cxt.g.fill(shape);
        }
        if (penId.id != 0) {
            this.cxt.setPen(penId);
            this.cxt.g.draw(shape);
        }
        this.addURLShape(this.cxt, shape);
    }

    private void addURLShape(Glint2DContext glint2DContext, Shape shape) {
        shape = this.m_Transform.createTransformedShape(shape);
        glint2DContext.addURLShape(shape);
    }
}

