/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.property;

import com.elixirtech.i18n.Name;
import com.elixirtech.property.PropertyNode;
import java.util.ArrayList;
import java.util.List;

public class PropertyGroup
extends PropertyNode {
    private final Name m_Name;
    private boolean m_IsExpanded;
    private final List<PropertyNode> m_Children = new ArrayList<PropertyNode>();

    public PropertyGroup(Name name) {
        this.m_Name = name;
    }

    @Override
    public Name getName() {
        return this.m_Name;
    }

    @Override
    public String getLabel() {
        return this.m_Name.getLabel();
    }

    public void addChild(PropertyNode propertyNode) {
        if (!propertyNode.getLabel().startsWith(this.m_Name.getLabel())) {
            throw new IllegalArgumentException("Bad child: " + propertyNode.getName().getLabel() + " of " + this.getLabel());
        }
        this.m_Children.add(propertyNode);
    }

    @Override
    public int getChildCount() {
        return this.m_Children.size();
    }

    @Override
    public PropertyNode getChild(int n) {
        return this.m_Children.get(n);
    }

    @Override
    public boolean isExpanded() {
        return this.m_IsExpanded;
    }

    public void setExpanded(boolean bl) {
        this.m_IsExpanded = bl;
    }

    public void toggleExpand() {
        this.m_IsExpanded = !this.m_IsExpanded;
    }
}

