/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.data;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.AbstractDataSource;
import com.elixirtech.data2.DataListener;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.PushContext;
import com.elixirtech.data2.grouping.GroupDataSource2;
import com.elixirtech.data2.grouping.GroupDefinition;
import java.util.concurrent.atomic.AtomicInteger;

public class RecordSource
extends AbstractDataSource {
    private PushContext m_PushContext;
    private IDataSource m_ParentDataSource;
    private DataTable m_DataTable;
    private GroupDataSource2 m_GroupDataSource;
    private final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RecordSource.class);
    private static AtomicInteger m_TabulateId = new AtomicInteger();

    public RecordSource(PushContext pushContext, IDataSource iDataSource) {
        this.m_PushContext = pushContext;
        this.m_ParentDataSource = iDataSource;
    }

    public IDataSource getSource() {
        if (this.m_DataTable != null) {
            return this.m_DataTable;
        }
        return this.m_ParentDataSource;
    }

    public void setSortField(String string, String string2, String string3, String string4) {
        this.tabulate();
        GroupDefinition groupDefinition = new GroupDefinition(string, string2, string3, string4);
        this.m_GroupDataSource.group(groupDefinition);
    }

    public void sortAndGroup(PushContext pushContext) {
        if (this.m_DataTable != null && this.m_GroupDataSource.getGroupCount() > 0) {
            this.m_GroupDataSource.doGrouping(pushContext);
            this.m_DataTable.setGroups(this.m_GroupDataSource.getGroups());
        }
    }

    public void tabulate() {
        if (this.m_DataTable == null) {
            int n = m_TabulateId.incrementAndGet();
            this.m_Log.debug((Object)("Tabulating data begin " + n));
            this.m_Log.info((Object)("Tabulating " + this.m_ParentDataSource.getType()));
            this.m_DataTable = DataTable.build(this.m_PushContext, this.m_ParentDataSource);
            this.m_Log.debug((Object)("Tabulating data end " + n));
            this.m_DataTable.setDescription("");
            this.m_ParentDataSource = null;
            this.m_GroupDataSource = new GroupDataSource2("ER", this.m_DataTable);
        }
    }

    public void dispose() {
        this.m_PushContext = null;
        this.m_ParentDataSource = null;
        this.m_DataTable = null;
        this.m_GroupDataSource = null;
    }

    @Override
    public String getName() {
        if (this.m_DataTable != null) {
            return this.m_DataTable.getName();
        }
        return this.m_ParentDataSource.getName();
    }

    @Override
    public String getDescription() {
        if (this.m_DataTable != null) {
            return this.m_DataTable.getDescription();
        }
        return this.m_ParentDataSource.getDescription();
    }

    @Override
    public String getType() {
        if (this.m_DataTable != null) {
            return this.m_DataTable.getType();
        }
        return this.m_ParentDataSource.getType();
    }

    @Override
    public DataSchema getSchema() {
        if (this.m_DataTable != null) {
            return this.m_DataTable.getSchema();
        }
        return this.m_ParentDataSource.getSchema();
    }

    @Override
    public void pushTo(PushContext pushContext, DataListener dataListener) {
        if (this.m_DataTable != null) {
            this.m_DataTable.pushTo(pushContext, dataListener);
        } else {
            this.m_ParentDataSource.pushTo(pushContext, dataListener);
        }
    }
}

