/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.EyeRenderer;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RenderDetails;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.MemoryCacheImageOutputStream;

public class ImagePageListener
implements PageListener {
    private Result m_Result;
    private MimeType m_MimeType;
    private ImageWriter m_ImageWriter;
    private EyeRenderer m_Renderer;
    private ZipOutputStream m_ZipOutputStream;
    private int m_DPI = 72;
    private boolean m_Greyscale;
    private int m_Type;
    private int m_PageCount;

    public ImagePageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        Iterator<ImageWriter> iterator;
        this.m_MimeType = this.m_Result.getMimeType();
        if (MimeTypes.isArchiveMimeType((MimeType)this.m_MimeType)) {
            this.m_MimeType = MimeTypes.getContents((MimeType)this.m_MimeType);
        }
        if (!(iterator = ImageIO.getImageWritersByMIMEType(this.m_MimeType.value())).hasNext()) {
            throw new RenderException("Invalid MimeType: " + this.m_MimeType + " for ImagePipeline");
        }
        this.m_ImageWriter = iterator.next();
        this.m_Renderer = new EyeRenderer(true);
        RenderDetails renderDetails = pageSource.getRenderDetails();
        this.m_Greyscale = renderDetails.isSet("Greyscale");
        try {
            this.m_DPI = Integer.parseInt(renderDetails.getParameterValue("DPI"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        MimeType mimeType = this.m_Result.getMimeType();
        this.m_Type = MimeTypes.WBMP().equals((Object)mimeType) || MimeTypes.WBMP_ZIP().equals((Object)mimeType) ? 12 : (this.m_Greyscale ? 10 : (MimeTypes.JPEG().equals((Object)mimeType) || MimeTypes.JPEG_ZIP().equals((Object)mimeType) ? 1 : (MimeTypes.BMP().equals((Object)mimeType) || MimeTypes.BMP_ZIP().equals((Object)mimeType) ? 1 : 2)));
        this.m_Renderer.startReport(pageSource);
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void addPage(Page page) throws RenderException {
        if (!MimeTypes.isArchiveMimeType((MimeType)this.m_Result.getMimeType())) {
            if (this.m_PageCount == 0) {
                try {
                    this.writeImage(this.m_Result.getOutputStream(), page, 0);
                }
                catch (IOException iOException) {
                    throw new RenderException("Can't write single image: " + iOException, iOException);
                }
            }
            ++this.m_PageCount;
            return;
        }
        PageSetup pageSetup = page.getPageSetup();
        int n = pageSetup.getHorizontalPageCount();
        for (int i = 0; i < n; ++i) {
            String string = "Page " + (this.m_PageCount + 1);
            if (n > 1) {
                string = string + "_" + (i + 1);
            }
            string = string + this.getExtension(this.m_ImageWriter);
            try {
                if (this.m_ZipOutputStream == null) {
                    this.m_ZipOutputStream = new ZipOutputStream(this.m_Result.getOutputStream());
                }
                ZipEntry zipEntry = new ZipEntry(string);
                this.m_ZipOutputStream.putNextEntry(zipEntry);
                this.writeImage(this.m_ZipOutputStream, page, i);
                this.m_Renderer.disposeCache();
            }
            catch (IOException iOException) {
                throw new RenderException("Can't write image: " + iOException, iOException);
            }
            ++this.m_PageCount;
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        try {
            if (this.m_ZipOutputStream != null) {
                this.m_ZipOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new RenderException("Error closing stream: " + iOException, iOException);
        }
        this.m_ImageWriter = null;
        this.m_Renderer = null;
        this.m_Result = null;
        this.m_ZipOutputStream = null;
    }

    protected void writeImage(OutputStream outputStream, Page page, int n) throws IOException {
        MemoryCacheImageOutputStream memoryCacheImageOutputStream = new MemoryCacheImageOutputStream(outputStream);
        BufferedImage bufferedImage = this.m_Renderer.renderPageToImage(page, n, this.m_DPI, this.m_Type);
        this.m_ImageWriter.setOutput(memoryCacheImageOutputStream);
        ImageWriteParam imageWriteParam = this.m_ImageWriter.getDefaultWriteParam();
        this.m_ImageWriter.write(null, new IIOImage(bufferedImage, null, null), imageWriteParam);
        memoryCacheImageOutputStream.flush();
    }

    protected String getExtension(ImageWriter imageWriter) {
        ImageWriterSpi imageWriterSpi = imageWriter.getOriginatingProvider();
        String[] stringArray = imageWriterSpi.getFileSuffixes();
        if (stringArray.length == 0) {
            return "";
        }
        return "." + stringArray[0];
    }
}

