/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.html.HTMLOutputter;
import com.elixirtech.report2.html.PlainHTMLGenerator;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.raw.model.RenderDetails;
import java.io.IOException;
import java.io.OutputStream;

public class PlainHTMLPageListener
implements PageListener {
    private Result m_Result;
    private PlainHTMLGenerator m_Generator;
    private OutputStream m_Out;

    public PlainHTMLPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        this.m_Generator = this.getGenerator(pageSource);
        try {
            this.m_Out = this.m_Result.getOutputStream();
        }
        catch (IOException iOException) {
            throw new RenderException("Error opening output stream: " + iOException, iOException);
        }
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void addPage(Page page) throws RenderException {
        this.m_Generator.renderPage(page);
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        try {
            this.m_Generator.writePages(this.m_Out);
            this.m_Out.flush();
            this.m_Out.close();
        }
        catch (IOException iOException) {
            throw new RenderException("Error writing page: " + iOException, iOException);
        }
        this.m_Result = null;
        this.m_Generator = null;
        this.m_Out = null;
    }

    protected PlainHTMLGenerator getGenerator(PageSource pageSource) {
        boolean bl = false;
        RenderDetails renderDetails = pageSource.getRenderDetails();
        bl = "Yes".equals(renderDetails.getParameterValue("SkipHeaders"));
        return new PlainHTMLGenerator(pageSource.getLogicalReport(), new HTMLOutputter(bl));
    }
}

