/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine;

import com.elixirtech.glint.g2d.GlintGraphics2D;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.EyeRenderer;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.engine.Result;
import com.elixirtech.report2.engine.SVGNavigator;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.raw.model.PageSetup;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGPageListener
implements PageListener {
    private Result m_Result;
    private ZipOutputStream m_Zip;
    private EyeRenderer m_Renderer;
    private int m_PageNo;

    public SVGPageListener(Result result) {
        this.m_Result = result;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        try {
            this.m_Zip = new ZipOutputStream(this.m_Result.getOutputStream());
            this.m_Renderer = new EyeRenderer(true);
            this.m_Renderer.disableTotalId();
            this.m_Renderer.startReport(pageSource);
        }
        catch (IOException iOException) {
            throw new RenderException("Error opening stream: " + iOException, iOException);
        }
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void addPage(Page page) throws RenderException {
        try {
            PageSetup pageSetup = page.getPageSetup();
            int n = pageSetup.getHorizontalPageCount();
            for (int i = 0; i < n; ++i) {
                ++this.m_PageNo;
                ZipEntry zipEntry = new ZipEntry("page" + this.m_PageNo + ".svg");
                this.m_Zip.putNextEntry(zipEntry);
                DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
                Document document = dOMImplementation.createDocument(null, "svg", null);
                SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document);
                GlintGraphics2D glintGraphics2D = new GlintGraphics2D((Graphics2D)sVGGraphics2D);
                this.m_Renderer.renderPage(page, i, glintGraphics2D);
                sVGGraphics2D.setSVGCanvasSize(new Dimension(pageSetup.getWidth() / 20, pageSetup.getHeight() / 20));
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)this.m_Zip, "UTF-8");
                sVGGraphics2D.stream((Writer)outputStreamWriter, false);
                outputStreamWriter.flush();
                this.m_Renderer.disposeCache();
                this.m_Zip.closeEntry();
            }
        }
        catch (IOException iOException) {
            throw new RenderException("Error writing page: " + iOException, iOException);
        }
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        try {
            SVGNavigator sVGNavigator = new SVGNavigator();
            sVGNavigator.render(this.m_Zip, this.m_PageNo, null);
            this.m_Zip.flush();
            this.m_Zip.close();
        }
        catch (IOException iOException) {
            throw new RenderException("Error closing stream: " + iOException, iOException);
        }
        this.m_Result = null;
        this.m_Zip = null;
        this.m_Renderer = null;
    }
}

