/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine.pl;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class LogicalReportPageListener
implements PageListener {
    private LogicalReport m_Logical;
    private PageSequence m_CurrentPageSequence;

    public LogicalReport getLogicalReport() {
        return this.m_Logical;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        this.m_Logical = pageSource.getLogicalReport();
        if (this.m_Logical == null) {
            this.m_Logical = new LogicalReport();
        }
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
        this.m_Logical.addPageSequence(pageSequence);
        this.m_CurrentPageSequence = pageSequence;
    }

    @Override
    public void addPage(Page page) throws RenderException {
        this.m_CurrentPageSequence.addPage(page);
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
        this.m_CurrentPageSequence = null;
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        this.buildPageCounts();
    }

    private void buildPageCounts() throws RenderException {
        ArrayList<Page> arrayList = new ArrayList<Page>();
        int n = 1;
        Iterator<PageSequence> iterator = this.m_Logical.getPageSequenceIterator();
        while (iterator.hasNext()) {
            PageSequence pageSequence = iterator.next();
            if (pageSequence.isResetPageCount()) {
                this.setCount(arrayList);
                arrayList.clear();
                n = 1;
            }
            List<Page> list = pageSequence.getPageList();
            arrayList.addAll(list);
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                Page page = list.get(i);
                page.setPageNumber(n);
                ++n;
            }
        }
        this.setCount(arrayList);
    }

    private void setCount(List list) {
        int n = list.size();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            ((Page)iterator.next()).setPageCount(n);
        }
    }
}

