/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.engine.pl;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.engine.PageListener;
import com.elixirtech.report2.engine.PageSource;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageSequence;

public class PageNumberListener
implements PageListener {
    private PageListener m_Next;
    private int m_PageNo;

    public PageNumberListener(PageListener pageListener) {
        this.m_Next = pageListener;
    }

    @Override
    public void startReport(PageSource pageSource) throws RenderException {
        this.m_PageNo = 1;
        this.m_Next.startReport(pageSource);
    }

    @Override
    public void startPageSequence(PageSequence pageSequence) throws RenderException {
        if (pageSequence.isResetPageCount()) {
            this.m_PageNo = 1;
        }
        this.m_Next.startPageSequence(pageSequence);
    }

    @Override
    public void addPage(Page page) throws RenderException {
        page.setPageNumber(this.m_PageNo++);
        this.m_Next.addPage(page);
    }

    @Override
    public void endPageSequence(PageSequence pageSequence) throws RenderException {
        pageSequence.setCachedPageCount(this.m_PageNo - 1);
        this.m_Next.endPageSequence(pageSequence);
    }

    @Override
    public void endReport(PageSource pageSource) throws RenderException {
        this.m_Next.endReport(pageSource);
        this.m_Next = null;
    }
}

