/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.html;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.graphics.BorderStyle;
import com.elixirtech.graphics.GLine;
import com.elixirtech.graphics.GraphicsLineDrawable;
import com.elixirtech.graphics.WritingMode;
import com.elixirtech.jdom.input.DOMBuilder;
import com.elixirtech.jdom.output.Format;
import com.elixirtech.jdom.output.XMLOutputter;
import com.elixirtech.report2.RenderConstants;
import com.elixirtech.report2.html.HTMLConstants;
import com.elixirtech.report2.html.HTMLElement;
import com.elixirtech.report2.html.HTMLImage;
import com.elixirtech.report2.html.HTMLNavigator;
import com.elixirtech.report2.html.HTMLPage;
import com.elixirtech.report2.html.HTMLRenderContext;
import com.elixirtech.report2.html.IOutputter;
import com.elixirtech.report2.html.ImageUtil;
import com.elixirtech.report2.html.PlainHTMLGenerator;
import com.elixirtech.report2.html.Style;
import com.elixirtech.report2.html.StyleBuilder;
import com.elixirtech.report2.html.TOCBuilder;
import com.elixirtech.report2.html.TreeHTMLNavigator;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.model.Body;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.Column;
import com.elixirtech.report2.logical.model.Columns;
import com.elixirtech.report2.logical.model.Glint;
import com.elixirtech.report2.logical.model.Grid;
import com.elixirtech.report2.logical.model.ITOCElement;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.Line;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.logical.model.Page;
import com.elixirtech.report2.logical.model.PageFooter;
import com.elixirtech.report2.logical.model.PageHeader;
import com.elixirtech.report2.logical.model.PageSequence;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.SVG;
import com.elixirtech.report2.logical.model.SizableElement;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.physical.glint.GGrid;
import com.elixirtech.report2.physical.glint.GridRenderer;
import com.elixirtech.report2.raw.constants.Alignment;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.util.ImageLoader;
import com.elixirtech.report2.util.VariableSubstitution;
import com.elixirtech.tree.CellStructure;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.web.IPageLinker;
import com.elixirtech.web.PageLinker;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.w3c.dom.Document;
import org.w3c.dom.svg.SVGDocument;

public class HTMLGenerator
implements HTMLConstants {
    public static final String PAGE_LINKS_STYLE = "position:absolute; left:0px; top:0px; z-index:1; background:white;";
    public static final String PAGE_LINK_STYLE = "margin:2px;";
    protected StyleBuilder m_StyleBuilder;
    protected boolean m_BackgroundDiv = true;
    private HTMLRenderContext m_RenderContext;
    private LogicalReport m_Report;
    private PageSequence m_CurrentPS;
    private boolean m_SVGPassThrough;
    private boolean m_EmbeddedPageLinks;
    private TOCBuilder m_TOCBuilder;
    private IOutputter m_Outputter;
    private HTMLNavigator m_Navigator;
    private ZipOutputStream m_ZipOutputStream;
    private VariableSubstitution m_VariableSubstitution = new VariableSubstitution();
    private String m_PageNumber;
    private String m_PageCount;
    private int m_TOCId;
    private List<HTMLPage> m_Pages = new ArrayList<HTMLPage>();
    private Map<Object, String> m_ResourceMap = new HashMap<Object, String>();
    private String m_HighlightBackground = "aqua";
    private String m_NormalBackground = "white";
    private boolean m_TreeMode;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(HTMLGenerator.class);

    public HTMLGenerator(LogicalReport logicalReport, IOutputter iOutputter, HTMLNavigator hTMLNavigator) {
        this.m_RenderContext = new HTMLRenderContext();
        this.m_Report = logicalReport;
        this.m_StyleBuilder = new StyleBuilder();
        this.m_TOCBuilder = this.createTOCBuilder();
        this.m_Outputter = iOutputter;
        this.m_Navigator = hTMLNavigator;
        this.m_TreeMode = this.m_Navigator instanceof TreeHTMLNavigator;
    }

    public boolean isTreeMode() {
        return this.m_TreeMode;
    }

    protected TOCBuilder createTOCBuilder() {
        return new TOCBuilder(this.m_Report, this);
    }

    public void setBackground(String string, String string2) {
        this.m_HighlightBackground = string;
        this.m_NormalBackground = string2;
    }

    public IOutputter getOutputter() {
        return this.m_Outputter;
    }

    public void setSVGPassThrough(boolean bl) {
        this.m_SVGPassThrough = bl;
    }

    public void setEmbeddedPageLinks(boolean bl) {
        this.m_EmbeddedPageLinks = bl;
    }

    public String getExtension() {
        return this.m_Navigator.getHTMLExtension();
    }

    public void setBackgroundDiv(boolean bl) {
        this.m_BackgroundDiv = bl;
    }

    public void startPageSequence(PageSequence pageSequence) {
        if (this.m_CurrentPS != null && pageSequence.isResetPageCount()) {
            this.m_Navigator.addPageTotal(this.getPageNumber());
        }
        this.m_CurrentPS = pageSequence;
    }

    public void endReport() throws IOException {
        if (this.m_CurrentPS != null) {
            this.m_Navigator.addPageTotal(this.getPageNumber());
        }
    }

    private int getPageNumber() {
        if (StringUtil.notEmpty(this.m_PageNumber)) {
            try {
                return Integer.parseInt(this.m_PageNumber);
            }
            catch (NumberFormatException numberFormatException) {
                m_Log.warn((Object)("NumberFormatException reading page number: \"" + this.m_PageNumber + "\""));
            }
        }
        return 0;
    }

    public void renderPage(Page page, ZipOutputStream zipOutputStream) throws IOException {
        int n;
        this.m_ZipOutputStream = zipOutputStream;
        Map<String, String> map = this.m_VariableSubstitution.getMap();
        this.m_PageNumber = Integer.toString(page.getPageNumber());
        int n2 = page.getPageCount();
        if (n2 == 0 && this.m_Navigator.supportsPageTotalScripts()) {
            n = this.m_Navigator.getNextPageTotalId();
            this.m_PageCount = "${##" + n + "}";
        } else {
            this.m_PageCount = Integer.toString(n2);
        }
        map.put("#", this.m_PageNumber);
        map.put("##", this.m_PageCount);
        map.put("@", this.m_PageNumber + " of " + this.m_PageCount);
        n = this.getPageNo();
        String string = "Page " + this.getPageNo();
        String string2 = this.m_TreeMode && n == 1 && !this.m_EmbeddedPageLinks ? "index" + this.getExtension() : "page" + this.getPageNo() + this.getExtension();
        HTMLPage hTMLPage = this.newPage(this.getTitle(), string2, string);
        if (this.m_TOCBuilder != null) {
            this.m_TOCBuilder.addPage(hTMLPage);
        }
        if (this.m_EmbeddedPageLinks) {
            this.renderEmbeddedLinks(page, hTMLPage);
        }
        this.startPage(page, hTMLPage);
        this.renderPageContents(page, hTMLPage);
        this.endPage(page, hTMLPage);
        this.m_Pages.add(hTMLPage);
        this.save(hTMLPage);
    }

    protected void startPage(Page page, HTMLPage hTMLPage) throws IOException {
        if (this.m_BackgroundDiv) {
            HTMLElement hTMLElement = hTMLPage.pushBody("div");
            Style style = this.m_StyleBuilder.getStyle(page);
            hTMLElement.addStyle(style);
            hTMLElement.addAttribute("class", "pagesize");
        }
    }

    protected void renderPageContents(Page page, HTMLPage hTMLPage) throws IOException {
        PageSetup pageSetup = page.getPageSetup();
        Page page2 = page.getWatermark();
        if (page2 != null) {
            this.renderPageContents(page2, hTMLPage);
        }
        hTMLPage.offsetX(-hTMLPage.getX());
        hTMLPage.offsetY(-hTMLPage.getY());
        hTMLPage.offsetX(pageSetup.getLeft() / 20);
        hTMLPage.offsetY(pageSetup.getTop() / 20);
        PageHeader pageHeader = page.getPageHeader();
        if (pageHeader != null) {
            this.renderElements(hTMLPage, pageHeader);
        }
        Body body = page.getBody();
        for (BodyPart bodyPart : body.getBodyPartList()) {
            this.renderElements(hTMLPage, bodyPart);
        }
        PageFooter pageFooter = page.getPageFooter();
        if (pageFooter != null) {
            int n = (pageSetup.getHeight() - pageSetup.getBottom() - pageFooter.getHeight()) / 20;
            hTMLPage.offsetY(n - hTMLPage.getY());
            this.renderElements(hTMLPage, pageFooter);
        }
    }

    protected void endPage(Page page, HTMLPage hTMLPage) throws IOException {
        if (this.m_BackgroundDiv) {
            hTMLPage.popBody();
        }
    }

    private void renderEmbeddedLinks(Page page, HTMLPage hTMLPage) throws IOException {
        String string;
        int n;
        PageLinker pageLinker = new PageLinker();
        int n2 = page.getPageNumber();
        IPageLinker.Link[] linkArray = pageLinker.generatePageLinks(n2, n = page.getPageCount(), string = "page{0}" + this.getExtension());
        if (linkArray.length > 0) {
            HTMLElement hTMLElement = hTMLPage.pushBody("div");
            hTMLElement.addAttribute("id", "page-links");
            hTMLElement.addAttribute("style", PAGE_LINKS_STYLE);
            for (IPageLinker.Link link : linkArray) {
                HTMLElement hTMLElement2;
                if (link.link != null) {
                    hTMLElement2 = hTMLElement.addChild("a");
                    hTMLElement2.addAttribute("style", PAGE_LINK_STYLE);
                    hTMLElement2.addAttribute("href", link.link);
                    hTMLElement2.addRawText(link.text);
                    continue;
                }
                hTMLElement2 = hTMLElement.addChild("span");
                if (link.bold) {
                    hTMLElement2 = hTMLElement2.addChild("b");
                }
                hTMLElement2.addRawText(link.text);
            }
            hTMLPage.popBody();
        }
    }

    public void renderExtras(ZipOutputStream zipOutputStream) throws IOException {
        if (!this.m_EmbeddedPageLinks) {
            this.m_Navigator.render(zipOutputStream, this.m_Pages.size(), this.m_TOCBuilder);
        }
    }

    public String getImageId(BufferedImage bufferedImage) throws IOException {
        Object object = this.m_ResourceMap.get(bufferedImage);
        if (object == null) {
            int n = this.m_ResourceMap.size() + 1;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("images/image").append(this.pad(n, 4)).append(".png");
            String string = stringBuilder.toString();
            String string2 = this.m_Outputter.getBaseURL();
            object = StringUtil.notEmpty(string2) ? string2 + string : string;
            this.m_ResourceMap.put(bufferedImage, (String)object);
            this.save14(bufferedImage, string);
        }
        return (String)object + "?rnd=" + System.currentTimeMillis();
    }

    public String getSVGId(SVGDocument sVGDocument) throws IOException {
        String string = this.m_ResourceMap.get(sVGDocument);
        if (string == null) {
            int n = this.m_ResourceMap.size() + 1;
            String string2 = this.m_Outputter.getBaseURL();
            StringBuilder stringBuilder = new StringBuilder();
            if (StringUtil.notEmpty(string2)) {
                stringBuilder.append(string2);
            }
            stringBuilder.append("images/svg");
            stringBuilder.append(this.pad(n, 4));
            stringBuilder.append(".svg");
            string = stringBuilder.toString();
            this.m_ResourceMap.put(sVGDocument, string);
            this.save(sVGDocument, string);
        }
        return string;
    }

    private String pad(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer(Integer.toString(n));
        while (stringBuffer.length() < n2) {
            stringBuffer.insert(0, "0");
        }
        return stringBuffer.toString();
    }

    public HTMLPage newPage(String string, String string2, String string3) {
        HTMLPage hTMLPage = new HTMLPage(string, string2, string3);
        if (!this.m_EmbeddedPageLinks && !this.m_TreeMode) {
            hTMLPage.addJavaScript("pageList.js");
        }
        return hTMLPage;
    }

    protected void renderElements(HTMLPage hTMLPage, LogicalElementHolder logicalElementHolder) throws IOException {
        if (logicalElementHolder != null) {
            Object object;
            Object object2;
            int n;
            int n2 = hTMLPage.getX();
            int n3 = hTMLPage.getY();
            HTMLElement hTMLElement = hTMLPage.pushBody("div");
            Object object3 = this.m_StyleBuilder.getStyle(logicalElementHolder);
            this.m_StyleBuilder.addPositionInfo(logicalElementHolder, (Style)object3, n2, n3);
            hTMLElement.addStyle((Style)object3);
            hTMLPage.offsetX(-n2);
            hTMLPage.offsetY(-n3);
            if (logicalElementHolder instanceof ITOCElement) {
                object3 = (ITOCElement)((Object)logicalElementHolder);
                String object4 = object3.getId();
                if (object4 != null && object4.startsWith("tree:page:")) {
                    n = Integer.parseInt(object3.getId().substring(10)) + 1;
                    hTMLElement.addAttribute("onclick", "self.location='page" + n + ".html'");
                    hTMLElement.addAttribute("onmouseover", "this.style.background='" + this.m_HighlightBackground + "'");
                    hTMLElement.addAttribute("onmouseout", "this.style.background='" + this.m_NormalBackground + "'");
                    object2 = hTMLElement.getAttribute("style");
                    hTMLElement.addAttribute("style", (String)object2 + " cursor:hand;");
                }
                if (object3.isTableOfContents() && RenderUtil.isValidTOC((SizableElement)object3)) {
                    HTMLElement hTMLElement2 = hTMLPage.getBody().addChild("div");
                    object2 = new Style();
                    ((Style)object2).add("position", "absolute");
                    ((Style)object2).add("left", Integer.toString(hTMLPage.getX()) + "px");
                    ((Style)object2).add("top", Integer.toString(hTMLPage.getY()) + "px");
                    ((Style)object2).add("width", "0px");
                    ((Style)object2).add("height", "0px");
                    hTMLElement2.addStyle((Style)object2);
                    object = object3.getTOCTitle();
                    String string = this.getTOCId();
                    HTMLElement hTMLElement3 = hTMLElement2.addChild("a");
                    hTMLElement3.addAttribute("name", string);
                    if (this.m_TOCBuilder != null) {
                        int n4 = object3.getTOCLevel();
                        this.m_TOCBuilder.pushTOC(string, n4, (String)object);
                    }
                }
            }
            if (logicalElementHolder instanceof Columns) {
                int n5;
                object3 = (Columns)logicalElementHolder;
                boolean n52 = false;
                n = hTMLPage.getX();
                object2 = ((Columns)object3).getColumnIterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    int n6 = this.renderColumn(hTMLPage, (Column)object);
                    n5 = Math.max(n5, n6);
                    if (object2.hasNext()) {
                        int n7 = (((Column)object).getWidth() + ((Column)object).getSpaceAfter()) / 20;
                        hTMLPage.offsetX(n7);
                    }
                    hTMLPage.offsetY(-n6);
                }
                hTMLPage.offsetX(n - hTMLPage.getX());
                hTMLPage.offsetY(n5);
            } else {
                for (LogicalElement logicalElement : logicalElementHolder.getLogicalElementList()) {
                    this.renderElement(hTMLPage, logicalElement);
                }
                hTMLPage.offsetY(logicalElementHolder.getHeight() / 20);
            }
            hTMLPage.popBody();
            hTMLPage.offsetX(n2);
            hTMLPage.offsetY(n3);
        }
    }

    protected int renderColumn(HTMLPage hTMLPage, Column column) throws IOException {
        int n = 0;
        for (BodyPart bodyPart : column.getBodyPartList()) {
            this.renderElements(hTMLPage, bodyPart);
            int n2 = (bodyPart.getHeight() + bodyPart.getSpaceAfter()) / 20;
            n += n2;
        }
        return n;
    }

    protected void renderElement(HTMLPage hTMLPage, LogicalElement logicalElement) throws IOException {
        if (logicalElement == null) {
            return;
        }
        if (logicalElement instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)logicalElement;
            Color color = StandardColor.lookup(rectangle.getBackgroundColor());
            if (color.getAlpha() > 0 || rectangle.getBorderStyle() != null) {
                HTMLElement hTMLElement = hTMLPage.getBody().addChild("div");
                Style object = this.m_StyleBuilder.getStyle(rectangle);
                this.m_StyleBuilder.addRectPositionInfo(rectangle, object, hTMLPage.getX(), hTMLPage.getY());
                hTMLElement.addStyle(object);
            }
            for (LogicalElement string : rectangle.getLogicalElementList()) {
                this.renderElement(hTMLPage, string);
            }
        } else if (logicalElement instanceof Grid) {
            Grid grid = (Grid)logicalElement;
            GGrid gGrid = GridRenderer.buildGrid(grid);
            gGrid.calculate();
            HTMLElement hTMLElement = hTMLPage.getBody().addChild("div");
            String hTMLImage = grid.getURL();
            String image2 = grid.getURLTarget();
            String bufferedImage = grid.getURLDescription();
            boolean object2 = StringUtil.notEmpty(hTMLImage);
            Style object = new Style();
            this.m_StyleBuilder.addPositionInfo(grid, object, hTMLPage.getX(), hTMLPage.getY());
            hTMLElement.addStyle(object);
            Dimension string = gGrid.getBoxSize();
            int n11 = gGrid.getBoxRows();
            int n = gGrid.getBoxColumns();
            int n2 = grid.getLeft() + gGrid.getXOffset() / 2;
            int n3 = grid.getTop() + gGrid.getYOffset() / 2;
            CellStructure cellStructure = new CellStructure(null, n, n11);
            WritingMode writingMode = WritingMode.get(grid.getWritingMode());
            if (writingMode == WritingMode.LR_TB) {
                PlainHTMLGenerator.renderBoxesLRTB(gGrid, cellStructure);
            } else if (writingMode == WritingMode.RL_TB) {
                PlainHTMLGenerator.renderBoxesRLTB(gGrid, cellStructure);
            } else if (writingMode == WritingMode.TB_RL) {
                PlainHTMLGenerator.renderBoxesTBRL(gGrid, cellStructure);
            } else if (writingMode == WritingMode.TB_LR) {
                PlainHTMLGenerator.renderBoxesTBLR(gGrid, cellStructure);
            }
            CellStructure.Cell cell = new CellStructure.Cell("");
            for (int i = 0; i < n11; ++i) {
                int n4 = n3 + i * string.height;
                for (int j = 0; j < n; ++j) {
                    CellStructure.Cell cell2 = cellStructure.getCell(i, j);
                    if (cell2 == null) {
                        cell2 = cell;
                    }
                    int n5 = cell2.colSpan * string.width;
                    int n6 = n2 + j * string.width;
                    Style style = this.m_StyleBuilder.getCellStyle(grid);
                    this.m_StyleBuilder.addPositionInfo(style, n6, n4, n5, string.height);
                    HTMLElement hTMLElement2 = hTMLPage.getBody().addChild("div");
                    hTMLElement2.addStyle(style);
                    if (object2) {
                        HTMLElement hTMLElement3 = new HTMLElement("a");
                        hTMLElement3.addAttribute("href", hTMLImage);
                        if (StringUtil.notEmpty(image2)) {
                            hTMLElement3.addAttribute("target", image2);
                        }
                        if (StringUtil.notEmpty(bufferedImage)) {
                            hTMLElement3.addAttribute("title", bufferedImage);
                        }
                        hTMLElement3.addRawText((String)cell2.data);
                        hTMLElement2.addChild(hTMLElement3);
                        continue;
                    }
                    hTMLElement2.addRawText((String)cell2.data);
                }
            }
        } else if (logicalElement instanceof Text) {
            Text text = (Text)logicalElement;
            HTMLElement hTMLElement = hTMLPage.getBody().addChild("div");
            Style style = this.m_StyleBuilder.getStyle(text);
            this.m_StyleBuilder.addPositionInfo(text, style, hTMLPage.getX(), hTMLPage.getY());
            hTMLElement.addStyle(style);
            String hTMLImage = text.getText();
            if (StringUtil.notEmpty(hTMLImage)) {
                String rectangle = this.substituteVariables(hTMLImage);
                String n = text.getURL();
                if (StringUtil.notEmpty(n)) {
                    HTMLElement n8 = new HTMLElement("a");
                    n8.addAttribute("href", n);
                    String n9 = text.getURLTarget();
                    String n10 = text.getURLDescription();
                    if (StringUtil.notEmpty(n9)) {
                        n8.addAttribute("target", n9);
                    }
                    if (StringUtil.notEmpty(n10)) {
                        n8.addAttribute("title", n10);
                    }
                    n8.addRawText(rectangle);
                    hTMLElement.addChild(n8);
                } else {
                    hTMLElement.addRawText(rectangle);
                }
            }
        } else if (logicalElement instanceof Image) {
            Object object;
            Object object2;
            Image image = (Image)logicalElement;
            HTMLElement hTMLElement = hTMLPage.getBody().addChild("div");
            Style style = this.m_StyleBuilder.getStyle(image);
            this.m_StyleBuilder.addPositionInfo(image, style, hTMLPage.getX(), hTMLPage.getY());
            hTMLElement.addStyle(style);
            HTMLImage hTMLImage = new HTMLImage(this);
            hTMLImage.setBounds(image.getLeft() / 20, image.getTop() / 20, image.getWidth() / 20, image.getHeight() / 20);
            java.awt.Image hTMLElement5 = image.getImage();
            BufferedImage bufferedImage = null;
            if (hTMLElement5 != null) {
                bufferedImage = (BufferedImage)hTMLElement5;
            }
            if (bufferedImage == null) {
                object2 = ImageLoader.loadFromPath(this.m_RenderContext, image.getPicture());
                if (object2 == null) {
                    m_Log.warn((Object)("Actual image may not be available, check url of the image: " + image.getPicture()));
                    return;
                }
                if (!(object2 instanceof BufferedImage)) {
                    bufferedImage = new BufferedImage(((java.awt.Image)object2).getWidth(null), ((java.awt.Image)object2).getHeight(null), 2);
                    object = bufferedImage.getGraphics();
                    ((Graphics)object).drawImage((java.awt.Image)object2, 0, 0, null);
                    ((Graphics)object).dispose();
                } else {
                    bufferedImage = (BufferedImage)object2;
                }
            }
            hTMLImage.setImage(bufferedImage);
            hTMLImage.setSizeMode(image.getSizeMode());
            hTMLImage.setAlignment(Alignment.getAlignmentId(image.getHorizontalAlign(), image.getVerticalAlign()));
            object2 = image.getURL();
            if (StringUtil.notEmpty((String)object2)) {
                object = new HTMLElement("a");
                ((HTMLElement)object).addAttribute("href", (String)object2);
                String string = image.getURLTarget();
                String string2 = image.getURLDescription();
                if (StringUtil.notEmpty(string)) {
                    ((HTMLElement)object).addAttribute("target", string);
                }
                if (StringUtil.notEmpty(string2)) {
                    ((HTMLElement)object).addAttribute("title", string2);
                    hTMLImage.addAttribute("alt", string2);
                }
                ((HTMLElement)object).addChild(hTMLImage);
                hTMLElement.addChild((HTMLElement)object);
            } else {
                hTMLElement.addChild(hTMLImage);
            }
        } else if (logicalElement instanceof Line) {
            Line line = (Line)logicalElement;
            HTMLElement hTMLElement = hTMLPage.getBody().addChild("div");
            Style style = new Style();
            this.m_StyleBuilder.addPositionInfo(line, style, hTMLPage.getX(), hTMLPage.getY());
            hTMLElement.addStyle(style);
            HTMLImage string = new HTMLImage(this);
            java.awt.Rectangle rectangle = new java.awt.Rectangle(line.getLeft(), line.getTop(), line.getWidth(), line.getHeight());
            string.setBounds(rectangle.x / 20, rectangle.y / 20, rectangle.width / 20, rectangle.height / 20);
            int n = line.getDivisor();
            int n7 = rectangle.x + line.getX1() * rectangle.width / n;
            int n8 = rectangle.y + line.getY1() * rectangle.height / n;
            int n9 = rectangle.x + line.getX2() * rectangle.width / n;
            int n10 = rectangle.y + line.getY2() * rectangle.height / n;
            GLine gLine = new GLine();
            gLine.setLine(n7, n8, n9, n10);
            gLine.setLineColor(StandardColor.lookup(line.getLineColor(), Color.BLACK));
            gLine.setLineWidth(line.getLineWidth());
            gLine.setLineStyle(BorderStyle.get(line.getLineStyle()));
            gLine.setArrowStyle1(line.getArrowStyle1());
            gLine.setArrowStyle2(line.getArrowStyle2());
            gLine.setArrowWidth1(line.getArrowWidth1());
            gLine.setArrowWidth2(line.getArrowWidth2());
            gLine.setArrowColor1(StandardColor.lookup(line.getArrowColor1(), Color.BLACK));
            gLine.setArrowColor2(StandardColor.lookup(line.getArrowColor2(), Color.BLACK));
            BufferedImage bufferedImage = new BufferedImage(rectangle.width / 20, rectangle.height / 20, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.scale(0.05, 0.05);
            graphics2D.translate(-rectangle.x, -rectangle.y);
            gLine.draw(new GraphicsLineDrawable(graphics2D));
            graphics2D.dispose();
            string.setImage(bufferedImage);
            string.setSizeMode("Clip");
            string.setAlignment(9);
            hTMLElement.addChild(string);
        } else if (logicalElement instanceof Glint) {
            Glint glint = (Glint)logicalElement;
            if (glint.getByteArray() != null) {
                HTMLElement hTMLElement = hTMLPage.getBody().addChild("div");
                Style style = this.m_StyleBuilder.getStyle(glint);
                this.m_StyleBuilder.addPositionInfo(glint, style, hTMLPage.getX(), hTMLPage.getY());
                hTMLElement.addStyle(style);
                HTMLImage hTMLImage = new HTMLImage(this);
                hTMLImage.setBounds(glint.getLeft() / 20, glint.getTop() / 20, glint.getWidth() / 20, glint.getHeight() / 20);
                hTMLImage.setImage(ImageUtil.getImage(glint));
                hTMLImage.setSizeMode("Clip");
                hTMLImage.setAlignment(9);
                hTMLElement.addChild(hTMLImage);
            }
        } else if (logicalElement instanceof SVG) {
            SVG sVG = (SVG)logicalElement;
            HTMLElement hTMLElement = hTMLPage.getBody().addChild("div");
            Style style = this.m_StyleBuilder.getStyle(sVG);
            this.m_StyleBuilder.addPositionInfo(sVG, style, hTMLPage.getX(), hTMLPage.getY());
            hTMLElement.addStyle(style);
            if (this.m_SVGPassThrough) {
                String string = this.getSVGId(sVG.getDocument());
                HTMLElement hTMLElement4 = hTMLElement.addChild("embed");
                hTMLElement4.addAttribute("src", string);
                hTMLElement4.addAttribute("width", "100%");
                hTMLElement4.addAttribute("height", "100%");
                hTMLElement4.addAttribute("pluginspage", "http://www.adobe.com/svg/viewer/install/");
            } else {
                HTMLImage hTMLImage = new HTMLImage(this);
                hTMLImage.setBounds(sVG.getLeft() / 20, sVG.getTop() / 20, sVG.getWidth() / 20, sVG.getHeight() / 20);
                hTMLImage.setImage(ImageUtil.getImage(sVG));
                hTMLImage.setSizeMode("Clip");
                hTMLImage.setAlignment(9);
                hTMLElement.addChild(hTMLImage);
            }
        }
    }

    private String getTitle() {
        return this.m_Report.getCaption() + " : Page " + this.getPageNo();
    }

    private int getPageNo() {
        return this.m_Pages.size() + 1;
    }

    private String getTOCId() {
        return "TOC_" + ++this.m_TOCId;
    }

    private String substituteVariables(String string) {
        string = StringUtil.findAndReplace(string, RenderConstants.PAGE_NUMBER_STRING, this.m_PageNumber);
        string = StringUtil.findAndReplace(string, RenderConstants.PAGE_COUNT_STRING, this.m_PageCount);
        return this.m_VariableSubstitution.substitute(string);
    }

    protected void save(HTMLPage hTMLPage) throws IOException {
        assert (hTMLPage != null);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.m_Outputter.output(hTMLPage, (OutputStream)byteArrayOutputStream);
        ZipEntry zipEntry = new ZipEntry(hTMLPage.getFilename());
        this.m_ZipOutputStream.putNextEntry(zipEntry);
        this.m_ZipOutputStream.write(byteArrayOutputStream.toByteArray());
        this.m_ZipOutputStream.closeEntry();
    }

    private void save14(BufferedImage bufferedImage, String string) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        this.m_ZipOutputStream.putNextEntry(zipEntry);
        ImageIO.write((RenderedImage)bufferedImage, "PNG", this.m_ZipOutputStream);
        this.m_ZipOutputStream.closeEntry();
    }

    private void save(SVGDocument sVGDocument, String string) throws IOException {
        XMLOutputter xMLOutputter = new XMLOutputter(Format.getCompactFormat());
        DOMBuilder dOMBuilder = new DOMBuilder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        xMLOutputter.output(dOMBuilder.build((Document)sVGDocument), (OutputStream)byteArrayOutputStream);
        ZipEntry zipEntry = new ZipEntry(string);
        this.m_ZipOutputStream.putNextEntry(zipEntry);
        this.m_ZipOutputStream.write(byteArrayOutputStream.toByteArray());
        this.m_ZipOutputStream.closeEntry();
    }
}

