/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataSourceManager;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.data2.datasource.NullDataSource;
import com.elixirtech.data2.datasource.filter.FilteredDataSource;
import com.elixirtech.data2.datasource.filter.FilteredDefinition;
import com.elixirtech.report2.logical.RenderStack;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.Filter;
import java.util.HashMap;
import java.util.Map;

public class DataHolder {
    private String m_DataSourceName;
    private DataSource m_DataSource;
    private Map<String, String> m_Properties = new HashMap<String, String>();
    private IDataSource m_IDataSource;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(DataHolder.class);

    public DataHolder() {
    }

    public DataHolder(String string) {
        this.m_DataSourceName = string;
    }

    public void resolve() {
        if (StringUtil.notEmpty(this.m_DataSourceName)) {
            RenderStack renderStack = RenderStack.current();
            this.m_DataSource = renderStack.getDataSource(this.m_DataSourceName);
            if (this.m_DataSource == null) {
                m_Log.warn((Object)("DataSource \"" + this.m_DataSourceName + "\" not found"));
            }
            BasicLogicalRenderer.buildProperties(this);
        }
    }

    public DataHolder(DataSource dataSource) {
        this.m_DataSource = dataSource;
        if (this.m_DataSource != null) {
            BasicLogicalRenderer.buildProperties(this);
        }
    }

    public DataHolder(IDataSource iDataSource) {
        this.m_IDataSource = iDataSource;
    }

    public DataSource getDataSource() {
        return this.m_DataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_DataSource = dataSource;
        this.m_IDataSource = null;
        this.m_Properties.clear();
        if (this.m_DataSource != null) {
            BasicLogicalRenderer.buildProperties(this);
        }
    }

    public void setDataSource(String string) {
        if (StringUtil.notEmpty(string)) {
            RenderStack renderStack = RenderStack.current();
            this.m_DataSource = renderStack.getDataSource(string);
            if (this.m_DataSource == null) {
                m_Log.warn((Object)("DataSource \"" + string + "\" not found"));
            }
            BasicLogicalRenderer.buildProperties(this);
        } else {
            this.m_DataSource = null;
        }
    }

    private IDataSource getFilterDataSource(IDataSource iDataSource) {
        int n = this.m_DataSource.getFilterCount();
        if (n > 0) {
            String string = this.m_DataSource.getDataSourceName() + ".filtered";
            FilteredDataSource filteredDataSource = new FilteredDataSource(string, this.m_IDataSource);
            for (int i = 0; i < n; ++i) {
                Filter filter = this.m_DataSource.getFilter(i);
                if (!filter.isEnabled().booleanValue()) continue;
                filteredDataSource.addFilter(FilteredDefinition.getFilter(filter.getField(), filter.getWhen(), filter.getValue()));
            }
            return filteredDataSource;
        }
        return this.m_IDataSource;
    }

    public IDataSource getIDataSource() throws DataException {
        if (this.m_IDataSource == null) {
            if (this.m_DataSource == null) {
                return new NullDataSource();
            }
            String string = this.m_DataSource.getDataSourceName();
            if (StringUtil.notEmpty(string)) {
                DataSourceManager dataSourceManager = (DataSourceManager)Elixir.get(DataSourceManager.class);
                this.m_IDataSource = dataSourceManager.getDataSource(dataSourceManager, string);
                this.m_IDataSource = this.getFilterDataSource(this.m_IDataSource);
            } else {
                return new NullDataSource();
            }
        }
        return this.m_IDataSource;
    }

    public void setIDataSource(IDataSource iDataSource) {
        this.m_IDataSource = iDataSource;
    }

    public void addProperties(Map<String, String> map) {
        this.m_Properties.putAll(map);
    }

    public boolean containsKey(String string) {
        return this.m_Properties.containsKey(string);
    }

    public void put(String string, String string2) {
        this.m_Properties.put(string, string2);
    }

    public Map<String, String> getProperties() {
        return this.m_Properties;
    }

    public String getDataSourceName() {
        if (this.m_DataSource != null) {
            return this.m_DataSource.getName();
        }
        return "";
    }

    public boolean isTabulate() {
        if (this.m_DataSource != null) {
            return this.m_DataSource.isTabulate();
        }
        return false;
    }
}

