/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.logical.Paginator;
import com.elixirtech.report2.raw.model.Section;

public class MultiColumnPaginator
extends Paginator {
    protected int m_Column = 0;
    protected int m_MaxColY;
    protected int m_TopY;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(MultiColumnPaginator.class);

    public MultiColumnPaginator(Section section, boolean bl) throws RenderException {
        super(section, bl);
    }

    @Override
    public void logState() {
        m_Log.debug((Object)("m_Y=" + this.m_Y + " m_Page=" + this.m_Page + " m_Column=" + this.m_Column + " atTop=" + this.isAtTop() + " m_DeadHeight=" + this.m_DeadHeight));
    }

    @Override
    public boolean hasColumns() {
        return this.m_PageSetup.getColumnCount() > 1;
    }

    @Override
    public boolean hasMoreColumns() {
        return this.m_Column + 1 < this.m_PageSetup.getColumnCount();
    }

    public boolean isAcrossThenDown() {
        return this.hasColumns() && this.m_Layout == 11;
    }

    public void startOfColumns() {
        this.m_Column = 0;
        this.m_TopY = this.m_Y;
        this.m_MaxColY = this.m_Y;
    }

    @Override
    public void newColumn() {
        ++this.m_Column;
        this.m_MaxColY = Math.max(this.m_MaxColY, this.m_Y);
        this.m_Y = this.m_TopY;
        this.setAtTop(true);
    }

    public void endOfColumns() {
        this.m_Y = Math.max(this.m_MaxColY, this.m_Y);
    }

    @Override
    public void newPage(boolean bl) {
        super.newPage(bl);
        this.m_TopY = 0;
        this.m_Column = 0;
    }

    public int getHorizontalPageCount() {
        return this.m_PageSetup.getHorizontalPageCount();
    }

    @Override
    public int getColumnNumber() {
        return this.m_Column + 1;
    }
}

