/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical;

import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.repository.RMLFileObject;

public class RenderStackFrame
implements IResourceProvider {
    private IResourceProvider m_Provider;
    private LogicalRenderContext m_Context;
    private RenderStackFrame m_Next;

    public RenderStackFrame(IResourceProvider iResourceProvider, LogicalRenderContext logicalRenderContext, RenderStackFrame renderStackFrame) {
        this.m_Provider = iResourceProvider;
        this.m_Context = logicalRenderContext;
        this.m_Next = renderStackFrame;
    }

    public void setNext(RenderStackFrame renderStackFrame) {
        this.m_Next = renderStackFrame;
    }

    public RenderStackFrame getNext() {
        return this.m_Next;
    }

    public LogicalRenderContext getContext() {
        return this.m_Context;
    }

    @Override
    public DataSource getDataSource(String string) {
        DataSource dataSource = this.m_Provider.getDataSource(string);
        if (dataSource == null && this.m_Next != null) {
            dataSource = this.m_Next.getDataSource(string);
        }
        return dataSource;
    }

    @Override
    public Style getStyle(String string) {
        Style style = this.m_Provider.getStyle(string);
        if (style == null && this.m_Next != null) {
            style = this.m_Next.getStyle(string);
        }
        return style;
    }

    @Override
    public PageSetup getPageSetup(String string) {
        PageSetup pageSetup = this.m_Provider.getPageSetup(string);
        if (pageSetup == null && this.m_Next != null) {
            pageSetup = this.m_Next.getPageSetup(string);
        }
        return pageSetup;
    }

    @Override
    public RMLFileObject getFile(String string) {
        RMLFileObject rMLFileObject = this.m_Provider.getFile(string);
        if (rMLFileObject == null && this.m_Next != null) {
            rMLFileObject = this.m_Next.getFile(string);
        }
        return rMLFileObject;
    }

    @Override
    public Section getSection(String string) {
        Section section = null;
        if (this.m_Provider instanceof RawReport) {
            section = ((RawReport)this.m_Provider).getSection(string);
        }
        if (section == null && this.m_Next != null) {
            section = this.m_Next.getSection(string);
        }
        return section;
    }

    @Override
    public String getProperty(String string) {
        String string2 = this.m_Provider.getProperty(string);
        if (string2 == null && this.m_Next != null) {
            string2 = this.m_Next.getProperty(string);
        }
        return string2;
    }

    @Override
    public String resolveRepositoryURL(String string) {
        String string2 = this.m_Provider.resolveRepositoryURL(string);
        if (this.m_Provider.getFile(string2) != null || this.m_Next == null) {
            return string2;
        }
        return this.m_Next.resolveRepositoryURL(string);
    }

    @Override
    public String getRelativeRepositoryURL(String string) {
        return this.m_Provider.getRelativeRepositoryURL(string);
    }
}

