/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.layout;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.RenderConstants;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.logical.layout.LayoutElement;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalModelElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class LayoutSequencer
implements RenderConstants {
    public static boolean DEBUG = false;
    private List<LayoutElement> m_LayoutElements;
    private Map<RawModelElement, LayoutElement> m_LayoutMap;
    private List<LayoutElement> m_Sequence;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(LayoutSequencer.class);

    public static void layout(LogicalElementHolder logicalElementHolder, Map<RawModelElement, LogicalModelElement> map) {
        new LayoutSequencer(logicalElementHolder, map);
    }

    private LayoutSequencer(LogicalElementHolder logicalElementHolder, Map<RawModelElement, LogicalModelElement> map) {
        List<LogicalElement> list = logicalElementHolder.getLogicalElementList();
        this.m_LayoutElements = new ArrayList<LayoutElement>();
        this.m_LayoutMap = new HashMap<RawModelElement, LayoutElement>();
        for (LogicalElement logicalElement : list) {
            RawModelElement rawModelElement = logicalElement.getRaw();
            LayoutElement layoutElement = new LayoutElement(rawModelElement);
            this.m_LayoutMap.put(rawModelElement, layoutElement);
            this.m_LayoutElements.add(layoutElement);
        }
        this.processLayoutElements();
        this.buildSequence();
        this.adjustLayout(map);
    }

    private void adjustLayout(Map<RawModelElement, LogicalModelElement> map) {
        for (LayoutElement layoutElement : this.m_Sequence) {
            RawModelElement rawModelElement = layoutElement.getElement();
            LogicalElement logicalElement = (LogicalElement)map.get(rawModelElement);
            if (logicalElement == null) {
                m_Log.warn((Object)("raw element " + rawModelElement + " has no logical"));
            } else {
                layoutElement.setOutput(logicalElement);
            }
            this.fixupRectangle2(layoutElement);
        }
    }

    private void fixupRectangle2(LayoutElement layoutElement) {
        List<LayoutElement.Link> list = layoutElement.aboveLinks();
        Iterator<LayoutElement.Link> iterator = list.iterator();
        if (iterator.hasNext()) {
            LayoutElement.Link link = this.getLowestLink(list);
            int n = this.getTopFrom(link);
            if (DEBUG) {
                int n2 = link.element.getOutputTop();
                int n3 = link.element.getOutputHeight();
                m_Log.debug((Object)("from " + layoutElement.getId() + " up to " + link.element.getId() + " nextTop=" + n));
                m_Log.debug((Object)("calculated from top=" + n2 + " height=" + n3 + " gap=" + link.gap));
            }
            layoutElement.setOutputTop(n);
        }
    }

    private LayoutElement.Link getLowestLink(List<LayoutElement.Link> list) {
        Iterator<LayoutElement.Link> iterator = list.iterator();
        LayoutElement.Link link = iterator.next();
        int n = link.element.getOutputTop() + link.element.getOutputHeight();
        while (iterator.hasNext()) {
            LayoutElement.Link link2 = iterator.next();
            int n2 = link2.element.getOutputTop() + link2.element.getOutputHeight();
            if (n2 <= n) continue;
            link = link2;
            n = n2;
        }
        return link;
    }

    private int getTopFrom(LayoutElement.Link link) {
        int n = link.element.getOutputTop();
        int n2 = link.element.getOutputHeight();
        return n + n2 + link.gap;
    }

    private void processLayoutElements() {
        ArrayList<LayoutElement> arrayList = new ArrayList<LayoutElement>();
        arrayList.addAll(this.m_LayoutElements);
        Collections.sort(arrayList, new LayoutElement.ReverseYOrderComparator());
        for (LayoutElement layoutElement : arrayList) {
            layoutElement.determineThoseAbove(arrayList);
        }
    }

    private void buildSequence() {
        this.m_Sequence = new LinkedList<LayoutElement>();
        HashSet<LayoutElement> hashSet = new HashSet<LayoutElement>();
        LinkedList<LayoutElement> linkedList = new LinkedList<LayoutElement>();
        linkedList.addAll(this.m_LayoutElements);
        try {
            while (linkedList.size() > 0) {
                this.sequenceAvailableElements(hashSet, linkedList);
            }
            if (DEBUG) {
                this.verifySequence();
            }
            this.normalizeDependencies();
        }
        catch (RenderException renderException) {
            m_Log.error((Object)"Output will be compromised by cyclic dependency");
        }
    }

    private void sequenceAvailableElements(Set<LayoutElement> set, List<LayoutElement> list) throws RenderException {
        ArrayList<LayoutElement> arrayList = new ArrayList<LayoutElement>();
        for (LayoutElement layoutElement : list) {
            if (!LayoutSequencer.canRender(layoutElement, set)) continue;
            this.m_Sequence.add(layoutElement);
            set.add(layoutElement);
            arrayList.add(layoutElement);
        }
        if (arrayList.size() == 0) {
            m_Log.error((Object)"Non-terminating loop while sequencingAvailableElements");
            m_Log.debug((Object)("included: " + this.getDebugString(set)));
            m_Log.debug((Object)("outstanding: " + this.getDebugString(list)));
            throw new RenderException("Non-terminating loop while sequencingAvailableElements");
        }
        list.removeAll(arrayList);
    }

    private void normalizeDependencies() {
        ArrayList<LayoutElement> arrayList = new ArrayList<LayoutElement>();
        arrayList.addAll(this.m_Sequence);
        Collections.reverse(arrayList);
        for (LayoutElement layoutElement : arrayList) {
            layoutElement.normalizeDependencies();
        }
    }

    private String getDebugString(Collection<LayoutElement> collection) {
        StringBuffer stringBuffer = new StringBuffer();
        for (LayoutElement layoutElement : collection) {
            stringBuffer.append(layoutElement.debugString());
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    private static boolean canRender(LayoutElement layoutElement, Set<LayoutElement> set) {
        List<LayoutElement> list = LayoutSequencer.getLinkElements(layoutElement.aboveLinks());
        return set.containsAll(list);
    }

    private boolean verifySequence() {
        HashSet<LayoutElement> hashSet = new HashSet<LayoutElement>();
        for (LayoutElement layoutElement : this.m_Sequence) {
            List<LayoutElement> list = LayoutSequencer.getLinkElements(layoutElement.aboveLinks());
            if (!hashSet.containsAll(list)) {
                m_Log.debug((Object)("badSequence: " + layoutElement.debugString()));
                return false;
            }
            hashSet.add(layoutElement);
        }
        return true;
    }

    private static List<LayoutElement> getLinkElements(List<LayoutElement.Link> list) {
        ArrayList<LayoutElement> arrayList = new ArrayList<LayoutElement>();
        Iterator<LayoutElement.Link> iterator = list.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().element);
        }
        return arrayList;
    }
}

