/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.layout;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.raw.model.CallbackElement;
import com.elixirtech.report2.raw.model.CubeHeader;
import com.elixirtech.report2.raw.model.CubeMeasure;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.model.HBox;
import com.elixirtech.report2.raw.model.ISplittableElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Table;
import com.elixirtech.report2.raw.model.TableBody;
import com.elixirtech.report2.raw.model.TableFooter;
import com.elixirtech.report2.raw.model.TableHeader;
import com.elixirtech.report2.raw.model.TableSection;
import com.elixirtech.report2.raw.model.VBox;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SectionSplitter {
    public static boolean DEBUG = false;
    public static int COUNT = 0;
    private BodyPart m_Section;
    private int m_AboveSplit;
    private int m_BelowSplit;
    private boolean m_ForceSplit;
    private BodyPart m_AbovePart;
    private List<LogicalElement> m_AboveList = new ArrayList<LogicalElement>();
    private BodyPart m_BelowPart;
    private List<LogicalElement> m_BelowList = new ArrayList<LogicalElement>();
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SectionSplitter.class);

    public SectionSplitter(BodyPart bodyPart, int n, boolean bl) throws RenderException {
        try {
            this.m_Section = bodyPart;
            this.m_AboveSplit = this.m_BelowSplit = n;
            this.m_ForceSplit = bl;
            int n2 = this.m_Section.getHeight();
            this.m_AbovePart = (BodyPart)this.m_Section.shallowCopy();
            this.m_AbovePart.setSpaceAfter(0);
            this.m_AbovePart.setSplit("Above");
            this.m_BelowPart = (BodyPart)this.m_Section.shallowCopy();
            this.m_BelowPart.setHeight(n2 - this.m_BelowSplit);
            this.m_BelowPart.setSplit("Below");
            this.partition(this.m_Section, this.m_AbovePart, this.m_BelowPart);
            this.m_AbovePart.setHeight(this.m_AboveSplit);
            this.m_BelowPart.setHeight(n2 - this.m_BelowSplit);
            this.adjustAbove();
            this.adjustBelow2();
        }
        catch (Exception exception) {
            throw new RenderException("Split error", exception);
        }
    }

    public BodyPart getAbove() {
        return this.m_AbovePart;
    }

    public BodyPart getBelow() {
        return this.m_BelowPart;
    }

    public static boolean canSplit(LogicalElement logicalElement) {
        if (logicalElement instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)logicalElement;
            if (rectangle.isKeepTogether()) {
                return false;
            }
            RawModelElement rawModelElement = rectangle.getRaw();
            if (rawModelElement instanceof ISplittableElement || rawModelElement instanceof Field || rawModelElement instanceof TableSection || rawModelElement instanceof CubeHeader || rawModelElement instanceof CubeMeasure) {
                return true;
            }
            if (rawModelElement instanceof CallbackElement) {
                return ((CallbackElement)rawModelElement).getType().equals("HTML");
            }
            return false;
        }
        if (logicalElement instanceof ILogicalElementHolder) {
            return !logicalElement.isKeepTogether();
        }
        return false;
    }

    protected static boolean unsplittable(LogicalElement logicalElement) {
        Rectangle rectangle;
        if (logicalElement instanceof Image) {
            return true;
        }
        if (logicalElement instanceof Rectangle && (rectangle = (Rectangle)logicalElement).getLogicalElementCount() > 0) {
            return SectionSplitter.unsplittable(rectangle.getLogicalElement(0));
        }
        return false;
    }

    protected void partition(ILogicalElementHolder iLogicalElementHolder, ILogicalElementHolder iLogicalElementHolder2, ILogicalElementHolder iLogicalElementHolder3) throws Exception {
        int n = RenderUtil.getPaddingTop(iLogicalElementHolder) + RenderUtil.getBorderTop(iLogicalElementHolder);
        int n2 = RenderUtil.getPaddingBottom(iLogicalElementHolder) + RenderUtil.getBorderBottom(iLogicalElementHolder);
        this.m_AboveSplit -= n2;
        Iterator<LogicalElement> iterator = iLogicalElementHolder.getLogicalElementIterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                LogicalElement logicalElement = iterator.next();
                boolean bl = this.isAbove(logicalElement, this.m_AboveSplit);
                boolean bl2 = this.isBelow(logicalElement, this.m_AboveSplit);
                if (bl && bl2 && !SectionSplitter.canSplit(logicalElement)) {
                    m_Log.error((Object)("Error splitting " + logicalElement.getTagName() + " top=" + logicalElement.getTop() + " height=" + logicalElement.getHeight() + " split=" + this.m_AboveSplit));
                }
                if (bl && !bl2) {
                    this.addToAboveList(logicalElement);
                    iLogicalElementHolder2.addLogicalElement(logicalElement);
                    continue;
                }
                if (!(!bl2 || bl || logicalElement.getTop() <= n && this.m_ForceSplit)) {
                    if (logicalElement.getTop() < this.m_BelowSplit) {
                        this.m_BelowSplit = logicalElement.getTop();
                    }
                    this.addToBelowList(logicalElement);
                    iLogicalElementHolder3.addLogicalElement(logicalElement);
                    continue;
                }
                if (bl2 && !bl && this.m_ForceSplit && SectionSplitter.unsplittable(logicalElement)) {
                    m_Log.warn((Object)"Attempt to split an unsplittable");
                    logicalElement.setHeight(this.m_AboveSplit - logicalElement.getTop());
                    this.addToAboveList(logicalElement);
                    iLogicalElementHolder2.addLogicalElement(logicalElement);
                    continue;
                }
                LogicalElement logicalElement2 = (LogicalElement)logicalElement.shallowCopy();
                LogicalElement logicalElement3 = (LogicalElement)logicalElement.shallowCopy();
                this.addToAboveList(logicalElement2);
                iLogicalElementHolder2.addLogicalElement(logicalElement2);
                this.addToBelowList(logicalElement3);
                iLogicalElementHolder3.addLogicalElement(logicalElement3);
                if (iLogicalElementHolder instanceof LogicalElement) {
                    // empty if block
                }
                if (!(logicalElement instanceof ILogicalElementHolder)) continue;
                this.partition((ILogicalElementHolder)((Object)logicalElement), (ILogicalElementHolder)((Object)logicalElement2), (ILogicalElementHolder)((Object)logicalElement3));
            }
        }
        this.m_AboveSplit += n2;
    }

    private void addToAboveList(LogicalElement logicalElement) {
        this.m_AboveList.add(logicalElement);
        if (logicalElement instanceof ILogicalElementHolder) {
            Iterator<LogicalElement> iterator = ((ILogicalElementHolder)((Object)logicalElement)).getLogicalElementIterator();
            while (iterator.hasNext()) {
                this.addToAboveList(iterator.next());
            }
        }
    }

    private void addToBelowList(LogicalElement logicalElement) {
        this.m_BelowList.add(logicalElement);
        if (logicalElement instanceof ILogicalElementHolder) {
            Iterator<LogicalElement> iterator = ((ILogicalElementHolder)((Object)logicalElement)).getLogicalElementIterator();
            while (iterator.hasNext()) {
                this.addToBelowList(iterator.next());
            }
        }
    }

    protected void adjustAbove() {
        for (LogicalElement logicalElement : this.m_AboveList) {
            int n;
            int n2 = logicalElement.getTop();
            if (n2 + (n = logicalElement.getHeight()) <= this.m_AboveSplit) continue;
            n = Math.max(0, this.m_AboveSplit - n2);
            logicalElement.setHeight(n);
            logicalElement.setSplit("Above");
        }
        Iterator<LogicalElement> iterator = this.m_AboveList.listIterator(this.m_AboveList.size());
        while (iterator.hasPrevious()) {
            LogicalElement logicalElement;
            logicalElement = (LogicalElement)iterator.previous();
            if (!SectionSplitter.canShrink(logicalElement)) continue;
            RenderUtil.growShrinkRectangle((Rectangle)logicalElement);
        }
    }

    private static boolean canShrink(LogicalElement logicalElement) {
        if (logicalElement instanceof Rectangle) {
            RawModelElement rawModelElement = logicalElement.getRaw();
            if (rawModelElement instanceof Table) {
                return true;
            }
            if (rawModelElement instanceof TableBody) {
                return true;
            }
            if (rawModelElement instanceof TableHeader) {
                return true;
            }
            if (rawModelElement instanceof TableFooter) {
                return true;
            }
            if (rawModelElement instanceof HBox) {
                return true;
            }
            if (rawModelElement instanceof VBox) {
                return true;
            }
        }
        return false;
    }

    protected void adjustBelow2() {
        int n = 0;
        for (LogicalElement logicalElement : this.m_BelowList) {
            int n2 = logicalElement.getTop();
            int n3 = logicalElement.getHeight();
            if (n2 < this.m_BelowSplit) {
                int n4;
                if (!SectionSplitter.canSplit(logicalElement) && logicalElement.getTop() != 0) continue;
                logicalElement.setTop(0);
                logicalElement.setHeight(n3 -= this.m_BelowSplit - n2);
                logicalElement.setSplit("Below");
                if (!(logicalElement instanceof ILogicalElementHolder) || (n4 = RenderUtil.getBorderTop(logicalElement) + RenderUtil.getPaddingTop(logicalElement)) <= 0) continue;
                this.expandSelfAndParents2(logicalElement, n4);
                if (n4 <= n) continue;
                n = n4;
                continue;
            }
            logicalElement.setTop(n2 - this.m_BelowSplit);
        }
        this.m_BelowPart.setHeight(this.m_BelowPart.getHeight() + n);
        this.pushDown(this.m_BelowPart, n);
    }

    private void expandSelfAndParents2(LogicalElement logicalElement, int n) {
        logicalElement.setTop(logicalElement.getTop() - n);
        logicalElement.setHeight(logicalElement.getHeight() + n);
        LogicalElement logicalElement2 = this.getParent(this.m_BelowList, logicalElement);
        if (logicalElement2 != null) {
            this.growParent(logicalElement, logicalElement2);
        }
    }

    private void growParent(LogicalElement logicalElement, LogicalElement logicalElement2) {
        int n;
        int n2 = logicalElement.getTop();
        int n3 = logicalElement2.getTop();
        if (n3 + (n = RenderUtil.getBorderTop(logicalElement2) + RenderUtil.getPaddingTop(logicalElement2)) > n2) {
            int n4 = n3 + n - n2;
            logicalElement2.setTop(n3 - n4);
            logicalElement2.setHeight(logicalElement2.getHeight() + n4);
            LogicalElement logicalElement3 = this.getParent(this.m_BelowList, logicalElement2);
            if (logicalElement3 != null) {
                this.growParent(logicalElement2, logicalElement3);
            }
        }
    }

    private LogicalElement getParent(List<LogicalElement> list, LogicalElement logicalElement) {
        for (LogicalElement logicalElement2 : list) {
            ILogicalElementHolder iLogicalElementHolder;
            if (!(logicalElement2 instanceof ILogicalElementHolder) || !(iLogicalElementHolder = (ILogicalElementHolder)((Object)logicalElement2)).getLogicalElementList().contains(logicalElement)) continue;
            return logicalElement2;
        }
        return null;
    }

    private void pushDown(ILogicalElementHolder iLogicalElementHolder, int n) {
        Iterator<LogicalElement> iterator = iLogicalElementHolder.getLogicalElementIterator();
        while (iterator.hasNext()) {
            LogicalElement logicalElement = iterator.next();
            logicalElement.setTop(logicalElement.getTop() + n);
            if (!(logicalElement instanceof ILogicalElementHolder)) continue;
            this.pushDown((ILogicalElementHolder)((Object)logicalElement), n);
        }
    }

    public final boolean isAbove(LogicalElement logicalElement, int n) {
        int n2 = logicalElement.getTop();
        if (SectionSplitter.canSplit(logicalElement)) {
            return n2 < n;
        }
        int n3 = logicalElement.getHeight();
        return n2 + n3 <= n;
    }

    public final boolean isBelow(LogicalElement logicalElement, int n) {
        int n2;
        int n3 = logicalElement.getTop();
        return n3 + (n2 = logicalElement.getHeight()) > n;
    }
}

