/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.layout;

import com.elixirtech.report2.RenderException;
import com.elixirtech.report2.logical.layout.Split;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import java.util.Iterator;

public class SectionSplitter2 {
    private BodyPart m_BodyPart;
    private int m_SplitPos;
    private BodyPart m_Above;
    private BodyPart m_Below;

    public SectionSplitter2(BodyPart bodyPart, int n) throws RenderException {
        if (n <= 0) {
            throw new RenderException("Split value to small: " + n);
        }
        if (bodyPart.getHeight() <= n) {
            throw new RenderException("BodyPart doesn't need splitting");
        }
        this.m_BodyPart = bodyPart;
        this.m_SplitPos = n;
        try {
            this.m_Above = (BodyPart)this.m_BodyPart.shallowCopy();
            this.m_Below = (BodyPart)this.m_BodyPart.shallowCopy();
            this.partition();
            this.adjustAbove();
            this.adjustBelow();
        }
        catch (InstantiationException instantiationException) {
            throw new RenderException("Can't clone " + this.m_BodyPart);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RenderException("Can't clone " + this.m_BodyPart);
        }
    }

    public int getSplitPos() {
        return this.m_SplitPos;
    }

    public BodyPart getAbove() {
        return this.m_Above;
    }

    public BodyPart getBelow() {
        return this.m_Below;
    }

    private void partition() throws RenderException {
        int n = this.m_SplitPos;
        Iterator<LogicalElement> iterator = this.m_BodyPart.getLogicalElementIterator();
        while (iterator.hasNext()) {
            LogicalElement logicalElement = iterator.next();
            n = Math.min(n, SectionSplitter2.partition(this.m_Above, this.m_Below, logicalElement, this.m_SplitPos));
        }
    }

    private void adjustAbove() {
        this.m_Above.setHeight(this.m_SplitPos);
    }

    private void adjustBelow() {
        this.m_Below.setHeight(this.m_BodyPart.getHeight() - this.m_SplitPos);
        Iterator<LogicalElement> iterator = this.m_Below.getLogicalElementIterator();
        while (iterator.hasNext()) {
            LogicalElement logicalElement = iterator.next();
            SectionSplitter2.moveUp(logicalElement, this.m_SplitPos);
        }
    }

    protected static int partition(ILogicalElementHolder iLogicalElementHolder, ILogicalElementHolder iLogicalElementHolder2, LogicalElement logicalElement, int n) throws RenderException {
        if (SectionSplitter2.isCompletelyAbove(logicalElement, n)) {
            iLogicalElementHolder.addLogicalElement(logicalElement);
            return n;
        }
        if (SectionSplitter2.isCompletelyBelow(logicalElement, n)) {
            iLogicalElementHolder2.addLogicalElement(logicalElement);
            return n;
        }
        Split split = SectionSplitter2.getSplit(logicalElement, n);
        if (split.hasAbove()) {
            iLogicalElementHolder.addLogicalElement(split.getAbove());
        }
        if (split.hasBelow()) {
            iLogicalElementHolder2.addLogicalElement(split.getBelow());
        }
        return split.getSplitPos();
    }

    protected static boolean isCompletelyAbove(LogicalElement logicalElement, int n) {
        return logicalElement.getTop() + logicalElement.getHeight() < n;
    }

    protected static boolean isCompletelyBelow(LogicalElement logicalElement, int n) {
        return logicalElement.getTop() >= n;
    }

    protected static Split getSplit(LogicalElement logicalElement, int n) throws RenderException {
        try {
            int n2 = n;
            LogicalElement logicalElement2 = (LogicalElement)logicalElement.shallowCopy();
            LogicalElement logicalElement3 = (LogicalElement)logicalElement.shallowCopy();
            if (logicalElement instanceof ILogicalElementHolder) {
                Iterator<LogicalElement> iterator = ((ILogicalElementHolder)((Object)logicalElement)).getLogicalElementIterator();
                while (iterator.hasNext()) {
                    Split split = SectionSplitter2.getSplit(iterator.next(), n);
                    if (split.hasAbove()) {
                        ((ILogicalElementHolder)((Object)logicalElement2)).addLogicalElement(split.getAbove());
                    }
                    if (split.hasBelow()) {
                        ((ILogicalElementHolder)((Object)logicalElement3)).addLogicalElement(split.getBelow());
                    }
                    n2 = Math.min(n2, split.getSplitPos());
                }
            }
            return new Split(n2, logicalElement2, logicalElement3);
        }
        catch (InstantiationException instantiationException) {
            throw new RenderException("Can't clone " + logicalElement);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RenderException("Can't clone " + logicalElement);
        }
    }

    private static void moveUp(LogicalElement logicalElement, int n) {
        logicalElement.setTop(logicalElement.getTop() - n);
        if (logicalElement instanceof ILogicalElementHolder) {
            Iterator<LogicalElement> iterator = ((ILogicalElementHolder)((Object)logicalElement)).getLogicalElementIterator();
            while (iterator.hasNext()) {
                SectionSplitter2.moveUp(iterator.next(), n);
            }
        }
    }
}

