/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.model;

import com.elixirtech.report2.logical.model.ILogicalElementHolder;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.raw.model.RawElement;
import com.elixirtech.report2.raw.model.RawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;

public class ClipUtil {
    public static void clipHolder(ILogicalElementHolder iLogicalElementHolder) {
        int n = iLogicalElementHolder.getTop() + ClipUtil.getBorderWidthTop(iLogicalElementHolder) + ClipUtil.getPaddingTop(iLogicalElementHolder);
        int n2 = iLogicalElementHolder.getTop() + iLogicalElementHolder.getHeight() - ClipUtil.getBorderWidthBottom(iLogicalElementHolder) - ClipUtil.getPaddingBottom(iLogicalElementHolder);
        ArrayList<LogicalElement> arrayList = new ArrayList<LogicalElement>();
        for (LogicalElement logicalElement : iLogicalElementHolder.getLogicalElementList()) {
            int n3 = logicalElement.getTop();
            if (n3 < n) {
                arrayList.add(logicalElement);
                continue;
            }
            if (n3 >= n2) {
                arrayList.add(logicalElement);
                continue;
            }
            int n4 = n3 + logicalElement.getHeight();
            if (n4 <= n2) continue;
            logicalElement.clip(n2 - n3);
            if (logicalElement.getHeight() != 0) continue;
            arrayList.add(logicalElement);
        }
        iLogicalElementHolder.getLogicalElementList().removeAll(arrayList);
    }

    public static int getBorderWidth(IBean iBean) {
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            if ("None".equals(rectangle.getBorderStyle())) {
                return 0;
            }
            return rectangle.getBorderWidth();
        }
        return 0;
    }

    public static int getBorderWidthTop(IBean iBean) {
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            if (!rectangle.isBorderTop() || "None".equals(rectangle.getBorderStyle())) {
                return 0;
            }
            return rectangle.getBorderWidth();
        }
        return 0;
    }

    public static int getBorderWidthBottom(IBean iBean) {
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            if (!rectangle.isBorderBottom() || "None".equals(rectangle.getBorderStyle())) {
                return 0;
            }
            return rectangle.getBorderWidth();
        }
        return 0;
    }

    public static int getPaddingTop(IBean iBean) {
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            RawModelElement rawModelElement = rectangle.getRaw();
            if (rawModelElement instanceof RawElement) {
                return ((RawElement)rawModelElement).getPaddingTop();
            }
            return 0;
        }
        return 0;
    }

    public static int getPaddingBottom(IBean iBean) {
        LogicalElementHolder logicalElementHolder;
        RawElementHolder rawElementHolder;
        if (iBean instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)iBean;
            RawModelElement rawModelElement = rectangle.getRaw();
            if (rawModelElement instanceof RawElement) {
                return ((RawElement)rawModelElement).getPaddingBottom();
            }
            return 0;
        }
        if (iBean instanceof LogicalElementHolder && (rawElementHolder = (RawElementHolder)(logicalElementHolder = (LogicalElementHolder)iBean).getRaw()) != null) {
            return rawElementHolder.getPaddingBottom();
        }
        return 0;
    }
}

