/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.model;

import com.elixirtech.report2.logical.model.LogicalElementSAXOut;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.sax.IBean;
import com.elixirtech.sax.ISAXOut;
import org.xml.sax.helpers.AttributesImpl;

public class TextSAXOut
extends LogicalElementSAXOut {
    @Override
    public String getTagName() {
        return "text";
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean) {
        Text text = (Text)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(text, attributesImpl);
        iSAXOut.startElement(iBean.getTagName(), attributesImpl);
        this.outputChild(iSAXOut, text);
        this.outputChildren(iSAXOut, text);
        iSAXOut.characters(text.getText());
        iSAXOut.endElement(iBean.getTagName());
    }

    @Override
    public void output(ISAXOut iSAXOut, IBean iBean, String string) {
        Text text = (Text)iBean;
        AttributesImpl attributesImpl = new AttributesImpl();
        this.buildAttributes(text, attributesImpl);
        iSAXOut.startElement(string, attributesImpl);
        this.outputChild(iSAXOut, text);
        this.outputChildren(iSAXOut, text);
        iSAXOut.characters(text.getText());
        iSAXOut.endElement(string);
    }

    public void buildAttributes(Text text, AttributesImpl attributesImpl) {
        String string;
        attributesImpl.addAttribute("http://www.w3.org/XML/1998/namespace", "space", "xml:space", "CDATA", "preserve");
        String string2 = text.getFontName();
        if (string2 != null) {
            string = "Font_Name";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        string2 = "Font_Size";
        attributesImpl.addAttribute("", string2, string2, "CDATA", Integer.toString(text.getFontSize()));
        string2 = "Font_Bold";
        attributesImpl.addAttribute("", string2, string2, "CDATA", text.isFontBold() ? "Yes" : "No");
        string2 = "Font_Italic";
        attributesImpl.addAttribute("", string2, string2, "CDATA", text.isFontItalic() ? "Yes" : "No");
        string2 = text.getFontColor();
        if (string2 != null) {
            string = "Font_Color";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        string2 = "Font_Underline";
        attributesImpl.addAttribute("", string2, string2, "CDATA", text.isFontUnderline() ? "Yes" : "No");
        string2 = "Font_Strikethrough";
        attributesImpl.addAttribute("", string2, string2, "CDATA", text.isFontStrikethrough() ? "Yes" : "No");
        string2 = text.getTextAlign();
        if (string2 != null) {
            string = "Text_Align";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        if ((string2 = text.getURL()) != null) {
            string = "URL";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        if ((string2 = text.getURLDescription()) != null) {
            string = "URL_Description";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        if ((string2 = text.getURLTarget()) != null) {
            string = "URL_Target";
            attributesImpl.addAttribute("", string, string, "CDATA", string2);
        }
        string2 = "Orientation";
        attributesImpl.addAttribute("", string2, string2, "CDATA", Integer.toString(text.getOrientation()));
        super.buildAttributes(text, attributesImpl);
    }

    public void outputChild(ISAXOut iSAXOut, Text text) {
        super.outputChild(iSAXOut, text);
    }

    public void outputChildren(ISAXOut iSAXOut, Text text) {
        super.outputChildren(iSAXOut, text);
    }
}

