/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.model.CheckBox;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.util.ImageLoader;
import com.elixirtech.report2.util.LogicalImageLoader;

public class CheckBoxRenderer
extends BasicLogicalRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(CheckBoxRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) {
        CheckBox checkBox = (CheckBox)rawModelElement;
        if (checkBox.isVisible()) {
            Rectangle rectangle = CheckBoxRenderer.buildRect(checkBox);
            rectangle.setCurvedClip(false);
            rectangle.setPaddedClip(true);
            Image image = new Image();
            this.insetBorder(checkBox, image);
            boolean bl = CheckBoxRenderer.getValue(logicalRenderContext, checkBox);
            ControlSource controlSource = bl ? checkBox.getOnImage() : checkBox.getOffImage();
            ImageLoader.Descriptor descriptor = LogicalImageLoader.resolve(logicalRenderContext, controlSource);
            if (descriptor == null) {
                return;
            }
            if (descriptor.image != null) {
                image.setImage(descriptor.image);
            }
            image.setPicture(descriptor.name);
            image.setSizeMode("Clip");
            image.setHorizontalAlign(checkBox.getHorizontalAlign());
            image.setVerticalAlign(checkBox.getVerticalAlign());
            rectangle.addLogicalElement(image);
            logicalRenderContext.addElement(rectangle);
        }
    }

    protected java.awt.Image getImage(LogicalRenderContext logicalRenderContext, String string) {
        return ImageLoader.loadFromPath(logicalRenderContext, string);
    }

    protected static boolean getValue(LogicalRenderContext logicalRenderContext, CheckBox checkBox) {
        Object object = ControlSourceProcessor.getData(checkBox.getControlSource());
        return object != null && !Boolean.FALSE.equals(object);
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

