/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.util.URLUtil;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.graphics.Graphics2DWrapper;
import com.elixirtech.graphics.IGraphics2D;
import com.elixirtech.js.BasicScope;
import com.elixirtech.js.PrivilegedJavaProxy;
import com.elixirtech.js.ScriptException;
import com.elixirtech.js.ScriptManager;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.util.ImageLoader;
import com.elixirtech.report2.util.LogicalImageLoader;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.mozilla.javascript.Scriptable;

public class ImageRenderer
extends BasicLogicalRenderer {
    public static long i = 0L;
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(ImageRenderer.class);
    private static final ElxLoggerJ m_JSLog = ElxLoggerJ.getLogger((String)"JavaScript");

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) {
        com.elixirtech.report2.raw.model.Image image = (com.elixirtech.report2.raw.model.Image)rawModelElement;
        if (image.isVisible()) {
            try {
                Object object;
                ReportSubstitution reportSubstitution = new ReportSubstitution();
                Rectangle rectangle = ImageRenderer.buildRect(image);
                rectangle.setCurvedClip(true);
                rectangle.setPaddedClip(true);
                com.elixirtech.report2.logical.model.Image image2 = new com.elixirtech.report2.logical.model.Image();
                image2.setRaw(image);
                this.insetBorder(image, image2);
                image2.setSizeMode(image.getSizeMode());
                image2.setHorizontalAlign(image.getHorizontalAlign());
                image2.setVerticalAlign(image.getVerticalAlign());
                image2.setURL(ArgumentMap.substitute(image.getURL(), reportSubstitution));
                image2.setURLDescription(ArgumentMap.substitute(image.getURLDescription(), reportSubstitution));
                image2.setURLTarget(ArgumentMap.substitute(image.getURLTarget(), reportSubstitution));
                ControlSource controlSource = image.getControlSource();
                String string = controlSource.getType();
                if ("URL".equals(string)) {
                    object = ArgumentMap.substitute(controlSource.getURL(), reportSubstitution);
                    if (!URLUtil.isURL((String)object)) {
                        object = "resource:" + (String)object;
                    }
                    image2.setPicture((String)object);
                } else {
                    object = LogicalImageLoader.resolve(logicalRenderContext, controlSource);
                    if (object == null) {
                        return;
                    }
                    if (((ImageLoader.Descriptor)object).image != null) {
                        image2.setImage(((ImageLoader.Descriptor)object).image);
                    } else {
                        image2.setPicture(ArgumentMap.substitute(((ImageLoader.Descriptor)object).name, reportSubstitution));
                    }
                }
                object = image.getScript();
                if (!Script.isEmpty((Script)object)) {
                    this.drawScriptedImage(image, image2, (Script)object, reportSubstitution);
                }
                rectangle.addLogicalElement(image2);
                logicalRenderContext.addElement(rectangle);
            }
            catch (Throwable throwable) {
                m_Log.error((Object)("Can't render image " + image.getControlSource().getDisplayNameValue() + ": " + throwable.getMessage()));
                m_Log.warn((Object)"Stack Trace", throwable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawScriptedImage(com.elixirtech.report2.raw.model.Image image, com.elixirtech.report2.logical.model.Image image2, Script script, ReportSubstitution reportSubstitution) throws IOException {
        Image image3 = image2.getImage();
        if (image3 == null) {
            ImageRenderer.loadImage(image, image2);
            image3 = image2.getImage();
        }
        if (image.isLoadError()) {
            m_Log.warn((Object)("Load image error" + image.getName()));
            return;
        }
        Graphics2D graphics2D = (Graphics2D)image3.getGraphics();
        try {
            int n = image3.getHeight(null);
            int n2 = image3.getWidth(null);
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            IGraphics2D iGraphics2D = PrivilegedJavaProxy.getProxy(IGraphics2D.class, new Graphics2DWrapper(graphics2D));
            java.awt.Rectangle rectangle = new java.awt.Rectangle(0, 0, n2, n);
            hashMap.put("g", iGraphics2D);
            hashMap.put("rc", rectangle);
            BasicScope basicScope = new BasicScope(hashMap);
            this.execute(basicScope, "ImagePaint", ArgumentMap.substitute(script.getText(), reportSubstitution));
            image2.setPicture(image2.getPicture() + i++);
        }
        finally {
            if (graphics2D != null) {
                graphics2D.dispose();
            }
        }
    }

    public Object execute(BasicScope basicScope, String string, String string2) {
        try {
            ArrayList<Scriptable> arrayList = new ArrayList<Scriptable>();
            arrayList.add((Scriptable)basicScope);
            ScriptManager scriptManager = new ScriptManager(string);
            return scriptManager.evaluate(arrayList, string, string2);
        }
        catch (ScriptException scriptException) {
            m_JSLog.warn((Object)(string + ": " + scriptException));
            return null;
        }
    }

    public static void loadImage(com.elixirtech.report2.raw.model.Image image, com.elixirtech.report2.logical.model.Image image2) {
        Object object;
        Image image3 = image2.getImage();
        Image image4 = null;
        ControlSource controlSource = image.getControlSource();
        String string = controlSource.getType();
        if ("URL".equals(string)) {
            object = image.getResourceProvider();
            String string2 = controlSource.getURL();
            image4 = ImageLoader.getImage((IResourceProvider)object, string2);
        }
        if (image4 == null) {
            object = StandardColor.lookup(image.getBackgroundColor(), Color.WHITE);
            int n = (image.getWidth() - image.getPaddingTop() - image.getPaddingBottom() - image.getBorderWidth()) / 20;
            int n2 = (image.getHeight() - image.getPaddingLeft() - image.getPaddingRight() - image.getBorderWidth()) / 20;
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            Graphics graphics = bufferedImage.getGraphics();
            Color color = graphics.getColor();
            graphics.setColor((Color)object);
            graphics.fillRect(0, 0, n, n2);
            graphics.setColor(color);
            graphics.dispose();
            image4 = bufferedImage;
        }
        if (image3 != null && image3 != image4) {
            image3.flush();
        }
        image2.setImage(image4);
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

