/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.glint.GlintOutput;
import com.elixirtech.report2.data.ControlSourceProcessor;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.RenderUtil;
import com.elixirtech.report2.logical.model.ByteArray;
import com.elixirtech.report2.logical.model.Glint;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalModelElement;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.SizableElement;
import com.elixirtech.report2.logical.renderer.BasicLogicalRenderer;
import com.elixirtech.report2.raw.constants.Alignment;
import com.elixirtech.report2.raw.model.ControlSource;
import com.elixirtech.report2.raw.model.RTF;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.util.ContextSubstitution;
import com.elixirtech.rtf.RtfGraphicsWalker;
import com.elixirtech.rtf.RtfGroup;
import com.elixirtech.rtf.RtfReader;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RTFRenderer
extends BasicLogicalRenderer {
    public static final String START_RTF = "$\\{";
    public static final String END_RTF = "\\}";
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(RTFRenderer.class);

    @Override
    public void render(LogicalRenderContext logicalRenderContext, RawModelElement rawModelElement) {
        RTF rTF = (RTF)rawModelElement;
        if (rTF.isVisible()) {
            ControlSource controlSource = rTF.getControlSource();
            Object object = ControlSourceProcessor.getData(controlSource);
            String string = String.valueOf(object);
            string = ContextSubstitution.substitute(logicalRenderContext, string, START_RTF, END_RTF);
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = RTFRenderer.buildRect(rTF);
            this.insetBorder(rTF, rectangle);
            try {
                int n;
                Object object2;
                Object object3;
                RtfGroup rtfGroup = null;
                if (rTF.isGrowable() || rTF.isShrinkable()) {
                    rtfGroup = this.getRoot(string);
                    object3 = new BufferedImage(1, 1, 2);
                    object2 = (Graphics2D)((BufferedImage)object3).getGraphics();
                    ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    ((Graphics2D)object2).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                    float f = this.getHeight((Graphics2D)object2, rtfGroup, rectangle.getWidth() / 20);
                    ((Graphics)object2).dispose();
                    ((Image)object3).flush();
                    n = rectangle.getHeight() / 20;
                    if (f > (float)n && rawModelElement.isGrowable()) {
                        n = (int)Math.ceil(f * 20.0f);
                        rectangle.setHeight(n);
                    } else if (f < (float)n && rawModelElement.isShrinkable()) {
                        n = (int)Math.ceil(f * 20.0f);
                        rectangle.setHeight(n);
                    }
                }
                if (rTF.isShowAsImage()) {
                    if (rtfGroup == null) {
                        rtfGroup = this.getRoot(string);
                    }
                    int n2 = rectangle.getWidth() / 20;
                    int n3 = rectangle.getHeight() / 20;
                    int n4 = rTF.getImageResolution();
                    if (n4 < 72) {
                        n4 = 72;
                    }
                    n = n2 * n4 / 72;
                    int n5 = n3 * n4 / 72;
                    BufferedImage bufferedImage = new BufferedImage(n, n5, 2);
                    Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                    graphics2D.clipRect(0, 0, n, n5);
                    graphics2D.scale((double)n4 / 72.0, (double)n4 / 72.0);
                    java.awt.Rectangle rectangle3 = new java.awt.Rectangle(0, 0, n2, n3);
                    RtfGraphicsWalker rtfGraphicsWalker = new RtfGraphicsWalker(rectangle3, graphics2D);
                    rtfGroup.walk(rtfGraphicsWalker);
                    graphics2D.dispose();
                    bufferedImage.flush();
                    com.elixirtech.report2.logical.model.Image image = new com.elixirtech.report2.logical.model.Image();
                    image.setLeft(rectangle.getLeft());
                    image.setTop(rectangle.getTop());
                    image.setWidth(rectangle.getWidth());
                    image.setHeight(rectangle.getHeight());
                    image.setRaw(rTF);
                    image.setPicture("RTFImage");
                    image.setSizeMode("Zoom");
                    image.setHorizontalAlign(Alignment.CENTER.NAME);
                    image.setVerticalAlign(Alignment.CENTER.NAME);
                    image.setImage(bufferedImage);
                    rectangle2.addLogicalElement(image);
                    RenderUtil.growShrinkRectangle(rectangle2);
                } else {
                    object3 = new Glint();
                    ((LogicalElement)object3).setLeft(rectangle.getLeft());
                    ((LogicalElement)object3).setTop(rectangle.getTop());
                    ((LogicalElement)object3).setWidth(rectangle.getWidth());
                    ((SizableElement)object3).setHeight(rectangle.getHeight());
                    ((LogicalModelElement)object3).setRaw(rTF);
                    ((Glint)object3).setImageResolution(rTF.getImageResolution());
                    object2 = new ByteArrayOutputStream();
                    GlintOutput glintOutput = new GlintOutput((OutputStream)object2);
                    glintOutput.init(rectangle.getWidth(), rectangle.getHeight(), 1);
                    glintOutput.drawRTF(0, 0, rectangle.getWidth(), rectangle.getHeight(), string);
                    glintOutput.flush();
                    ByteArray byteArray = new ByteArray();
                    byteArray.setBytes(((ByteArrayOutputStream)object2).toByteArray());
                    ((Glint)object3).setByteArray(byteArray);
                    rectangle2.addLogicalElement((LogicalElement)object3);
                    RenderUtil.growShrinkRectangle(rectangle2);
                }
            }
            catch (IOException iOException) {
                m_Log.warn((Object)("Can't load RTF: " + iOException), (Throwable)iOException);
            }
            logicalRenderContext.addElement(rectangle2);
        }
    }

    private RtfGroup getRoot(String string) throws IOException {
        byte[] byArray = string.getBytes("UTF-8");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        RtfReader rtfReader = new RtfReader(byteArrayInputStream);
        return rtfReader.getTreeRoot();
    }

    public float getHeight(Graphics2D graphics2D, RtfGroup rtfGroup, int n) {
        java.awt.Rectangle rectangle = new java.awt.Rectangle(0, 0, n, Integer.MAX_VALUE);
        RtfGraphicsWalker rtfGraphicsWalker = new RtfGraphicsWalker(rectangle, graphics2D, true);
        rtfGroup.walk(rtfGraphicsWalker);
        return rtfGraphicsWalker.getBottom();
    }

    @Override
    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

