/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.StringUtil;
import com.elixirtech.data2.Data;
import com.elixirtech.data2.DataException;
import com.elixirtech.data2.DataRecord;
import com.elixirtech.data2.DataSchema;
import com.elixirtech.data2.DataTable;
import com.elixirtech.data2.GroupNode;
import com.elixirtech.data2.IDataSource;
import com.elixirtech.map.model.MapFile;
import com.elixirtech.map.panel.MapView;
import com.elixirtech.report2.RenderContainer;
import com.elixirtech.report2.data.IDataCache;
import com.elixirtech.report2.data.IDataCacheManager;
import com.elixirtech.report2.logical.DataHolder;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.raw.model.MapElement;
import com.elixirtech.report2.raw.model.Section;
import java.awt.Rectangle;

public class ReportMapView
extends MapView {
    private LogicalRenderContext m_Context;
    private MapElement m_Map;
    private ReportSubstitution m_Substitution;

    public ReportMapView(LogicalRenderContext logicalRenderContext, MapElement mapElement, MapFile mapFile, ReportSubstitution reportSubstitution) {
        super(mapFile);
        this.m_Context = logicalRenderContext;
        this.m_Map = mapElement;
        this.m_Substitution = reportSubstitution;
    }

    @Override
    protected String getFillDataColumn() {
        return this.m_Map.getDataColumn();
    }

    @Override
    protected int getDataPrimaryKeyIndex() {
        int n = -1;
        if (this.m_Table != null) {
            DataSchema dataSchema = this.m_Table.getSchema();
            n = dataSchema.getColumnIndex(this.m_Map.getDataKey());
        }
        return n;
    }

    @Override
    protected IDataSource getDataSource() throws DataException {
        return ReportMapView.getDataTable(this.m_Context, this.m_Map);
    }

    @Override
    public String getValue(String string, String string2) {
        return this.m_Substitution.getValue(string, string2);
    }

    public Rectangle getPlotRect() {
        return this.m_PlotView.getRectangle();
    }

    private static DataTable getDataTable(LogicalRenderContext logicalRenderContext, MapElement mapElement) throws DataException {
        DataTable dataTable;
        String string = mapElement.getDataSource();
        String string2 = mapElement.getDataRange();
        Section section = mapElement.getChunk().getSection();
        String string3 = section.getDataSource();
        if (StringUtil.isEmpty(string) || string.equals(string3)) {
            Data data = logicalRenderContext.getData();
            if ("All".equals(string2)) {
                dataTable = data.getDataTable();
            } else if ("Group".equals(string2)) {
                DataTable dataTable2 = data.getDataTable();
                GroupNode groupNode = data.getGroup();
                int n = groupNode.getStart();
                int n2 = groupNode.getStop();
                dataTable = dataTable2.subTable(n, n2 - n + 1);
            } else {
                DataTable dataTable3 = data.getDataTable();
                int n = data.getRecordIndex();
                dataTable = dataTable3.subTable(n, 1);
            }
        } else {
            DataRecord[] dataRecordArray;
            IDataCacheManager iDataCacheManager = RenderContainer.get(IDataCacheManager.class);
            Object object = iDataCacheManager.getCacheName(string);
            IDataCache iDataCache = null;
            boolean bl = false;
            if (iDataCacheManager.hasCache(object)) {
                iDataCache = iDataCacheManager.getCache(object);
                bl = true;
            } else {
                dataRecordArray = new DataHolder((String)object);
                iDataCache = iDataCacheManager.loadCache((String)object, dataRecordArray.getProperties());
            }
            if ("All".equals(string2) || "Group".equals(string2)) {
                dataTable = DataTable.build(iDataCache);
            } else {
                dataRecordArray = new DataRecord[]{iDataCache.getRecord()};
                dataTable = new DataTable(string, iDataCache.getSchema(), dataRecordArray);
            }
            if (!bl && iDataCache.hasParameters()) {
                iDataCacheManager.removeCache(object);
            }
        }
        return dataTable;
    }
}

