/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.report2.logical.renderer.TextTree;
import com.elixirtech.report2.logical.renderer.WidthEqualizer;
import java.util.Iterator;

class RowWidthEqualizer
implements WidthEqualizer {
    protected int[] m_Widths = new int[20];
    protected int m_Depth = 0;

    public RowWidthEqualizer(TextTree textTree, int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.setWidth(i, nArray[i]);
        }
        this.readTree(textTree.getRoot(), 0);
        this.adjustWidths();
        this.applyWidths(textTree.getRoot(), 0);
    }

    @Override
    public int[] getWidths() {
        int[] nArray = new int[this.m_Depth + 1];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.m_Widths[i];
        }
        return nArray;
    }

    public int getWidth(int n) {
        if (n < this.m_Widths.length) {
            return this.m_Widths[n];
        }
        return 0;
    }

    protected void adjustWidths() {
    }

    private void readTree(TextTree.TextEx textEx, int n) {
        this.setWidth(n, textEx.getWidth());
        ++n;
        Iterator<TextTree.TextEx> iterator = textEx.getChildIterator();
        while (iterator.hasNext()) {
            this.readTree(iterator.next(), n);
        }
    }

    private void applyWidths(TextTree.TextEx textEx, int n) {
        if (textEx.hasChildren()) {
            textEx.setWidth(this.m_Widths[n]);
            ++n;
            Iterator<TextTree.TextEx> iterator = textEx.getChildIterator();
            while (iterator.hasNext()) {
                this.applyWidths(iterator.next(), n);
            }
        } else {
            textEx.setWidth(this.remaining(n));
        }
    }

    private int remaining(int n) {
        int n2 = 0;
        for (int i = n; i <= this.m_Depth; ++i) {
            n2 += this.m_Widths[i];
        }
        return n2;
    }

    private void setWidth(int n, int n2) {
        if (n > this.m_Depth) {
            this.m_Depth = n;
        }
        if (n >= this.m_Widths.length) {
            this.growWidths(n);
        }
        this.m_Widths[n] = Math.max(this.m_Widths[n], n2);
    }

    private void growWidths(int n) {
        int n2 = Math.max(n + 1, this.m_Widths.length + 20);
        int[] nArray = new int[n2];
        for (int i = 0; i < this.m_Widths.length; ++i) {
            nArray[i] = this.m_Widths[i];
        }
        this.m_Widths = nArray;
    }
}

