/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.data2.ArgumentMap;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.ReportSubstitution;
import com.elixirtech.report2.logical.model.BodyPart;
import com.elixirtech.report2.logical.model.ReportHeader;
import com.elixirtech.report2.logical.renderer.IChunkRenderer;
import com.elixirtech.report2.logical.renderer.TOCElementRenderer;
import com.elixirtech.report2.raw.model.Chunk;
import com.elixirtech.report2.raw.model.SectionHeader;

public class SectionHeaderRenderer
implements IChunkRenderer {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SectionHeaderRenderer.class);

    @Override
    public BodyPart render(LogicalRenderContext logicalRenderContext, Chunk chunk) {
        SectionHeader sectionHeader = (SectionHeader)chunk;
        if (sectionHeader.isVisible()) {
            ReportHeader reportHeader = new ReportHeader();
            reportHeader.setRaw(sectionHeader);
            reportHeader.setWidth(logicalRenderContext.getBodyWidth());
            reportHeader.setHeight(sectionHeader.getHeight());
            reportHeader.setBackgroundColor(sectionHeader.getBackgroundColor());
            ReportSubstitution reportSubstitution = new ReportSubstitution();
            String string = ArgumentMap.substitute(sectionHeader.getURL(), reportSubstitution);
            String string2 = ArgumentMap.substitute(sectionHeader.getURLDescription(), reportSubstitution);
            String string3 = ArgumentMap.substitute(sectionHeader.getURLTarget(), reportSubstitution);
            reportHeader.setURL(string);
            reportHeader.setURLDescription(string2);
            reportHeader.setURLTarget(string3);
            reportHeader.setKeepTogether(sectionHeader.isKeepTogether());
            reportHeader.setKeepWithNext(sectionHeader.isKeepWithNext());
            reportHeader.setVerticalAlign(sectionHeader.getVerticalAlign());
            reportHeader.setCaption(sectionHeader.getCaption());
            if (sectionHeader.isTableOfContents()) {
                reportHeader.setTableOfContents(true);
                reportHeader.setTOCTitle(TOCElementRenderer.processControlSource(logicalRenderContext, sectionHeader));
                reportHeader.setTOCLevel(logicalRenderContext.getTOCLevel());
                logicalRenderContext.incTOCLevel();
            }
            logicalRenderContext.renderChildren(sectionHeader, reportHeader);
            return reportHeader;
        }
        return null;
    }

    protected ElxLoggerJ getLog() {
        return m_Log;
    }
}

