/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.logical.renderer;

import com.elixirtech.arch.MimeType;
import com.elixirtech.arch.MimeTypes;
import com.elixirtech.graphics.TextAlignment;
import com.elixirtech.graphics.VerticalAlignment;
import com.elixirtech.graphics.text.TextBuilder;
import com.elixirtech.graphics.text.TextLine;
import com.elixirtech.report2.logical.ITextWrapper;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.raw.model.Field;
import com.elixirtech.report2.raw.property.LineHeight;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TextWrapper2 {
    private LogicalRenderContext m_Context;
    private Field m_Field;
    private Rectangle m_Rect;
    private String m_String;
    private boolean m_CanGrow;
    private boolean m_CanShrink;
    private List<ITextWrapper.Text> m_TextLines = new ArrayList<ITextWrapper.Text>();
    private Rectangle m_BoundingBox;
    private final boolean m_ContextAutoWrap;
    private static final Set<MimeType> NON_FRACTIONAL_TYPES = new HashSet<MimeType>();

    public TextWrapper2(LogicalRenderContext logicalRenderContext, Field field, Rectangle rectangle, String string) {
        this.m_Context = logicalRenderContext;
        this.m_ContextAutoWrap = logicalRenderContext.isAutoWrap();
        this.m_Field = field;
        this.m_Rect = rectangle;
        this.m_String = string;
        this.m_CanGrow = this.m_Field.isGrowable();
        this.m_CanShrink = this.m_Field.isShrinkable();
    }

    public void doLayout() {
        int n = this.normalizeOrientation(this.m_Field.getOrientation());
        if (n < 90) {
            this.buildLayout();
            this.rotate0();
        } else if (n < 180) {
            this.invert(this.m_Rect);
            boolean bl = this.m_CanGrow;
            this.m_CanGrow = false;
            this.buildLayout();
            this.m_CanGrow = bl;
            this.invert(this.m_Rect);
            this.rotate90();
        } else if (n < 270) {
            this.buildLayout();
            this.rotate180();
        } else {
            this.invert(this.m_Rect);
            boolean bl = this.m_CanGrow;
            this.m_CanGrow = false;
            this.buildLayout();
            this.m_CanGrow = bl;
            this.invert(this.m_Rect);
            this.rotate270();
        }
    }

    protected boolean isAutoWrap() {
        return this.m_ContextAutoWrap && this.m_Field.isAutoWrap();
    }

    protected void buildLayout() {
        float f = this.isAutoWrap() ? (float)this.m_Rect.width / 20.0f : Float.MAX_VALUE;
        float f2 = (float)this.m_Rect.height / 20.0f;
        HashMap<TextAttribute, Object> hashMap = new HashMap<TextAttribute, Object>();
        hashMap.put(TextAttribute.FAMILY, this.m_Field.getFontName());
        hashMap.put(TextAttribute.SIZE, new Float((float)this.m_Field.getFontSize() / 20.0f));
        hashMap.put(TextAttribute.WEIGHT, this.m_Field.isFontBold() ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
        hashMap.put(TextAttribute.POSTURE, this.m_Field.isFontItalic() ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        Font font = new Font(hashMap);
        MimeType mimeType = this.m_Context.getMimeType();
        boolean bl = TextWrapper2.isUseFractionalMetrics(mimeType);
        FontRenderContext fontRenderContext = new FontRenderContext(null, true, bl);
        this.m_String = this.m_String + "\n";
        String[] stringArray = this.m_String.split("\n");
        int n = this.m_Field.getFirstLineIndent();
        float f3 = (float)n / 20.0f;
        if (Math.abs(f3) >= f) {
            n = 0;
        }
        float f4 = this.m_Rect.y;
        TextAlignment textAlignment = TextAlignment.get(this.m_Field.getTextAlign());
        LineHeight lineHeight = this.m_Field.getLineHeightValue();
        for (int i = 0; i < stringArray.length; ++i) {
            LineMetrics lineMetrics = font.getLineMetrics(stringArray[i], fontRenderContext);
            TextBuilder textBuilder = new TextBuilder();
            textBuilder.setAlignment(textAlignment);
            textBuilder.setCanGrow(this.m_Field.isGrowable());
            textBuilder.setDimension(f, f2);
            textBuilder.setFirstLineIndent(f3);
            if (stringArray[i].length() == 0) {
                stringArray[i] = " ";
            }
            textBuilder.setText(stringArray[i], font);
            textBuilder.buildLayouts(fontRenderContext, 0);
            int n2 = textBuilder.getLineCount();
            for (int j = 0; j < n2; ++j) {
                TextLine textLine = textBuilder.getTextLine(j);
                ITextWrapper.Text text = new ITextWrapper.Text();
                text.line = stringArray[i].substring(textLine.beginIndex, textLine.endIndex);
                text.layout = textLine.layout;
                text.rc = new Rectangle();
                int n3 = this.m_Rect.x;
                int n4 = this.m_Rect.width;
                if (j == 0 && n > 0) {
                    n3 += n;
                    n4 -= n;
                } else if (j > 0 && n < 0) {
                    n3 -= n;
                    n4 += n;
                }
                text.rc.x = n3;
                text.rc.y = (int)f4;
                text.rc.width = n4;
                text.rc.height = (int)((lineMetrics.getAscent() + lineMetrics.getDescent()) * 20.0f);
                text.lastLineOfParagraph = j == n2 - 1;
                this.addLine(text);
                f4 += lineHeight.getValue(lineMetrics.getHeight() * 20.0f);
            }
        }
    }

    public Iterator<ITextWrapper.Text> getLines() {
        return this.m_TextLines.iterator();
    }

    protected void rotate0() {
        if (this.m_BoundingBox != null) {
            VerticalAlignment verticalAlignment = VerticalAlignment.get(this.m_Field.getVerticalAlign());
            float f = 0.0f;
            if (verticalAlignment == VerticalAlignment.CENTER) {
                f = (this.m_Rect.height - this.m_BoundingBox.height) / 2;
            } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
                f = this.m_Rect.height - this.m_BoundingBox.height;
            }
            if (f < 0.0f && this.m_CanGrow) {
                f = 0.0f;
            } else if (f > 0.0f && this.m_CanShrink) {
                f = 0.0f;
            }
            if (f != 0.0f) {
                AffineTransform affineTransform = new AffineTransform();
                affineTransform.translate(0.0, f);
                this.transformLines(affineTransform);
            }
        }
    }

    protected void rotate90() {
        if (this.m_BoundingBox != null) {
            VerticalAlignment verticalAlignment = VerticalAlignment.get(this.m_Field.getVerticalAlign());
            float f = this.m_Rect.width;
            if (verticalAlignment == VerticalAlignment.CENTER) {
                f = this.m_Rect.width - (this.m_Rect.width - this.m_BoundingBox.height) / 2;
            } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
                f = this.m_BoundingBox.height;
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(f, 0.0);
            affineTransform.rotate(1.5707963267948966);
            this.transformLines(affineTransform);
        }
    }

    protected void rotate180() {
        int n = this.m_CanShrink ? this.m_BoundingBox.height : this.m_Rect.height;
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.m_Rect.width, n);
        affineTransform.rotate(Math.PI);
        this.transformLines(affineTransform);
    }

    protected void rotate270() {
        if (this.m_BoundingBox != null) {
            float f;
            VerticalAlignment verticalAlignment = VerticalAlignment.get(this.m_Field.getVerticalAlign());
            float f2 = 0.0f;
            float f3 = f = this.m_CanShrink ? (float)this.m_BoundingBox.width : (float)this.m_Rect.height;
            if (verticalAlignment == VerticalAlignment.CENTER) {
                f2 = this.m_Rect.width - (this.m_Rect.width - this.m_BoundingBox.height) / 2;
            } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
                f2 = this.m_Rect.width - this.m_BoundingBox.height;
            }
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(f2, f);
            affineTransform.rotate(-1.5707963267948966);
            this.transformLines(affineTransform);
        }
    }

    protected void transformLines(AffineTransform affineTransform) {
        for (ITextWrapper.Text text : this.m_TextLines) {
            text.rc.x -= this.m_Rect.x;
            text.rc.y -= this.m_Rect.y;
            Shape shape = affineTransform.createTransformedShape(text.rc);
            text.rc = shape.getBounds();
            text.rc.x += this.m_Rect.x;
            text.rc.y += this.m_Rect.y;
        }
    }

    protected void addLine(ITextWrapper.Text text) {
        this.m_BoundingBox = this.m_BoundingBox == null ? new Rectangle(text.rc) : this.m_BoundingBox.union(text.rc);
        this.m_TextLines.add(text);
    }

    protected int normalizeOrientation(int n) {
        while (n < 0) {
            n += 360;
        }
        while (n >= 360) {
            n -= 360;
        }
        return n;
    }

    protected void invert(Rectangle rectangle) {
        int n = rectangle.width;
        rectangle.width = rectangle.height;
        rectangle.height = n;
    }

    protected static boolean isUseFractionalMetrics(MimeType mimeType) {
        return !NON_FRACTIONAL_TYPES.contains(mimeType);
    }

    static {
        NON_FRACTIONAL_TYPES.add(MimeTypes.HTML());
        NON_FRACTIONAL_TYPES.add(MimeTypes.HTML_ZIP());
        NON_FRACTIONAL_TYPES.add(MimeTypes.XHTML());
        NON_FRACTIONAL_TYPES.add(MimeTypes.XHTML_ZIP());
    }
}

