/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.docx;

import com.elixirtech.arch.LoggingHelper2;
import com.elixirtech.arch.LoggingInterface;
import com.elixirtech.cell.CellStructure;
import com.elixirtech.cell.HAlign;
import com.elixirtech.cell.HAlign$;
import com.elixirtech.cell.HAlign$Center$;
import com.elixirtech.cell.HAlign$Left$;
import com.elixirtech.cell.HAlign$Right$;
import com.elixirtech.cell.VAlign;
import com.elixirtech.cell.VAlign$;
import com.elixirtech.cell.VAlign$Bottom$;
import com.elixirtech.cell.VAlign$Center$;
import com.elixirtech.cell.VAlign$Top$;
import com.elixirtech.opc.Relationship;
import com.elixirtech.opc.doc.BasicTableCell;
import com.elixirtech.opc.doc.CellContent;
import com.elixirtech.opc.doc.DOCConstants$;
import com.elixirtech.opc.doc.Field;
import com.elixirtech.opc.doc.FileBasedDocument;
import com.elixirtech.opc.doc.GraphicContent$;
import com.elixirtech.opc.doc.NoContent$;
import com.elixirtech.opc.doc.Run;
import com.elixirtech.opc.doc.Run$;
import com.elixirtech.opc.doc.Span;
import com.elixirtech.opc.doc.TextContent;
import com.elixirtech.report2.logical.LogicalRenderContext;
import com.elixirtech.report2.logical.model.Glint;
import com.elixirtech.report2.logical.model.Image;
import com.elixirtech.report2.logical.model.LogicalElement;
import com.elixirtech.report2.logical.model.LogicalElementHolder;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.logical.model.SVG;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.physical.ImageUtil;
import com.elixirtech.report2.physical.docx.CSBuilder$VSpacer$;
import com.elixirtech.report2.physical.docx.ChunkAnalysis;
import com.elixirtech.report2.physical.docx.DocxGenerator$;
import com.elixirtech.report2.physical.docx.PageInfo;
import com.elixirtech.report2.physical.docx.TableBuilder$;
import com.elixirtech.report2.util.ImageLoader;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class CSBuilder
implements LoggingHelper2 {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(CSBuilder.class.getDeclaredField("log$lzy1"));
    private volatile Object log$lzy1;
    private final PageInfo pageInfo;
    private final LogicalRenderContext cxt;
    private final FileBasedDocument document;
    private final Function1 lookupField;

    public CSBuilder(PageInfo pageInfo, LogicalRenderContext cxt, FileBasedDocument document) {
        this.pageInfo = pageInfo;
        this.cxt = cxt;
        this.document = document;
        this.lookupField = (Function1 & Serializable)x$1 -> {
            String string = x$1;
            if ("#".equals(string)) {
                return new Field("PAGE", BoxesRunTime.boxToInteger((int)(pageInfo.number() + 1)).toString());
            }
            if ("##".equals(string)) {
                return new Field("NUMPAGES", BoxesRunTime.boxToInteger((int)pageInfo.count()).toString());
            }
            throw new MatchError((Object)string);
        };
    }

    public LoggingInterface log() {
        Object object = this.log$lzy1;
        if (object instanceof LoggingInterface) {
            return (LoggingInterface)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (LoggingInterface)this.log$lzyINIT1();
    }

    private Object log$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.log$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    LoggingInterface loggingInterface = null;
                    try {
                        loggingInterface = LoggingHelper2.log$((LoggingHelper2)this);
                        object2 = loggingInterface == null ? LazyVals.NullValue$.MODULE$ : loggingInterface;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.log$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return loggingInterface;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public CellStructure render(ChunkAnalysis analysis, LogicalElementHolder holder) {
        List<Object> colWidths = analysis.dims().colWidths();
        List<Object> colHeights = analysis.dims().colHeights();
        if (colWidths.isEmpty()) {
            CellStructure cs = new CellStructure("vspacer", 1);
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), colHeights.size()).foreach((Function1 & Serializable)rowIdx -> cs.addCell(BoxesRunTime.unboxToInt((Object)rowIdx), 0, 1, 1, CSBuilder$VSpacer$.MODULE$));
            return cs;
        }
        CellStructure cs = new CellStructure(holder.getTagName(), colWidths.size());
        IntRef yPos = IntRef.create((int)0);
        ((List)colHeights.zipWithIndex()).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                int n;
                int h = tuple2._1$mcI$sp();
                int rowIdx = tuple2._2$mcI$sp();
                IntRef xPos = IntRef.create((int)0);
                ((List)colWidths.zipWithIndex()).foreach((Function1)((JProcedure1 & Serializable)arg_0 -> this.render$$anonfun$2$$anonfun$1(analysis, xPos, yPos, cs, rowIdx, arg_0)));
                yPos$1.elem = n = yPos$1.elem + h;
                return;
            }
            throw new MatchError((Object)tuple2);
        });
        while (cs.rows().size() < colHeights.size()) {
            cs.rows().$plus$eq((Object)cs.emptyRow());
        }
        return cs;
    }

    private BasicTableCell buildText(Rectangle rc, Text baseText) {
        String alignment = this.align(baseText.getTextAlign());
        List<TextContent> txtList = this.buildTextList(alignment, rc);
        BasicTableCell cell = new BasicTableCell(txtList);
        cell.fontName_$eq(this.adjustFontName(baseText.getFontName()));
        cell.fontSize_$eq(baseText.getFontSize() / 10);
        cell.bold_$eq(baseText.isFontBold());
        cell.italic_$eq(baseText.isFontItalic());
        cell.underline_$eq(baseText.isFontUnderline());
        cell.strikethrough_$eq(baseText.isFontStrikethrough());
        cell.align_$eq(this.align(baseText.getTextAlign()));
        Option$.MODULE$.apply((Object)baseText.getFontColor()).foreach((Function1)(JProcedure1 & Serializable)fg -> Option$.MODULE$.apply((Object)StandardColor.lookup(fg, null)).foreach((Function1)(JProcedure1 & Serializable)fgc -> cell.fg_$eq((Option<String>)Some$.MODULE$.apply((Object)DocxGenerator$.MODULE$.hexColor((Color)fgc)))));
        Option$.MODULE$.apply((Object)rc.getBackgroundColor()).foreach((Function1)(JProcedure1 & Serializable)bg -> Option$.MODULE$.apply((Object)StandardColor.lookup(bg, null)).foreach((Function1)(JProcedure1 & Serializable)bgc -> cell.bg_$eq((Option<String>)Some$.MODULE$.apply((Object)DocxGenerator$.MODULE$.hexColor((Color)bgc)))));
        TableBuilder$.MODULE$.setBorder(rc, cell);
        return cell;
    }

    private List<TextContent> buildTextList(String alignment, Rectangle rc) {
        String string = alignment;
        String string2 = "both";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            String appendedText = (String)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(rc.getLogicalElementList()).asScala().filter((Function1 & Serializable)_$1 -> _$1 instanceof Text)).foldLeft((Object)"", (Function2 & Serializable)(s, t) -> this.append((String)s, this.extractString((LogicalElement)t)));
            TextContent txt = new TextContent(this.buildRuns(appendedText));
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TextContent[]{txt}));
        }
        List txtList = ((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(rc.getLogicalElementList()).asScala().filter((Function1 & Serializable)_$2 -> _$2 instanceof Text)).map((Function1 & Serializable)t -> new TextContent(this.buildRuns(this.extractString((LogicalElement)t))))).toList();
        return txtList;
    }

    private String append(String s1, String s2) {
        if (s1.length() == 0) {
            return s2;
        }
        if (s2.length() == 0) {
            return s1;
        }
        if (s1.endsWith(" ")) {
            return s1 + s2;
        }
        if (s2.startsWith(" ")) {
            return s1 + s2;
        }
        return s1 + " " + s2;
    }

    private String adjustFontName(String s) {
        String string = s.toLowerCase();
        if ("serif".equals(string)) {
            return "Times New Roman";
        }
        if ("sansserif".equals(string)) {
            return "Arial";
        }
        return s;
    }

    private String extractString(LogicalElement e) {
        LogicalElement logicalElement = e;
        if (logicalElement instanceof Text) {
            Text t = (Text)logicalElement;
            return (String)Option$.MODULE$.apply((Object)t.getText()).getOrElse(CSBuilder::extractString$$anonfun$1);
        }
        return "";
    }

    private BasicTableCell buildRect(Rectangle rc) {
        BasicTableCell cell = new BasicTableCell(NoContent$.MODULE$);
        Option$.MODULE$.apply((Object)rc.getBackgroundColor()).foreach((Function1)(JProcedure1 & Serializable)bg -> Option$.MODULE$.apply((Object)StandardColor.lookup(bg, null)).foreach((Function1)(JProcedure1 & Serializable)bgc -> cell.bg_$eq((Option<String>)Some$.MODULE$.apply((Object)DocxGenerator$.MODULE$.hexColor((Color)bgc)))));
        TableBuilder$.MODULE$.setBorder(rc, cell);
        return cell;
    }

    private String align(String s) {
        if (s.equalsIgnoreCase("left")) {
            return "left";
        }
        if (s.equalsIgnoreCase("right")) {
            return "right";
        }
        if (s.equalsIgnoreCase("center")) {
            return "center";
        }
        if (s.equalsIgnoreCase("justify")) {
            return "both";
        }
        return "left";
    }

    private BasicTableCell buildGlint(Rectangle rc, Glint glint) {
        CellContent cellContent;
        int imageResolution = glint.getImageResolution();
        if (glint.getWidth() > 0 && glint.getHeight() > 0 && imageResolution > 0) {
            BufferedImage image = ImageUtil.getImage(glint, imageResolution);
            String fullPath = this.document.storeImage(image);
            String refId = this.document.addRelationship(new Relationship(DOCConstants$.MODULE$.TypeImage(), fullPath.substring(6)));
            cellContent = GraphicContent$.MODULE$.apply(refId, glint.getWidth(), glint.getHeight());
        } else {
            cellContent = NoContent$.MODULE$;
        }
        NoContent$ content = cellContent;
        BasicTableCell cell = new BasicTableCell(content);
        Option$.MODULE$.apply((Object)rc.getBackgroundColor()).foreach((Function1)(JProcedure1 & Serializable)bg -> Option$.MODULE$.apply((Object)StandardColor.lookup(bg, null)).foreach((Function1)(JProcedure1 & Serializable)bgc -> cell.bg_$eq((Option<String>)Some$.MODULE$.apply((Object)DocxGenerator$.MODULE$.hexColor((Color)bgc)))));
        TableBuilder$.MODULE$.setBorder(rc, cell);
        return cell;
    }

    private BasicTableCell buildSVG(Rectangle rc, SVG svg) {
        CellContent cellContent;
        int imageResolution = svg.getImageResolution();
        if (svg.getWidth() > 0 && svg.getHeight() > 0 && imageResolution > 0) {
            BufferedImage image = ImageUtil.getImage(rc, svg, imageResolution);
            String fullPath = this.document.storeImage(image);
            String refId = this.document.addRelationship(new Relationship(DOCConstants$.MODULE$.TypeImage(), fullPath.substring(6)));
            cellContent = GraphicContent$.MODULE$.apply(refId, svg.getWidth(), svg.getHeight());
        } else {
            cellContent = NoContent$.MODULE$;
        }
        NoContent$ content = cellContent;
        BasicTableCell cell = new BasicTableCell(content);
        Option$.MODULE$.apply((Object)rc.getBackgroundColor()).foreach((Function1)(JProcedure1 & Serializable)bg -> Option$.MODULE$.apply((Object)StandardColor.lookup(bg, null)).foreach((Function1)(JProcedure1 & Serializable)bgc -> cell.bg_$eq((Option<String>)Some$.MODULE$.apply((Object)DocxGenerator$.MODULE$.hexColor((Color)bgc)))));
        TableBuilder$.MODULE$.setBorder(rc, cell);
        return cell;
    }

    private BasicTableCell buildImage(Rectangle rc) {
        CellContent cellContent;
        Image im = (Image)rc.getLogicalElement(0);
        Option optImage = Option$.MODULE$.apply((Object)((BufferedImage)im.getImage())).orElse(() -> this.$anonfun$6(im));
        Option option = optImage;
        if (option instanceof Some) {
            BufferedImage image = (BufferedImage)((Some)option).value();
            BufferedImage fullImage = this.adjustImageToFit(rc, im, image);
            String fullPath = this.document.storeImage(fullImage);
            String refId = this.document.addRelationship(new Relationship(DOCConstants$.MODULE$.TypeImage(), fullPath.substring(6)));
            cellContent = GraphicContent$.MODULE$.apply(refId, im.getWidth(), im.getHeight());
        } else if (None$.MODULE$.equals(option)) {
            cellContent = NoContent$.MODULE$;
        } else {
            throw new MatchError((Object)option);
        }
        NoContent$ content = cellContent;
        BasicTableCell cell = new BasicTableCell(content);
        Option$.MODULE$.apply((Object)rc.getBackgroundColor()).foreach((Function1)(JProcedure1 & Serializable)bg -> Option$.MODULE$.apply((Object)StandardColor.lookup(bg, null)).foreach((Function1)(JProcedure1 & Serializable)bgc -> cell.bg_$eq((Option<String>)Some$.MODULE$.apply((Object)DocxGenerator$.MODULE$.hexColor((Color)bgc)))));
        TableBuilder$.MODULE$.setBorder(rc, cell);
        return cell;
    }

    private Option<BufferedImage> loadImage(Image im) {
        String url = im.getPicture();
        return Option$.MODULE$.apply((Object)ImageLoader.loadFromPath(this.cxt, url)).map((Function1 & Serializable)img -> {
            java.awt.Image image = img;
            if (image instanceof BufferedImage) {
                BufferedImage ret = (BufferedImage)image;
                return ret;
            }
            return this.asBufferedImage((java.awt.Image)img);
        });
    }

    private BufferedImage asBufferedImage(java.awt.Image raw) {
        BufferedImage actualImage = new BufferedImage(raw.getWidth(null), raw.getHeight(null), 2);
        Graphics g = actualImage.getGraphics();
        g.drawImage(raw, 0, 0, null);
        g.dispose();
        return actualImage;
    }

    private BasicTableCell buildUnknown() {
        return new BasicTableCell(NoContent$.MODULE$);
    }

    private BufferedImage adjustImageToFit(Rectangle rc, Image im, BufferedImage image) {
        String sizeMode = im.getSizeMode();
        this.log().info(() -> CSBuilder.adjustImageToFit$$anonfun$1(sizeMode), Line$.MODULE$.apply(255), FullName$.MODULE$.apply("com.elixirtech.report2.physical.docx.CSBuilder.adjustImageToFit"));
        String string = sizeMode;
        String string2 = "Stretch";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            return image;
        }
        HAlign hAlign = (HAlign)HAlign$.MODULE$.apply(im.getHorizontalAlign()).getOrElse(CSBuilder::$anonfun$7);
        VAlign vAlign = (VAlign)VAlign$.MODULE$.apply(im.getVerticalAlign()).getOrElse(CSBuilder::$anonfun$8);
        int leftRightPadding = rc.getPaddingLeft() + rc.getPaddingRight();
        int topBottomPadding = rc.getPaddingTop() + rc.getPaddingBottom();
        int rcW = rc.getWidth() - leftRightPadding;
        int rcH = rc.getHeight() - topBottomPadding;
        int inferredMultiplier = image.getWidth() * 20 / rcW;
        int DPIMultiplier = scala.math.package$.MODULE$.max(3, inferredMultiplier);
        this.log().info(() -> CSBuilder.adjustImageToFit$$anonfun$2(DPIMultiplier, inferredMultiplier), Line$.MODULE$.apply(265), FullName$.MODULE$.apply("com.elixirtech.report2.physical.docx.CSBuilder.adjustImageToFit"));
        java.awt.Rectangle outer = new java.awt.Rectangle(0, 0, DPIMultiplier * (rcW / 20), DPIMultiplier * (rcH / 20));
        Dimension inner = new Dimension(image.getWidth(), image.getHeight());
        BufferedImage im2 = new BufferedImage(DPIMultiplier * (rcW / 20), DPIMultiplier * (rcH / 20), 2);
        Predef$.MODULE$.println((Object)("Fitting image to width=" + rcW / 20 + " height=" + rcH / 20 + " (actual=" + image.getWidth() + ", " + image.getHeight()));
        Graphics g = im2.getGraphics();
        String string3 = sizeMode;
        if ("Clip".equals(string3)) {
            int n;
            int n2;
            HAlign hAlign2 = hAlign;
            if (HAlign$Left$.MODULE$.equals(hAlign2)) {
                n2 = 0;
            } else if (HAlign$Right$.MODULE$.equals(hAlign2)) {
                n2 = outer.width - inner.width;
            } else if (HAlign$Center$.MODULE$.equals(hAlign2)) {
                n2 = (outer.width - inner.width) / 2;
            } else {
                throw new MatchError((Object)hAlign2);
            }
            int x = n2;
            VAlign vAlign2 = vAlign;
            if (VAlign$Top$.MODULE$.equals(vAlign2)) {
                n = 0;
            } else if (VAlign$Bottom$.MODULE$.equals(vAlign2)) {
                n = outer.height - inner.height;
            } else if (VAlign$Center$.MODULE$.equals(vAlign2)) {
                n = (outer.height - inner.height) / 2;
            } else {
                throw new MatchError((Object)vAlign2);
            }
            int y = n;
            v3 = BoxesRunTime.boxToBoolean((boolean)g.drawImage(image, x, y, null));
        } else if ("Zoom".equals(string3)) {
            double d;
            double d2;
            double wr = (double)inner.width / (double)outer.width;
            double hr = (double)inner.height / (double)outer.height;
            double ratio = scala.math.package$.MODULE$.max(wr, hr);
            double w2 = (double)inner.width / ratio;
            double h2 = (double)inner.height / ratio;
            HAlign hAlign3 = hAlign;
            if (HAlign$Left$.MODULE$.equals(hAlign3)) {
                d2 = 0.0;
            } else if (HAlign$Right$.MODULE$.equals(hAlign3)) {
                d2 = (double)outer.width - w2;
            } else if (HAlign$Center$.MODULE$.equals(hAlign3)) {
                d2 = ((double)outer.width - w2) / (double)2;
            } else {
                throw new MatchError((Object)hAlign3);
            }
            double x = d2;
            VAlign vAlign3 = vAlign;
            if (VAlign$Top$.MODULE$.equals(vAlign3)) {
                d = 0.0;
            } else if (VAlign$Bottom$.MODULE$.equals(vAlign3)) {
                d = (double)outer.height - h2;
            } else if (VAlign$Center$.MODULE$.equals(vAlign3)) {
                d = ((double)outer.height - h2) / (double)2;
            } else {
                throw new MatchError((Object)vAlign3);
            }
            double y = d;
            v3 = BoxesRunTime.boxToBoolean((boolean)g.drawImage(image, (int)x, (int)y, (int)w2, (int)h2, null));
        } else {
            v3 = BoxedUnit.UNIT;
        }
        g.dispose();
        return im2;
    }

    public void addPadding(Rectangle rc, BasicTableCell tc) {
        tc.paddingLeft_$eq(rc.getPaddingLeft());
        tc.paddingTop_$eq(rc.getPaddingTop());
        tc.paddingBottom_$eq(rc.getPaddingBottom());
        tc.paddingRight_$eq(rc.getPaddingRight());
    }

    public List<Span> buildRuns(String txt) {
        if (txt.startsWith("${")) {
            int idx = txt.indexOf("}");
            if (idx < 0) {
                return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Run[]{Run$.MODULE$.apply(txt)}));
            }
            Field field = (Field)this.lookupField().apply((Object)txt.substring(2, idx));
            return this.buildRuns(txt.substring(idx + 1)).$colon$colon((Object)field);
        }
        int idx = txt.indexOf("${");
        if (idx < 0) {
            return (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Run[]{Run$.MODULE$.apply(txt)}));
        }
        Run run = Run$.MODULE$.apply(txt.substring(0, idx));
        return this.buildRuns(txt.substring(idx)).$colon$colon((Object)run);
    }

    public Function1<String, Field> lookupField() {
        return this.lookupField;
    }

    private static final /* synthetic */ boolean $anonfun$1(IntRef xPos$2, IntRef yPos$3, LogicalElement e) {
        return e.getLeft() == xPos$2.elem && e.getTop() == yPos$3.elem;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final /* synthetic */ void render$$anonfun$2$$anonfun$1(ChunkAnalysis analysis$2, IntRef xPos$1, IntRef yPos$2, CellStructure cs$3, int rowIdx$1, Tuple2 x$1) {
        block14: {
            var7_7 = x$1;
            if (var7_7 == null) break block14;
            w = var7_7._1$mcI$sp();
            colIdx = var7_7._2$mcI$sp();
            item = analysis$2.elements().find((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$1(scala.runtime.IntRef scala.runtime.IntRef com.elixirtech.report2.logical.model.LogicalElement ), (Lcom/elixirtech/report2/logical/model/LogicalElement;)Z)((IntRef)xPos$1, (IntRef)yPos$2));
            var11_11 = item;
            if (!(var11_11 instanceof Some)) ** GOTO lbl-1000
            var12_12 = (LogicalElement)((Some)var11_11).value();
            if (var12_12 instanceof Rectangle && (rc = (Rectangle)var12_12).getHeight() > 0 && rc.getWidth() > 0) {
                if (rc.getLogicalElementCount() > 0) {
                    child = rc.getLogicalElement(0);
                    var16_15 = child;
                    if (var16_15 instanceof Text) {
                        t = (Text)var16_15;
                        v0 = this.buildText(rc, t);
                    } else if (var16_15 instanceof Image) {
                        i = (Image)var16_15;
                        v0 = this.buildImage(rc);
                    } else if (var16_15 instanceof Glint) {
                        g = (Glint)var16_15;
                        v0 = this.buildGlint(rc, g);
                    } else if (var16_15 instanceof SVG) {
                        s = (SVG)var16_15;
                        v0 = this.buildSVG(rc, s);
                    } else {
                        v0 = this.buildUnknown();
                    }
                    cell = v0;
                    cell.rowSpan_$eq(analysis$2.dims().getRowSpan(rc));
                    cell.colSpan_$eq(analysis$2.dims().getColSpan(rc));
                    this.addPadding(rc, cell);
                    v1 /* !! */  = cs$3.addCell(rowIdx$1, colIdx, cell.rowSpan(), cell.colSpan(), cell);
                } else {
                    cell = this.buildRect(rc);
                    cell.rowSpan_$eq(analysis$2.dims().getRowSpan(rc));
                    cell.colSpan_$eq(analysis$2.dims().getColSpan(rc));
                    v1 /* !! */  = cs$3.addCell(rowIdx$1, colIdx, cell.rowSpan(), cell.colSpan(), cell);
                }
            } else if (var12_12 instanceof Text) {
                t = (Text)var12_12;
                cell = new BasicTableCell(new TextContent(t.getText()));
                cell.rowSpan_$eq(analysis$2.dims().getRowSpan(t));
                cell.colSpan_$eq(analysis$2.dims().getColSpan(t));
                v1 /* !! */  = cs$3.addCell(rowIdx$1, colIdx, cell.rowSpan(), cell.colSpan(), cell);
            } else lbl-1000:
            // 2 sources

            {
                v1 /* !! */  = BoxedUnit.UNIT;
            }
            xPos$1.elem = var24_24 = xPos$1.elem + w;
            return;
        }
        throw new MatchError((Object)var7_7);
    }

    private static final String extractString$$anonfun$1() {
        return "";
    }

    private final Option $anonfun$6(Image im$1) {
        return this.loadImage(im$1);
    }

    private static final Object adjustImageToFit$$anonfun$1(String sizeMode$1) {
        return "adjustImageToFit mode=" + sizeMode$1;
    }

    private static final HAlign $anonfun$7() {
        return HAlign$Left$.MODULE$;
    }

    private static final VAlign $anonfun$8() {
        return VAlign$Top$.MODULE$;
    }

    private static final Object adjustImageToFit$$anonfun$2(int DPIMultiplier$1, int inferredMultiplier$1) {
        return "DPIMultiplier: " + DPIMultiplier$1 + " (" + inferredMultiplier$1 + ")";
    }
}

