/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.glint;

import com.elixirtech.glint.Color;
import com.elixirtech.glint.Font;
import com.elixirtech.glint.IGlint;
import com.elixirtech.glint.Pen;
import com.elixirtech.graphics.WritingMode;
import com.elixirtech.graphics.grid.GridRenderContext;
import com.elixirtech.ui.StandardColor;
import java.awt.Point;

public class GGrid
extends com.elixirtech.graphics.grid.GGrid {
    protected IGlint.FontId m_FontId;
    protected IGlint.ColorId m_FontColorId;

    public void draw(IGlint iGlint) {
        int n = this.m_Font.getStyle();
        if (this.m_FontUnderline) {
            n |= 4;
        }
        if (this.m_FontStrikethrough) {
            n |= 8;
        }
        Font font = Font.newInstance(this.m_Font.getName(), n, this.m_Font.getSize());
        this.m_FontId = iGlint.defineFont(font);
        this.m_FontColorId = iGlint.defineColor(Color.newInstance(this.m_FontColor));
        GlintGridRenderContext glintGridRenderContext = new GlintGridRenderContext(iGlint);
        this.calculate();
        this.drawConstructionLines(glintGridRenderContext);
        this.drawBoxLines(glintGridRenderContext);
        if (this.m_FontColor == StandardColor.NONE) {
            return;
        }
        if (this.m_WritingMode == WritingMode.LR_TB) {
            this.renderBoxesLRTB(glintGridRenderContext);
        } else if (this.m_WritingMode == WritingMode.RL_TB) {
            this.renderBoxesRLTB(glintGridRenderContext);
        } else if (this.m_WritingMode == WritingMode.TB_RL) {
            this.renderBoxesTBRL(glintGridRenderContext);
        } else if (this.m_WritingMode == WritingMode.TB_LR) {
            this.renderBoxesTBLR(glintGridRenderContext);
        }
    }

    @Override
    protected void drawConstructionLines(GridRenderContext gridRenderContext) {
        if (this.m_ConstructionColor != null) {
            int n;
            IGlint iGlint = ((GlintGridRenderContext)gridRenderContext).getGlint();
            Color color = Color.newInstance(this.m_ConstructionColor);
            IGlint.PenId penId = iGlint.definePen(Pen.newInstance(color, 1));
            for (n = this.m_Left; n <= this.m_Right; n += this.m_BoxSize.width) {
                iGlint.drawLine(penId, n, this.m_Top, n, this.m_Bottom);
            }
            for (n = this.m_Top; n <= this.m_Bottom; n += this.m_BoxSize.height) {
                iGlint.drawLine(penId, this.m_Left, n, this.m_Right, n);
            }
        }
    }

    @Override
    protected void drawBoxLines(GridRenderContext gridRenderContext) {
        block11: {
            int n;
            int n2;
            int n3;
            if (this.m_BoxColor == null) break block11;
            IGlint iGlint = ((GlintGridRenderContext)gridRenderContext).getGlint();
            Color color = Color.newInstance(this.m_BoxColor);
            IGlint.PenId penId = iGlint.definePen(Pen.newInstance(color, 20));
            if (this.m_BoxTop || this.m_BoxBottom) {
                n3 = this.m_Top;
                n2 = this.m_Bottom;
                if (!this.m_BoxTop) {
                    n3 += this.m_BoxSize.height;
                } else if (!this.m_BoxBottom) {
                    n2 -= this.m_BoxSize.height;
                }
                for (n = n3; n <= n2; n += this.m_BoxSize.height) {
                    iGlint.drawLine(penId, this.m_Left, n, this.m_Right, n);
                }
            }
            if (this.m_BoxSides && this.m_BoxHeight > 0) {
                if (this.m_BoxHeight >= 100) {
                    for (n3 = this.m_Left; n3 <= this.m_Right; n3 += this.m_BoxSize.width) {
                        iGlint.drawLine(penId, n3, this.m_Top, n3, this.m_Bottom);
                    }
                } else {
                    n3 = this.m_BoxHeight * this.m_BoxSize.height / 100;
                    for (n2 = this.m_Top + this.m_BoxSize.height; n2 <= this.m_Bottom; n2 += this.m_BoxSize.height) {
                        n = n2 - n3;
                        for (int i = this.m_Left; i <= this.m_Right; i += this.m_BoxSize.width) {
                            iGlint.drawLine(penId, i, n, i, n2);
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void drawCenteredString(GridRenderContext gridRenderContext, Point point, String string, double d) {
        IGlint iGlint = ((GlintGridRenderContext)gridRenderContext).getGlint();
        int n = (int)this.m_FontMeasurer.getAscent() / 2;
        if (d == 0.0) {
            iGlint.drawText(this.m_FontId, this.m_FontColorId, point.x + this.m_CharacterOffsetX, point.y + n + this.m_CharacterOffsetY, 3, string);
        } else if (d == -NINETY_DEGREES) {
            iGlint.drawRotatedText(this.m_FontId, this.m_FontColorId, point.x + n + this.m_CharacterOffsetY, point.y + this.m_CharacterOffsetX, 3, 90, string);
        } else {
            iGlint.drawRotatedText(this.m_FontId, this.m_FontColorId, point.x - n - this.m_CharacterOffsetY, point.y + this.m_CharacterOffsetX, 3, 270, string);
        }
    }

    private static class GlintGridRenderContext
    extends GridRenderContext {
        private IGlint m_Glint;

        public GlintGridRenderContext(IGlint iGlint) {
            this.m_Glint = iGlint;
        }

        public IGlint getGlint() {
            return this.m_Glint;
        }
    }
}

