/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.odf;

import com.elixirtech.odf.spreadsheet.Cell;
import com.elixirtech.odf.spreadsheet.Sheet;
import com.elixirtech.report2.physical.odf.OdfRenderContext;
import com.elixirtech.report2.physical.odf.PositionsBuilder;
import com.elixirtech.ui.StandardColor;
import java.awt.Color;
import java.awt.Rectangle;
import scala.Option;
import scala.Predef$;
import scala.math.Ordered;
import scala.runtime.RichInt$;

public interface OdfElement
extends Ordered<OdfElement> {
    public Rectangle rc();

    public static int left$(OdfElement $this) {
        return $this.left();
    }

    default public int left() {
        return this.rc().x;
    }

    public static int top$(OdfElement $this) {
        return $this.top();
    }

    default public int top() {
        return this.rc().y;
    }

    public static int bottom$(OdfElement $this) {
        return $this.bottom();
    }

    default public int bottom() {
        return this.rc().y + this.rc().height;
    }

    public static int right$(OdfElement $this) {
        return $this.right();
    }

    default public int right() {
        return this.rc().x + this.rc().width;
    }

    public static int compare$(OdfElement $this, OdfElement rhs) {
        return $this.compare(rhs);
    }

    default public int compare(OdfElement rhs) {
        if (this.rc().y < rhs.rc().y) {
            return -1;
        }
        if (this.rc().y > rhs.rc().y) {
            return 1;
        }
        if (this.rc().x < rhs.rc().x) {
            return -1;
        }
        if (this.rc().x > rhs.rc().x) {
            return 1;
        }
        return 0;
    }

    public static void offset$(OdfElement $this, int x, int y) {
        $this.offset(x, y);
    }

    default public void offset(int x, int y) {
        this.rc().x += x;
        this.rc().y += y;
    }

    public static void pushPosition$(OdfElement $this, PositionsBuilder colPositions, PositionsBuilder rowPositions) {
        $this.pushPosition(colPositions, rowPositions);
    }

    default public void pushPosition(PositionsBuilder colPositions, PositionsBuilder rowPositions) {
        colPositions.addRange(this.rc().x, this.rc().x + this.rc().width);
        rowPositions.addRange(this.rc().y, this.rc().y + this.rc().height);
    }

    public static String odfColor$(OdfElement $this, String s) {
        return $this.odfColor(s);
    }

    default public String odfColor(String s) {
        Color color = StandardColor.lookup(s);
        return "#" + OdfElement.pad6$1(RichInt$.MODULE$.toHexString$extension(Predef$.MODULE$.intWrapper(color.getRGB() & 0xFFFFFF)));
    }

    public static String odfFont$(OdfElement $this, String s) {
        return $this.odfFont(s);
    }

    default public String odfFont(String s) {
        String string = s.toLowerCase();
        switch (string == null ? 0 : string.hashCode()) {
            case -1441041215: {
                if (!"monospaced".equals(string)) break;
                return "Courier New";
            }
            case 109326717: {
                if (!"serif".equals(string)) break;
                return "Times New Roman";
            }
            case 2092881098: {
                if (!"sansserif".equals(string)) break;
                return "Arial";
            }
        }
        return s;
    }

    public static String odfBorderStyle$(OdfElement $this, String s) {
        return $this.odfBorderStyle(s);
    }

    default public String odfBorderStyle(String s) {
        String string = s;
        switch (string == null ? 0 : string.hashCode()) {
            case -1921642892: {
                if (!"Outset".equals(string)) break;
                return "solid";
            }
            case -787172261: {
                if (!"DotDash".equals(string)) break;
                return "dot-dash";
            }
            case 2433880: {
                if (!"None".equals(string)) break;
                return "none";
            }
            case 2688793: {
                if (!"Wave".equals(string)) break;
                return "wave";
            }
            case 70807805: {
                if (!"Inset".equals(string)) break;
                return "solid";
            }
            case 78956171: {
                if (!"Ridge".equals(string)) break;
                return "solid";
            }
            case 80066187: {
                if (!"Solid".equals(string)) break;
                return "solid";
            }
            case 273364754: {
                if (!"DotDotDash".equals(string)) break;
                return "dot-dot-dash";
            }
            case 2039892945: {
                if (!"Dashed".equals(string)) break;
                return "dash";
            }
            case 2052863562: {
                if (!"Dotted".equals(string)) break;
                return "dotted";
            }
            case 2052876273: {
                if (!"Double".equals(string)) break;
                return "double";
            }
            case 2141368346: {
                if (!"Groove".equals(string)) break;
                return "solid";
            }
        }
        return "solid";
    }

    public Option<Cell> render(Sheet var1, OdfRenderContext var2);

    private static String pad6$1(String s) {
        while (((String)s).length() < 6) {
            s = "0" + (String)s;
        }
        return s;
    }
}

