/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.odf;

import com.elixirtech.arch.XMLUtil;
import com.elixirtech.odf.PresentationStyle;
import com.elixirtech.odf.PresentationStyle$;
import com.elixirtech.odf.PresentationStyle$BackgroundColor$;
import com.elixirtech.odf.PresentationStyle$BorderBottom$;
import com.elixirtech.odf.PresentationStyle$BorderLeft$;
import com.elixirtech.odf.PresentationStyle$BorderRight$;
import com.elixirtech.odf.PresentationStyle$BorderTop$;
import com.elixirtech.odf.spreadsheet.Cell;
import com.elixirtech.odf.spreadsheet.Sheet;
import com.elixirtech.odf.spreadsheet.StringCell;
import com.elixirtech.report2.logical.model.Rectangle;
import com.elixirtech.report2.physical.odf.OdfElement;
import com.elixirtech.report2.physical.odf.OdfRenderContext;
import java.io.Serializable;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Some$;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.math.Ordered;

public class OdfRectangle
implements Ordered,
OdfElement {
    private final Rectangle obj;
    private final java.awt.Rectangle rc;

    public OdfRectangle(Rectangle obj) {
        this.obj = obj;
        Ordered.$init$((Ordered)this);
        this.rc = new java.awt.Rectangle(obj.getLeft(), obj.getTop(), obj.getWidth(), obj.getHeight());
    }

    @Override
    public java.awt.Rectangle rc() {
        return this.rc;
    }

    @Override
    public Option<Cell> render(Sheet sheet, OdfRenderContext cxt) {
        ListBuffer pstyles = new ListBuffer();
        this.opt(this.obj.getBackgroundColor()).foreach((Function1 & Serializable)obg -> (ListBuffer)pstyles.$plus$eq((Object)PresentationStyle$BackgroundColor$.MODULE$.apply(this.odfColor((String)obg))));
        if (this.obj.isBorderLeft() || this.obj.isBorderTop() || this.obj.isBorderRight() || this.obj.isBorderBottom()) {
            int width = this.obj.getBorderWidth() / 20;
            String style = this.odfBorderStyle(this.obj.getBorderStyle());
            String color = this.odfColor(this.obj.getBorderColor());
            if (this.obj.isBorderLeft()) {
                pstyles.$plus$eq((Object)PresentationStyle$BorderLeft$.MODULE$.apply(width, style, color));
            }
            if (this.obj.isBorderTop()) {
                pstyles.$plus$eq((Object)PresentationStyle$BorderTop$.MODULE$.apply(width, style, color));
            }
            if (this.obj.isBorderRight()) {
                pstyles.$plus$eq((Object)PresentationStyle$BorderRight$.MODULE$.apply(width, style, color));
            }
            if (this.obj.isBorderBottom()) {
                pstyles.$plus$eq((Object)PresentationStyle$BorderBottom$.MODULE$.apply(width, style, color));
            }
        }
        PresentationStyle pstyle = PresentationStyle$.MODULE$.apply((Option<String>)None$.MODULE$, (Option<String>)None$.MODULE$, (List<XMLUtil.Attr>)pstyles.toList());
        String styleId = cxt.doc().content().styleManager().getStyleId(pstyle);
        return Some$.MODULE$.apply((Object)new StringCell("", (Option<String>)Some$.MODULE$.apply((Object)styleId)));
    }

    public Option<String> opt(String s) {
        if (s == null) {
            return None$.MODULE$;
        }
        String test = s.trim();
        if (test.length() == 0) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply((Object)test);
    }
}

