/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.odf;

import com.elixirtech.arch.LoggingHelper;
import com.elixirtech.arch.logging.SLF4J;
import com.elixirtech.cell.Cell;
import com.elixirtech.cell.CellStructure;
import com.elixirtech.cell.NullCell$;
import com.elixirtech.cell.RowSpanCell$;
import com.elixirtech.cell.SpanCell$;
import com.elixirtech.odf.Document;
import com.elixirtech.odf.ZipWriter$;
import com.elixirtech.odf.spreadsheet.EmptyCell$;
import com.elixirtech.odf.spreadsheet.Row;
import com.elixirtech.odf.spreadsheet.Sheet;
import com.elixirtech.odf.spreadsheet.SpacerCell$;
import com.elixirtech.odf.spreadsheet.SpanWrapper;
import com.elixirtech.odf.spreadsheet.SpreadsheetDocument;
import com.elixirtech.report2.RenderContext;
import com.elixirtech.report2.logical.model.LogicalReport;
import com.elixirtech.report2.physical.odf.OdfElement;
import com.elixirtech.report2.physical.odf.OdfGenerator;
import com.elixirtech.report2.physical.odf.Positions;
import com.elixirtech.report2.raw.model.PageSetup;
import java.io.OutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals;
import scala.runtime.LazyVals$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import sourcecode.FullName$;
import sourcecode.Line$;

public class OdfRenderContext
extends RenderContext
implements SLF4J,
LoggingHelper {
    public static final long OFFSET$0 = LazyVals$.MODULE$.getOffsetStatic(OdfRenderContext.class.getDeclaredField("logger$lzy1"));
    private volatile Object logger$lzy1;
    private final OdfGenerator gen;
    private final OutputStream os;
    private final SpreadsheetDocument doc;
    private Positions colPositions;
    private Positions rowPositions;
    private CellStructure cellStructure;

    public OdfRenderContext(OdfGenerator gen, LogicalReport logical, OutputStream os) {
        this.gen = gen;
        this.os = os;
        super(null);
        this.doc = new SpreadsheetDocument();
        this.colPositions = null;
        this.rowPositions = null;
        this.cellStructure = null;
    }

    public Logger logger() {
        Object object = this.logger$lzy1;
        if (object instanceof Logger) {
            return (Logger)object;
        }
        if (object == LazyVals.NullValue$.MODULE$) {
            return null;
        }
        return (Logger)this.logger$lzyINIT1();
    }

    private Object logger$lzyINIT1() {
        Object object;
        block8: {
            while (true) {
                if ((object = this.logger$lzy1) == null) {
                    if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, null, (Object)LazyVals.Evaluating$.MODULE$)) continue;
                    Object object2 = null;
                    Logger logger = null;
                    try {
                        logger = LoggingHelper.logger$((LoggingHelper)this);
                        object2 = logger == null ? LazyVals.NullValue$.MODULE$ : logger;
                    }
                    finally {
                        if (!LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)LazyVals.Evaluating$.MODULE$, object2)) {
                            LazyVals.Waiting waiting = (LazyVals.Waiting)this.logger$lzy1;
                            LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, (Object)waiting, object2);
                            waiting.countDown();
                        }
                    }
                    return logger;
                }
                if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                if (object == LazyVals.Evaluating$.MODULE$) {
                    LazyVals$.MODULE$.objCAS((Object)this, OFFSET$0, object, (Object)new LazyVals.Waiting());
                    continue;
                }
                if (!(object instanceof LazyVals.Waiting)) break;
                ((LazyVals.Waiting)object).await();
            }
            return null;
        }
        return object;
    }

    public SpreadsheetDocument doc() {
        return this.doc;
    }

    public void createEmptySheet(String title, PageSetup ps, Positions colPos, Positions rowPos) {
        this.debug(() -> OdfRenderContext.createEmptySheet$$anonfun$1(title, colPos, rowPos), Line$.MODULE$.apply(30), FullName$.MODULE$.apply("com.elixirtech.report2.physical.odf.OdfRenderContext.createEmptySheet"));
        this.colPositions = colPos;
        this.rowPositions = rowPos;
        this.cellStructure = new CellStructure(title, this.colPositions.getSize());
    }

    public void addCell(OdfElement e) {
        int rowFrom = this.rowPositions.getIndex(e.top());
        int rowTo = this.rowPositions.getIndex(e.bottom());
        int rowSpan = rowTo - rowFrom;
        int colFrom = this.colPositions.getIndex(e.left());
        int colTo = this.colPositions.getIndex(e.right());
        int colSpan = colTo - colFrom;
        try {
            this.cellStructure.addCell(rowFrom, colFrom, rowSpan, colSpan, e);
        }
        catch (Exception ex) {
            this.warn(() -> OdfRenderContext.addCell$$anonfun$1(colFrom, rowFrom, colSpan, rowSpan, ex), Line$.MODULE$.apply(47), FullName$.MODULE$.apply("com.elixirtech.report2.physical.odf.OdfRenderContext.addCell"));
        }
    }

    public int getRow(int pos) {
        return this.rowPositions.getIndex(pos);
    }

    public int getColumn(int pos) {
        return this.colPositions.getIndex(pos);
    }

    public void close() {
        ZipWriter$.MODULE$.write((Document)this.doc(), this.os);
    }

    public void saveSheet() {
        Sheet sheet = new Sheet(this.doc(), this.cellStructure.name());
        int colCount = this.colPositions.getSize();
        if (colCount > 0) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), colCount - 1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)col -> {
                int diff = this.colPositions.get(col + 1) - this.colPositions.get(col);
                sheet.addColumn(diff * 20);
            });
        }
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.cellStructure.rows().size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)r -> {
            int rowHeight = this.rowPositions.get(r + 1) - this.rowPositions.get(r);
            Row row = sheet.addRow((Option<Object>)Some$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)(rowHeight * 20))));
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), this.cellStructure.columns()).foreach((Function1 & Serializable)c -> this.saveSheet$$anonfun$2$$anonfun$1(r, sheet, row, BoxesRunTime.unboxToInt((Object)c)));
        });
    }

    public String substitute(String s) {
        return this.gen.substitute(s);
    }

    public com.elixirtech.odf.spreadsheet.Cell buildCell(Sheet sheet, OdfElement e) {
        return (com.elixirtech.odf.spreadsheet.Cell)e.render(sheet, this).getOrElse(OdfRenderContext::buildCell$$anonfun$1);
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    private static final Object createEmptySheet$$anonfun$1(String title$1, Positions colPos$1, Positions rowPos$1) {
        return "sheet " + title$1 + " size " + colPos$1.getSize() + "x" + rowPos$1.getSize();
    }

    private static final Object addCell$$anonfun$1(int colFrom$1, int rowFrom$1, int colSpan$1, int rowSpan$1, Exception ex$1) {
        return "Error adding cell " + colFrom$1 + "," + rowFrom$1 + "," + colSpan$1 + "," + rowSpan$1 + ": " + ex$1;
    }

    private final /* synthetic */ ListBuffer saveSheet$$anonfun$2$$anonfun$1(int r$1, Sheet sheet$3, Row row$1, int c) {
        com.elixirtech.odf.spreadsheet.Cell cell;
        Cell cell2 = this.cellStructure.getCell(r$1, c);
        if (NullCell$.MODULE$.equals(cell2)) {
            cell = EmptyCell$.MODULE$;
        } else if (SpanCell$.MODULE$.equals(cell2)) {
            cell = SpacerCell$.MODULE$;
        } else if (RowSpanCell$.MODULE$.equals(cell2)) {
            cell = SpacerCell$.MODULE$;
        } else if (cell2 != null) {
            Cell c2 = cell2;
            com.elixirtech.odf.spreadsheet.Cell odfCell = this.buildCell(sheet$3, (OdfElement)c2.data());
            cell = c2.rowSpan() > 1 || c2.colSpan() > 1 ? new SpanWrapper(c2.rowSpan(), c2.colSpan(), odfCell) : odfCell;
        } else {
            throw new MatchError((Object)cell2);
        }
        EmptyCell$ oc = cell;
        return (ListBuffer)row$1.cells().$plus$eq((Object)oc);
    }

    private static final com.elixirtech.odf.spreadsheet.Cell buildCell$$anonfun$1() {
        return EmptyCell$.MODULE$;
    }
}

