/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.physical.ppt;

import com.elixirtech.opc.ppt.Slide;
import com.elixirtech.opc.ppt.TextInfo;
import com.elixirtech.report2.logical.model.Text;
import com.elixirtech.report2.physical.ppt.PPTRenderer;
import com.elixirtech.ui.StandardColor;
import com.elixirtech.util.VariableSubstitution;
import java.awt.Rectangle;
import java.io.IOException;

public class TextRenderer {
    private final PPTRenderer m_Renderer;
    private final Slide m_Slide;
    private final Text m_Text;

    public TextRenderer(PPTRenderer pPTRenderer, Slide slide, Text text) throws IOException {
        Rectangle rectangle;
        this.m_Renderer = pPTRenderer;
        this.m_Slide = slide;
        this.m_Text = text;
        int n = this.m_Renderer.getXOffset();
        int n2 = this.m_Renderer.getYOffset();
        int n3 = this.m_Text.getLeft();
        int n4 = this.m_Text.getTop();
        int n5 = this.m_Text.getWidth();
        int n6 = this.m_Text.getHeight();
        TextInfo textInfo = new TextInfo();
        textInfo.fontName = TextRenderer.fixFontName(this.m_Text.getFontName());
        textInfo.fontSize = this.m_Text.getFontSize();
        textInfo.fontColor = StandardColor.lookup(this.m_Text.getFontColor());
        textInfo.bold = this.m_Text.isFontBold();
        textInfo.italic = this.m_Text.isFontItalic();
        textInfo.underline = this.m_Text.isFontUnderline();
        textInfo.rotation = this.m_Text.getOrientation();
        while (textInfo.rotation < 0) {
            textInfo.rotation += 360;
        }
        while (textInfo.rotation >= 360) {
            textInfo.rotation -= 360;
        }
        if (textInfo.rotation < 90) {
            textInfo.rotation = 0;
        } else if (textInfo.rotation < 180) {
            textInfo.rotation = 90;
        } else if (textInfo.rotation < 270) {
            textInfo.rotation = 180;
        } else if (textInfo.rotation < 360) {
            textInfo.rotation = 270;
        }
        if (textInfo.rotation == 90 || textInfo.rotation == 270) {
            int n7 = n3 + n5 / 2;
            int n8 = n4 + n6 / 2;
            int n9 = n7 - n6 / 2;
            int n10 = n8 - n5 / 2;
            rectangle = new Rectangle(n + n9, n2 + n10, n6, n5);
        } else {
            rectangle = new Rectangle(n + n3, n2 + n4, n5, n6);
        }
        String string = this.m_Text.getTextAlign();
        textInfo.alignment = "Center".equals(string) ? "ctr" : ("Right".equals(string) ? "r" : ("Justify".equals(string) ? "just" : "l"));
        this.m_Slide.addText(rectangle, textInfo, VariableSubstitution.substitute(this.m_Text.getText(), this.m_Renderer));
    }

    private static String fixFontName(String string) {
        if ("SansSerif".equalsIgnoreCase(string)) {
            return "Arial";
        }
        if ("Serif".equalsIgnoreCase(string)) {
            return "Times New Roman";
        }
        if ("Monospaced".equalsIgnoreCase(string)) {
            return "Courier New";
        }
        return string;
    }
}

