/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.print;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.print.PrintChromacity;
import com.elixirtech.report2.print.PrintCopies;
import com.elixirtech.report2.print.PrintJobName;
import com.elixirtech.report2.print.PrintMediaTray;
import com.elixirtech.report2.print.PrintNumberUp;
import com.elixirtech.report2.print.PrintPageRange;
import com.elixirtech.report2.print.PrintPrintQuality;
import com.elixirtech.report2.print.PrintPrinterResolution;
import com.elixirtech.report2.print.PrintSheetCollate;
import com.elixirtech.report2.print.PrintSides;
import com.elixirtech.report2.raw.model.Parameter;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.print.attribute.Attribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.swing.Icon;

public abstract class PrintAttribute
implements Comparable<PrintAttribute> {
    private static Map<String, Class<? extends PrintAttribute>> m_Types = new HashMap<String, Class<? extends PrintAttribute>>();
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(PrintAttribute.class);

    public static PrintAttribute create(String string, String string2) {
        Class<? extends PrintAttribute> clazz = m_Types.get(string);
        if (clazz != null) {
            try {
                PrintAttribute printAttribute = clazz.newInstance();
                printAttribute.setValue(string2);
                return printAttribute;
            }
            catch (Exception exception) {
                m_Log.warn((Object)("Unable to set print attribute: " + string + "=" + string2 + " : " + exception));
            }
        }
        return null;
    }

    public static Parameter extract(Attribute attribute) {
        String string = attribute.getName();
        if (Chromaticity.COLOR.getName().equals(string)) {
            if (attribute == Chromaticity.COLOR) {
                return new Parameter("Chromacity", "Color");
            }
            return new Parameter("Chromacity", "Monochrome");
        }
        if (new Copies(1).getName().equals(string)) {
            return new Parameter("Copies", String.valueOf(((Copies)attribute).getValue()));
        }
        if (new JobName("", Locale.UK).getName().equals(string)) {
            return new Parameter("JobName", ((JobName)attribute).getValue());
        }
        if (MediaTray.TOP.getName().equals(string)) {
            if (attribute instanceof MediaTray) {
                return new Parameter("MediaTray", PrintMediaTray.getValue(((MediaTray)attribute).getValue()));
            }
            return null;
        }
        if (new NumberUp(1).getName().equals(string)) {
            return new Parameter("NumberUp", String.valueOf(((NumberUp)attribute).getValue()));
        }
        if (new PageRanges(1, 1).getName().equals(string)) {
            return new Parameter("PageRange", ((PageRanges)attribute).toString());
        }
        if (new PrinterResolution(300, 300, 100).getName().equals(string)) {
            PrinterResolution printerResolution = (PrinterResolution)attribute;
            return new Parameter("PrinterResolution", String.valueOf(printerResolution.getFeedResolution(100)));
        }
        if (PrintQuality.NORMAL.getName().equals(string)) {
            return new Parameter("PrintQuality", PrintPrintQuality.getValue(((PrintQuality)attribute).getValue()));
        }
        if (Sides.ONE_SIDED.getName().equals(string)) {
            return new Parameter("Sides", PrintSides.getValue(((Sides)attribute).getValue()));
        }
        if (SheetCollate.COLLATED.getName().equals(string)) {
            return new Parameter("SheetCollate", SheetCollate.COLLATED.equals(attribute) ? "Yes" : "No");
        }
        return null;
    }

    public abstract void buildAttributeSet(PrintRequestAttributeSet var1);

    public abstract String getName();

    public abstract void setValue(String var1);

    public abstract String getValue();

    public abstract String getValueKey();

    @Override
    public int compareTo(PrintAttribute printAttribute) {
        return this.toString().compareTo(printAttribute.toString());
    }

    public String toString() {
        return this.getRenderableName() + " : " + this.getRenderableValue();
    }

    public String getRenderableName() {
        return "Print." + this.getName();
    }

    public String getRenderableValue() {
        return this.getValue();
    }

    public Icon getRenderableIcon() {
        return null;
    }

    protected static void register(String string, Class<? extends PrintAttribute> clazz) {
        m_Types.put(string, clazz);
    }

    static {
        PrintAttribute.register("Chromacity", PrintChromacity.class);
        PrintAttribute.register("Copies", PrintCopies.class);
        PrintAttribute.register("JobName", PrintJobName.class);
        PrintAttribute.register("MediaTray", PrintMediaTray.class);
        PrintAttribute.register("NumberUp", PrintNumberUp.class);
        PrintAttribute.register("PageRange", PrintPageRange.class);
        PrintAttribute.register("Page Range", PrintPageRange.class);
        PrintAttribute.register("PrinterResolution", PrintPrinterResolution.class);
        PrintAttribute.register("PrintQuality", PrintPrintQuality.class);
        PrintAttribute.register("Sides", PrintSides.class);
        PrintAttribute.register("SheetCollate", PrintSheetCollate.class);
    }
}

