/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.processor;

import com.elixirtech.jdom.Element;
import com.elixirtech.report2.RenderConstants;
import com.elixirtech.report2.processor.DocumentProcessor;
import java.util.HashMap;

public class BoxedInTextProcessor
extends DocumentProcessor
implements RenderConstants {
    private static final String BOXEDINTEXT = "com.elixirtech.report.customplugin.boxedtext.BoxedInTextField";
    public static final String FONT_NAME = "FN";
    public static final String FONT_SIZE = "FS";
    public static final String FONT_STYLE = "FSS";
    public static final String OFFSET_POSITON_X = "OPX";
    public static final String OFFSET_POSITON_Y = "OPY";
    public static final String BOX_COUNT = "BdInCt";
    public static final String TOP_SHOW = "TS";
    public static final String BOTTOM_SHOW = "BS";
    public static final String SIDE_SHOW = "SS";
    public static final String HEIGHT_RATIO = "HR";
    public static final String COLOR = "CL";
    public static final String TRUE = "t";
    public static final String FALSE = "f";
    public static final String CONTROL_SOURCE = "CB";
    public static final String FONT_COLOR = "FC";
    public static final String TEXT_ALIGN = "TA";

    @Override
    public void processElement(Element element) {
        String string;
        if (element.getName().equals("model") && element.getNamespace() == NS_RML && BOXEDINTEXT.equals(string = element.getAttributeValue("Class_Name"))) {
            String string2 = element.getAttributeValue("Property");
            element.setName("callback");
            element.setAttribute("Type", "BoxedInText");
            element.removeAttribute("Model_Name");
            element.removeAttribute("Class_Name");
            element.removeAttribute("Version");
            element.removeAttribute("Property");
            element.removeAttribute("Embedded_Storage");
            this.addParametersFromModel(element, string2);
        }
    }

    protected void addParametersFromModel(Element element, String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length - 1; i += 2) {
            hashMap.put(stringArray[i], stringArray[i + 1]);
        }
        String string2 = (String)hashMap.get(FONT_NAME);
        String string3 = (String)hashMap.get(FONT_SIZE);
        int n = BoxedInTextProcessor.getFontStyle((String)hashMap.get(FONT_STYLE));
        element.setAttribute("Font_Name", string2);
        element.setAttribute("Font_Size", string3);
        element.setAttribute("Font_Weight", (n & 1) != 0 ? "Bold" : "Plain");
        element.setAttribute("Font_Italic", (n & 2) != 0 ? "Yes" : "No");
        element.setAttribute("Offset_Position_X", (String)hashMap.get(OFFSET_POSITON_X));
        element.setAttribute("Offset_Position_Y", (String)hashMap.get(OFFSET_POSITON_Y));
        element.setAttribute("Box_Count", (String)hashMap.get(BOX_COUNT));
        element.setAttribute("Top_Line", BoxedInTextProcessor.yesNo(hashMap.get(TOP_SHOW)));
        element.setAttribute("Side_Line", BoxedInTextProcessor.yesNo(hashMap.get(SIDE_SHOW)));
        element.setAttribute("Bottom_Line", BoxedInTextProcessor.yesNo(hashMap.get(BOTTOM_SHOW)));
        element.setAttribute("Height_Ratio", (String)hashMap.get(HEIGHT_RATIO));
        element.setAttribute("Color", (String)hashMap.get(COLOR));
        String string4 = (String)hashMap.get(FONT_COLOR);
        if (string4 == null) {
            string4 = (String)hashMap.get(COLOR);
        }
        element.setAttribute("Font_Color", string4);
        String string5 = (String)hashMap.get(TEXT_ALIGN);
        if (string5 == null) {
            string5 = "Left";
        }
        element.setAttribute("Text_Align", string5);
    }

    private static int getFontStyle(String string) {
        if (string == null) {
            return 0;
        }
        if (string.equals("plain")) {
            return 0;
        }
        if (string.equals("bold")) {
            return 1;
        }
        if (string.equals("italic")) {
            return 2;
        }
        if (string.equals("bold+italic")) {
            return 3;
        }
        return 0;
    }

    private static String yesNo(Object object) {
        if (TRUE.equals(object)) {
            return "Yes";
        }
        return "No";
    }
}

