/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.processor;

import com.elixirtech.jdom.Element;
import com.elixirtech.report2.RenderConstants;
import com.elixirtech.report2.processor.DocumentProcessor;
import java.util.Properties;

public class MRDCCleaner
extends DocumentProcessor
implements RenderConstants {
    public static final String MRDC_CLASS = "com.elixirtech.report.customplugin.cacheview.MultiRowDataCacheViewer";
    public static final String FONT_NAME = "FN";
    public static final String FONT_SIZE = "FS";
    public static final String FONT_STYLE = "FSS";
    public static final String COLOR = "CL";
    public static final String OFFSET_POSITON_X = "OPX";
    public static final String OFFSET_POSITON_Y = "OPY";
    public static final String BOX_COUNT = "BdInCt";
    public static final String TOP_SHOW = "TS";
    public static final String BOTTOM_SHOW = "BS";
    public static final String SIDE_SHOW = "SS";
    public static final String HEIGHT_RATIO = "HR";
    public static final String CACHE = "CA";
    public static final char BAR = '|';
    public static final String LEFT = "L";
    public static final String CENTER = "C";
    public static final String RIGHT = "R";

    @Override
    public void processElement(Element element) {
        if (element.getName().equals("model") && MRDC_CLASS.equals(element.getAttributeValue("Class_Name"))) {
            Properties properties = MRDCCleaner.getProperties(element);
            element.setName("multirow-data");
            element.removeAttribute("Class_Name");
            element.removeAttribute("Properties");
            element.setAttribute("Font_Name", properties.getProperty(FONT_NAME));
            element.setAttribute("Font_SIZE", properties.getProperty(FONT_SIZE));
            String string = (String)properties.get(FONT_STYLE);
            String string2 = string.equals("bold") || string.equals("bold+italic") ? "Bold" : "Plain";
            element.setAttribute("Font_Weight", string2);
            String string3 = string.equals("italic") || string.equals("bold+italic") ? "Yes" : "No";
            element.setAttribute("Font_Italic", string3);
            element.setAttribute("Box_Count", properties.getProperty(BOX_COUNT));
            element.setAttribute("Cache", properties.getProperty(CACHE));
            element.setAttribute("Color", properties.getProperty(COLOR));
            element.setAttribute("XOffset", properties.getProperty(OFFSET_POSITON_X));
            element.setAttribute("YOffset", properties.getProperty(OFFSET_POSITON_Y));
            element.setAttribute("SideHeight", properties.getProperty(HEIGHT_RATIO));
            element.setAttribute("TopBorder", "t".equals(properties.get(TOP_SHOW)) ? "Yes" : "No");
            element.setAttribute("BottomBorder", "t".equals(properties.get(BOTTOM_SHOW)) ? "Yes" : "No");
            element.setAttribute("SideBorder", "t".equals(properties.get(SIDE_SHOW)) ? "Yes" : "No");
        }
    }

    protected static Properties getProperties(Element element) {
        Properties properties = new Properties();
        String string = element.getAttributeValue("Properties");
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; i += 2) {
            if (i + 1 >= stringArray.length) continue;
            properties.put(stringArray[i], stringArray[i + 1]);
        }
        return properties;
    }
}

