/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.report2.raw.model.CubeHeader;
import com.elixirtech.report2.raw.model.CubeMeasure;
import com.elixirtech.report2.raw.model.Group;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RawReport;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.raw.model.StyleItem;
import com.elixirtech.report2.raw.model.TextElement;
import java.util.Iterator;

public class Migrator {
    private RawReport m_Report;
    private int m_Version;
    private static final ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Migrator.class);

    public Migrator(RawReport rawReport, int n) {
        this.m_Report = rawReport;
        this.m_Version = n;
        if (this.m_Version < 2) {
            this.migrateFontSize();
        }
    }

    protected void migrateFontSize() {
        Object object;
        Object object2;
        Object object3;
        Iterator<Style> iterator = this.m_Report.getStyleIterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            object2 = ((Style)object3).getStyleItemIterator();
            while (object2.hasNext()) {
                object = object2.next();
                if (!"TextElement.FontSize".equals(((StyleItem)object).getName())) continue;
                try {
                    int n = Integer.parseInt(((StyleItem)object).getValue());
                    int n2 = n * 20;
                    ((StyleItem)object).setValue(String.valueOf(n2));
                    m_Log.info((Object)("Style FontSize " + n + "pts -> " + n2 + " twips"));
                }
                catch (NumberFormatException numberFormatException) {
                    m_Log.warn((Object)("Can't migrate style font size: " + ((StyleItem)object).getValue()));
                }
            }
        }
        object3 = this.m_Report.getSectionIterator();
        while (object3.hasNext()) {
            object2 = (Section)object3.next();
            this.migrateFontSize(((Section)object2).getPageHeader());
            this.migrateFontSize(((Section)object2).getSectionHeader());
            object = ((Section)object2).getGroupIterator();
            while (object.hasNext()) {
                Group group = (Group)object.next();
                this.migrateFontSize(group.getGroupHeader());
                this.migrateFontSize(group.getGroupFooter());
            }
            this.migrateFontSize(((Section)object2).getDetail());
            this.migrateFontSize(((Section)object2).getSectionFooter());
            this.migrateFontSize(((Section)object2).getPageFooter());
        }
    }

    protected void migrateFontSize(IRawElementHolder iRawElementHolder) {
        if (iRawElementHolder == null) {
            return;
        }
        Iterator<RawModelElement> iterator = iRawElementHolder.getRawElementIterator();
        while (iterator.hasNext()) {
            RawModelElement rawModelElement = iterator.next();
            if (rawModelElement instanceof TextElement || rawModelElement instanceof CubeMeasure || rawModelElement instanceof CubeHeader) {
                int n = rawModelElement.getPropertyIndex("TextElement.FontSize");
                if (!rawModelElement.isLocalPropertyValue(n)) continue;
                Integer n2 = (Integer)rawModelElement.getPropertyValue(n);
                int n3 = n2 * 20;
                rawModelElement.setPropertyValue(n, new Integer(n3));
                m_Log.info((Object)(rawModelElement.getTagName() + " FontSize " + n2 + "pts -> " + n3 + " twips"));
                continue;
            }
            if (!(rawModelElement instanceof IRawElementHolder)) continue;
            this.migrateFontSize((IRawElementHolder)((Object)rawModelElement));
        }
    }
}

