/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.constants;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;

public final class Alignment {
    public static final int LEFT_ID = 1;
    public static final int CENTER_ID = 2;
    public static final int RIGHT_ID = 4;
    public static final int TOP_ID = 8;
    public static final int VCENTER_ID = 16;
    public static final int BOTTOM_ID = 32;
    public static final Alignment LEFT = new Alignment("Left", 1);
    public static final Alignment CENTER = new Alignment("Center", 2);
    public static final Alignment RIGHT = new Alignment("Right", 4);
    public static final Alignment TOP = new Alignment("Top", 8);
    public static final Alignment VCENTER = new Alignment("VCenter", 16);
    public static final Alignment BOTTOM = new Alignment("Bottom", 32);
    public final String NAME;
    public final int ID;

    public static Alignment getHorizontal(String string) {
        if (Alignment.LEFT.NAME.equals(string)) {
            return LEFT;
        }
        if (Alignment.CENTER.NAME.equals(string)) {
            return CENTER;
        }
        if (Alignment.RIGHT.NAME.equals(string)) {
            return RIGHT;
        }
        return LEFT;
    }

    public static Alignment getVertical(String string) {
        if (Alignment.TOP.NAME.equals(string)) {
            return TOP;
        }
        if (Alignment.CENTER.NAME.equals(string)) {
            return VCENTER;
        }
        if (Alignment.VCENTER.NAME.equals(string)) {
            return VCENTER;
        }
        if (Alignment.BOTTOM.NAME.equals(string)) {
            return BOTTOM;
        }
        return TOP;
    }

    public static int getAlignmentId(String string, String string2) {
        return Alignment.getHorizontal((String)string).ID | Alignment.getVertical((String)string2).ID;
    }

    public static Rectangle positionRect(Rectangle rectangle, Dimension dimension, int n) {
        Rectangle rectangle2 = new Rectangle(rectangle.x, rectangle.y, dimension.width, dimension.height);
        if ((n & 2) != 0) {
            rectangle2.x = rectangle.x - (dimension.width - rectangle.width) / 2;
        } else if ((n & 4) != 0) {
            rectangle2.x = rectangle.x + rectangle.width - dimension.width;
        }
        if ((n & 0x10) != 0) {
            rectangle2.y = rectangle.y - (dimension.height - rectangle.height) / 2;
        } else if ((n & 0x20) != 0) {
            rectangle2.y = rectangle.y + rectangle.height - dimension.height;
        }
        return rectangle2;
    }

    public static Rectangle2D positionRect(Rectangle2D rectangle2D, double d, double d2, int n) {
        double d3 = rectangle2D.getMinX();
        double d4 = rectangle2D.getMinY();
        if ((n & 2) != 0) {
            d3 -= (d - rectangle2D.getWidth()) / 2.0;
        } else if ((n & 4) != 0) {
            d3 = d3 + rectangle2D.getWidth() - d;
        }
        if ((n & 0x10) != 0) {
            d4 -= (d2 - rectangle2D.getHeight()) / 2.0;
        } else if ((n & 0x20) != 0) {
            d4 = d4 + rectangle2D.getHeight() - d2;
        }
        return new Rectangle2D.Double(d3, d4, d, d2);
    }

    public static Point getTopLeft(Dimension dimension, Dimension dimension2, int n) {
        int n2 = 0;
        int n3 = 0;
        if ((n & 2) != 0) {
            n2 = (dimension2.width - dimension.width) / 2;
        } else if ((n & 4) != 0) {
            n2 = dimension2.width - dimension.width;
        }
        if ((n & 0x10) != 0) {
            n3 = (dimension2.height - dimension.height) / 2;
        } else if ((n & 0x20) != 0) {
            n3 = dimension2.height - dimension.height;
        }
        return new Point(n2, n3);
    }

    public static Point getTopLeft(Dimension dimension, Rectangle rectangle, int n) {
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        if ((n & 2) != 0) {
            n2 = rectangle.x + (rectangle.width - dimension.width) / 2;
        } else if ((n & 4) != 0) {
            n2 = rectangle.x + rectangle.width - dimension.width;
        }
        if ((n & 0x10) != 0) {
            n3 = rectangle.y + (rectangle.height - dimension.height) / 2;
        } else if ((n & 0x20) != 0) {
            n3 = rectangle.y + rectangle.height - dimension.height;
        }
        return new Point(n2, n3);
    }

    public static void clipImageRect(Rectangle rectangle, Rectangle rectangle2, int n) {
        int n2;
        if ((n & 1) != 0) {
            rectangle.width = Math.min(rectangle.width, rectangle2.width);
        } else if ((n & 2) != 0) {
            n2 = rectangle.width - rectangle2.width;
            if (n2 > 0) {
                rectangle.x = n2 / 2;
                rectangle.width = rectangle2.width;
            } else if (n2 < 0) {
                rectangle2.x -= n2 / 2;
            }
        }
        if ((n & 4) != 0) {
            n2 = rectangle.width - rectangle2.width;
            if (n2 > 0) {
                rectangle.x = n2;
                rectangle.width = rectangle2.width;
            } else if (n2 < 0) {
                rectangle2.x -= n2;
            }
        }
        if ((n & 8) != 0) {
            rectangle.height = Math.min(rectangle.height, rectangle2.height);
        } else if ((n & 0x10) != 0) {
            n2 = rectangle.height - rectangle2.height;
            if (n2 > 0) {
                rectangle.y = n2 / 2;
                rectangle.height = rectangle2.height;
            } else if (n2 < 0) {
                rectangle2.y -= n2 / 2;
            }
        } else if ((n & 0x20) != 0) {
            n2 = rectangle.height - rectangle2.height;
            if (n2 > 0) {
                rectangle.y = n2;
                rectangle.height = rectangle2.height;
            } else if (n2 < 0) {
                rectangle2.y -= n2;
            }
        }
    }

    private Alignment(String string, int n) {
        this.NAME = string;
        this.ID = n;
    }
}

