/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.StyleManager;
import com.elixirtech.report2.raw.model.Cell;
import com.elixirtech.report2.raw.model.IRawElementHolder;
import com.elixirtech.report2.raw.model.ISplittableElement;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RectHolder;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public abstract class Box
extends RectHolder
implements IBean,
PropertyImplementor,
IRawElementHolder,
ISplittableElement {
    protected List<Cell> m_Cell = new ArrayList<Cell>();
    protected String m_Name;
    protected Boolean m_Visible;
    protected Boolean m_KeepTogether;
    private static String[] m_PropertyNameStrings = new String[]{"RawElement.Name".intern(), "RawElement.Visible".intern(), "Common.KeepTogether".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"String", "Boolean", "Boolean"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "box";
    }

    @Override
    public void loaded() {
        super.loaded();
        Iterator<Cell> iterator = this.m_Cell.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Cell != null) {
            Iterator<Cell> iterator = this.m_Cell.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_Cell = null;
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_Name != null) {
            element.setAttribute("name", this.m_Name);
        }
        if (this.m_Visible != null) {
            element.setAttribute("visible", this.m_Visible != false ? "Yes" : "No");
        }
        if (this.m_KeepTogether != null) {
            element.setAttribute("Keep_Together", this.m_KeepTogether != false ? "Yes" : "No");
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Box box = (Box)super.shallowCopy();
        return box;
    }

    @Override
    public int getRawElementCount() {
        return this.getCellCount();
    }

    @Override
    public RawModelElement getRawElement(int n) {
        return this.getCell(n);
    }

    public Iterator getRawElementIterator() {
        return this.getCellIterator();
    }

    public List getRawElementList() {
        return this.getCellList();
    }

    @Override
    public int indexOfRawElement(RawModelElement rawModelElement) {
        if (rawModelElement instanceof Cell) {
            return this.indexOfCell((Cell)rawModelElement);
        }
        return -1;
    }

    @Override
    public boolean isGrowable() {
        return true;
    }

    @Override
    public boolean isShrinkable() {
        return true;
    }

    public void addCell(Cell cell) {
        this.m_Cell.add(cell);
        cell.setParent(this);
    }

    public void addCell(int n, Cell cell) {
        this.m_Cell.add(n, cell);
        cell.setParent(this);
    }

    public void addAllCells(Collection<Cell> collection) {
        this.m_Cell.addAll(collection);
        for (Cell cell : collection) {
            cell.setParent(this);
        }
    }

    public int indexOfCell(Cell cell) {
        return this.m_Cell.indexOf(cell);
    }

    public void removeCell(Cell cell) {
        this.m_Cell.remove(cell);
        cell.setParent(null);
    }

    public void removeAllCells(Collection collection) {
        this.m_Cell.removeAll(collection);
        for (Cell cell : collection) {
            cell.setParent(null);
        }
    }

    public void removeAllCells() {
        for (Cell cell : this.m_Cell) {
            cell.setParent(null);
        }
        this.m_Cell.clear();
    }

    public Cell getCell(int n) {
        return this.m_Cell.get(n);
    }

    public int getCellCount() {
        return this.m_Cell.size();
    }

    public Iterator<Cell> getCellIterator() {
        return this.m_Cell.iterator();
    }

    public List<Cell> getCellList() {
        return this.m_Cell;
    }

    public void setCellList(List<Cell> list) {
        this.m_Cell = list;
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    public String getName() {
        if (this.m_Name != null) {
            return this.m_Name;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
    }

    public void setName(String string) {
        this.m_Name = string;
    }

    public boolean isVisible() {
        Boolean bl = this.m_Visible;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 2 - 1);
        }
        return bl;
    }

    public void setVisible(boolean bl) {
        this.m_Visible = bl;
    }

    public void setVisible(Boolean bl) {
        this.m_Visible = bl;
    }

    @Override
    public boolean isKeepTogether() {
        Boolean bl = this.m_KeepTogether;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 3 - 1);
        }
        return bl;
    }

    @Override
    public void setKeepTogether(boolean bl) {
        this.m_KeepTogether = bl;
    }

    @Override
    public void setKeepTogether(Boolean bl) {
        this.m_KeepTogether = bl;
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.m_Name = (String)object;
                        break;
                    }
                    case 1: {
                        this.m_Visible = (Boolean)object;
                        break;
                    }
                    case 2: {
                        this.m_KeepTogether = (Boolean)object;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + this.getClass());
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + object + "(" + object.getClass() + ") : " + exception);
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return this.getLocalPropertyValue(n) != null;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_Name;
            }
            case 1: {
                return this.m_Visible;
            }
            case 2: {
                return this.m_KeepTogether;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + this.getClass());
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        Style style;
        Object object;
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        Object object2 = null;
        Name name = m_PropertyNames[n - m_IndexOffset];
        if (this.m_Style != null) {
            object2 = this.m_Style.getValue(name);
        }
        if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
            object2 = object.getPropertyValue(name);
        }
        if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
            object2 = style.getValue(name);
        }
        if (object2 == null) {
            object2 = DefaultStyle.current().getValue(name);
        }
        return object2;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public abstract Box deepCopy();

    protected void copyInto(Box box) {
        super.copyInto(box);
        box.m_Name = this.m_Name;
        box.m_Visible = this.m_Visible;
        box.m_KeepTogether = this.m_KeepTogether;
        box.m_Cell = new ArrayList<Cell>();
        for (Cell cell : this.m_Cell) {
            box.addCell(cell.deepCopy());
        }
    }

    static {
        try {
            m_IndexOffset = RectHolder.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                Box.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                Box.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            Box.logError("Error in property initialization", throwable);
        }
    }
}

