/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.model.RawModelElement;
import com.elixirtech.report2.raw.model.RectHolder;
import com.elixirtech.report2.raw.model.Shape;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.sax.IBean;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Cell
extends RectHolder
implements IBean,
PropertyImplementor,
ChangeNotifier {
    protected Integer m_Weight;
    private Set<ChangeListener> m_ChangeListeners;
    private static String[] m_PropertyNameStrings = new String[]{"Cell.Weight".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"Integer"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        if (BeanUtil.methodMatches(string, "RawModelElement.LockHandles")) {
            return true;
        }
        return BeanUtil.methodMatches(string, "RawModelElement.Fill");
    }

    public Cell() {
        this.setWeight(100);
    }

    @Override
    public String getTagName() {
        return "cell";
    }

    @Override
    public void loaded() {
        super.loaded();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_Weight != null) {
            element.setAttribute("weight", this.m_Weight.toString());
        }
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Cell cell = (Cell)super.shallowCopy();
        return cell;
    }

    public Cell(int n) {
        this.setWeight(n);
    }

    @Override
    public void addRawElement(RawModelElement rawModelElement) {
        super.addRawElement(rawModelElement);
        Shape shape = rawModelElement.getShape();
        if (shape != null) {
            shape.setRect(this.getShape().getRect());
        }
    }

    @Override
    protected void doFill() {
    }

    @Override
    public boolean isPropertyEditable(int n) {
        if (n == this.getPropertyIndex("Common.Left")) {
            return false;
        }
        if (n == this.getPropertyIndex("Common.Top")) {
            return false;
        }
        if (n == this.getPropertyIndex("Common.Width")) {
            return false;
        }
        return n != this.getPropertyIndex("Common.Height");
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (this.m_ChangeListeners == null) {
            this.m_ChangeListeners = new HashSet<ChangeListener>();
        }
        this.m_ChangeListeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.m_ChangeListeners.remove(changeListener);
        if (this.m_ChangeListeners.size() == 0) {
            this.m_ChangeListeners = null;
        }
    }

    public void notifyChanged(String string) {
        if (this.m_ChangeListeners != null) {
            for (ChangeListener changeListener : this.m_ChangeListeners) {
                changeListener.beanChanged(this, string);
            }
        }
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    public int getWeight() {
        Integer n = this.m_Weight;
        if (n == null) {
            n = (Integer)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
        }
        return n;
    }

    public void setWeight(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_Weight = n;
        this.notifyChanged("Cell.Weight");
    }

    public void setWeight(Integer n) {
        if (n != null && n < 0) {
            n = 0;
        }
        this.m_Weight = n;
        this.notifyChanged("Cell.Weight");
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
        set.remove(Name.apply("RawModelElement.LockHandles", ""));
        set.remove(Name.apply("RawModelElement.Fill", ""));
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.setWeight((Integer)object);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + this.getClass());
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + object + "(" + object.getClass() + ") : " + exception);
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return false;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_Weight;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + this.getClass());
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        return null;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public Cell deepCopy() {
        Cell cell = new Cell();
        this.copyInto(cell);
        return cell;
    }

    protected void copyInto(Cell cell) {
        super.copyInto(cell);
        cell.m_Weight = this.m_Weight;
    }

    static {
        try {
            m_IndexOffset = RectHolder.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                Cell.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                Cell.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            Cell.logError("Error in property initialization", throwable);
        }
    }
}

