/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.arch.IAdaptable;
import com.elixirtech.arch.ICachedFile;
import com.elixirtech.arch.IDirtyState;
import com.elixirtech.arch.ISecurity;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.CacheBuilder;
import com.elixirtech.report2.raw.model.DataSource;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.ISequenceStep;
import com.elixirtech.report2.raw.model.IStyledElement;
import com.elixirtech.report2.raw.model.Metadata;
import com.elixirtech.report2.raw.model.PageSetup;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.report2.raw.model.RenderDetails;
import com.elixirtech.report2.raw.model.Script;
import com.elixirtech.report2.raw.model.Section;
import com.elixirtech.report2.raw.model.SectionInvocation;
import com.elixirtech.report2.raw.model.Security;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.report2.raw.model.StyledElement;
import com.elixirtech.report2.raw.model.StylesheetRef;
import com.elixirtech.repository.RMLFileObject;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;

public class RawReport
extends StyledElement
implements IBean,
PropertyImplementor,
ChangeNotifier,
IAdaptable,
IDirtyState,
ICachedFile,
IResourceProvider {
    private long m_LastModified;
    private RMLFileObject m_FileObject;
    private boolean m_IsDirty;
    private List<IDirtyState.Listener> m_DirtyListeners = new ArrayList<IDirtyState.Listener>();
    private Map<String, String> m_AliasMap;
    protected Metadata m_Metadata;
    protected Security m_Security;
    protected Script m_FunctionDefinitions;
    protected Script m_OnRenderBegin;
    protected Script m_OnRenderEnd;
    protected List<PageSetup> m_PageSetup = new ArrayList<PageSetup>();
    protected List<Parameter> m_Parameter = new ArrayList<Parameter>();
    protected List<DataSource> m_DataSource = new ArrayList<DataSource>();
    protected Map<String, Style> m_Style = new TreeMap<String, Style>();
    protected List<StylesheetRef> m_Stylesheet = new ArrayList<StylesheetRef>();
    protected List<Section> m_Section = new ArrayList<Section>();
    protected List<ISequenceStep> m_SequenceStep = new ArrayList<ISequenceStep>();
    protected Map<String, RenderDetails> m_RenderDetails = new HashMap<String, RenderDetails>();
    protected transient IResourceProvider m_ResourceProvider = this;
    protected Locale m_Locale;
    protected boolean m_KeepPageCount = true;
    protected boolean m_CacheAllProperties = true;
    protected String m_RepositoryBase;
    protected boolean m_GridEnabled = true;
    protected boolean m_GridVisible = false;
    protected int m_GridX = 100;
    protected int m_GridY = 100;
    protected String m_Description = "";
    protected boolean m_DisableCSVAutoWrap;
    protected boolean m_DisableExcelAutoWrap;
    private Set<ChangeListener> m_ChangeListeners;
    private static String[] m_PropertyNameStrings = new String[]{"RawReport.FunctionDefinitions".intern(), "RawReport.OnRenderBegin".intern(), "RawReport.OnRenderEnd".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"Script", "Script", "Script"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    public static boolean isHidden(String string) {
        return false;
    }

    public RawReport() {
        this.m_Security = new Security();
    }

    @Override
    public String getTagName() {
        return "report";
    }

    @Override
    public void loaded() {
        super.loaded();
        if (this.m_Metadata != null) {
            this.m_Metadata.loaded();
        }
        if (this.m_Security != null) {
            this.m_Security.loaded();
        }
        if (this.m_FunctionDefinitions != null) {
            this.m_FunctionDefinitions.loaded();
        }
        if (this.m_OnRenderBegin != null) {
            this.m_OnRenderBegin.loaded();
        }
        if (this.m_OnRenderEnd != null) {
            this.m_OnRenderEnd.loaded();
        }
        Iterator<Object> iterator = this.m_PageSetup.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
        iterator = this.m_Parameter.iterator();
        while (iterator.hasNext()) {
            iterator.next().loaded();
        }
        iterator = this.m_DataSource.iterator();
        while (iterator.hasNext()) {
            iterator.next().loaded();
        }
        for (IBean iBean : this.m_Style.values()) {
            iBean.loaded();
        }
        iterator = this.m_Stylesheet.iterator();
        while (iterator.hasNext()) {
            iterator.next().loaded();
        }
        iterator = this.m_Section.iterator();
        while (iterator.hasNext()) {
            iterator.next().loaded();
        }
        iterator = this.m_SequenceStep.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
        for (IBean iBean : this.m_RenderDetails.values()) {
            iBean.loaded();
        }
    }

    @Override
    public void dispose() {
        Iterator<Object> iterator;
        if (this.m_Metadata != null) {
            if (this.m_Metadata != null) {
                this.m_Metadata.dispose();
            }
            this.m_Metadata = null;
        }
        if (this.m_Security != null) {
            if (this.m_Security != null) {
                this.m_Security.dispose();
            }
            this.m_Security = null;
        }
        if (this.m_FunctionDefinitions != null) {
            if (this.m_FunctionDefinitions != null) {
                this.m_FunctionDefinitions.dispose();
            }
            this.m_FunctionDefinitions = null;
        }
        if (this.m_OnRenderBegin != null) {
            if (this.m_OnRenderBegin != null) {
                this.m_OnRenderBegin.dispose();
            }
            this.m_OnRenderBegin = null;
        }
        if (this.m_OnRenderEnd != null) {
            if (this.m_OnRenderEnd != null) {
                this.m_OnRenderEnd.dispose();
            }
            this.m_OnRenderEnd = null;
        }
        if (this.m_PageSetup != null) {
            iterator = this.m_PageSetup.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_PageSetup = null;
        if (this.m_Parameter != null) {
            iterator = this.m_Parameter.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
        }
        this.m_Parameter = null;
        if (this.m_DataSource != null) {
            iterator = this.m_DataSource.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
        }
        this.m_DataSource = null;
        if (this.m_Style != null) {
            for (IBean iBean : this.m_Style.values()) {
                iBean.dispose();
            }
        }
        this.m_Style = null;
        if (this.m_Stylesheet != null) {
            iterator = this.m_Stylesheet.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
        }
        this.m_Stylesheet = null;
        if (this.m_Section != null) {
            iterator = this.m_Section.iterator();
            while (iterator.hasNext()) {
                iterator.next().dispose();
            }
        }
        this.m_Section = null;
        if (this.m_SequenceStep != null) {
            iterator = this.m_SequenceStep.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_SequenceStep = null;
        if (this.m_RenderDetails != null) {
            for (IBean iBean : this.m_RenderDetails.values()) {
                iBean.dispose();
            }
        }
        this.m_RenderDetails = null;
    }

    @Override
    public void copyAttrs(Element element) {
        if (this.m_Locale != null) {
            element.setAttribute("locale", this.m_Locale.toString());
        }
        element.setAttribute("keep-page-count", this.m_KeepPageCount ? "Yes" : "No");
        element.setAttribute("cache-all-properties", this.m_CacheAllProperties ? "Yes" : "No");
        if (this.m_RepositoryBase != null) {
            element.setAttribute("repository-base", this.m_RepositoryBase);
        }
        element.setAttribute("grid-enabled", this.m_GridEnabled ? "Yes" : "No");
        element.setAttribute("grid-visible", this.m_GridVisible ? "Yes" : "No");
        element.setAttribute("grid-x", Integer.toString(this.m_GridX));
        element.setAttribute("grid-y", Integer.toString(this.m_GridY));
        if (this.m_Description != null) {
            element.setAttribute("description", this.m_Description);
        }
        element.setAttribute("disable-csv-auto-wrap", this.m_DisableCSVAutoWrap ? "Yes" : "No");
        element.setAttribute("disable-excel-auto-wrap", this.m_DisableExcelAutoWrap ? "Yes" : "No");
        super.copyAttrs(element);
    }

    @Override
    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        RawReport rawReport = (RawReport)super.shallowCopy();
        rawReport.m_ResourceProvider = this.m_ResourceProvider;
        rawReport.m_Locale = this.m_Locale;
        rawReport.m_KeepPageCount = this.m_KeepPageCount;
        rawReport.m_CacheAllProperties = this.m_CacheAllProperties;
        rawReport.m_RepositoryBase = this.m_RepositoryBase;
        rawReport.m_GridEnabled = this.m_GridEnabled;
        rawReport.m_GridVisible = this.m_GridVisible;
        rawReport.m_GridX = this.m_GridX;
        rawReport.m_GridY = this.m_GridY;
        rawReport.m_Description = this.m_Description;
        rawReport.m_DisableCSVAutoWrap = this.m_DisableCSVAutoWrap;
        rawReport.m_DisableExcelAutoWrap = this.m_DisableExcelAutoWrap;
        return rawReport;
    }

    @Override
    public <T> T getAdapter(Class<T> clazz) {
        if (clazz == IResourceProvider.class) {
            return clazz.cast(this.m_ResourceProvider);
        }
        if (clazz == ISecurity.class) {
            return clazz.cast(this.m_Security);
        }
        if (clazz == IAdaptable.class) {
            return clazz.cast(this);
        }
        if (clazz == IDirtyState.class) {
            return clazz.cast(this);
        }
        return null;
    }

    @Override
    public boolean isUpToDate() {
        return this.m_LastModified == this.m_FileObject.lastModified();
    }

    @Override
    public void setFileObject(RMLFileObject rMLFileObject) {
        this.m_FileObject = rMLFileObject;
        this.m_LastModified = this.m_FileObject.lastModified();
    }

    @Override
    public RMLFileObject getFileObject() {
        return this.m_FileObject;
    }

    @Override
    public boolean isDirty() {
        return this.m_IsDirty;
    }

    @Override
    public void setDirty(boolean bl) {
        if (this.m_IsDirty != bl) {
            this.m_IsDirty = bl;
            for (IDirtyState.Listener listener : this.m_DirtyListeners) {
                listener.dirtyStateChanged(this);
            }
        }
    }

    @Override
    public void addDirtyListener(IDirtyState.Listener listener) {
        this.m_DirtyListeners.add(listener);
    }

    @Override
    public void removeDirtyListener(IDirtyState.Listener listener) {
        this.m_DirtyListeners.remove(listener);
    }

    @Override
    public IStyledElement getParentStyledElement() {
        return null;
    }

    public String getName() {
        String string = this.m_FileObject.getName();
        if (string.endsWith(".rml")) {
            string = string.substring(0, string.length() - 4);
        }
        return string;
    }

    public String[] getStyleNames() {
        Object[] objectArray = new String[this.getStyleCount() + 1];
        int n = 0;
        objectArray[n] = "";
        Iterator<Style> iterator = this.getStyleIterator();
        while (iterator.hasNext()) {
            Style style = iterator.next();
            objectArray[++n] = style.getName();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public void renamePageSetup(String string, String string2) {
        Iterator<Section> iterator = this.getSectionIterator();
        while (iterator.hasNext()) {
            Section section = iterator.next();
            if (!string.equals(section.getPageSetup())) continue;
            section.setPageSetup(string2);
        }
        this.setDirty(true);
    }

    public void renameDataSource(String string, String string2) {
        Iterator<Section> iterator = this.getSectionIterator();
        while (iterator.hasNext()) {
            Section section = iterator.next();
            if (!string.equals(section.getDataSource())) continue;
            section.setDataSource(string2);
        }
        this.setDirty(true);
    }

    public void renameSection(String string, String string2) {
        Object object;
        Iterator<Object> iterator = this.getSequenceStepIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof SectionInvocation)) continue;
            ((SectionInvocation)object).renameSection(string, string2);
        }
        iterator = this.getSectionIterator();
        while (iterator.hasNext()) {
            object = (Section)iterator.next();
            ((Section)object).renameSection(string, string2);
        }
        this.setDirty(true);
    }

    public void renameStyle(String string, String string2) {
        Iterator<Style> iterator = this.getStyleIterator();
        while (iterator.hasNext()) {
            Style style = iterator.next();
            if (!string.equals(style.getBaseName())) continue;
            style.setBaseName(string2);
        }
        this.setDirty(true);
    }

    @Override
    public DataSource getDataSource(String string) {
        if (string == null) {
            return null;
        }
        Iterator<DataSource> iterator = this.getDataSourceIterator();
        while (iterator.hasNext()) {
            DataSource dataSource = iterator.next();
            if (!string.equals(dataSource.getName())) continue;
            return dataSource;
        }
        return null;
    }

    @Override
    public Section getSection(String string) {
        if (string == null) {
            return null;
        }
        Iterator<Section> iterator = this.getSectionIterator();
        while (iterator.hasNext()) {
            Section section = iterator.next();
            if (!string.equals(section.getName())) continue;
            return section;
        }
        return null;
    }

    @Override
    public PageSetup getPageSetup(String string) {
        Iterator<PageSetup> iterator = this.getPageSetupIterator();
        while (iterator.hasNext()) {
            PageSetup pageSetup = iterator.next();
            if (!pageSetup.getName().equals(string)) continue;
            return pageSetup;
        }
        return null;
    }

    public Parameter getParameter(String string) {
        Iterator<Parameter> iterator = this.getParameterIterator();
        while (iterator.hasNext()) {
            Parameter parameter = iterator.next();
            if (!parameter.getKey().equals(string) || !parameter.isEnabled().booleanValue()) continue;
            return parameter;
        }
        return null;
    }

    public void setParameter(String string, String string2) {
        Parameter parameter = this.getParameter(string);
        if (parameter == null) {
            parameter = new Parameter(string, string2);
            parameter.setEnabled(Boolean.TRUE);
            this.m_Parameter.add(parameter);
        } else {
            parameter.setValue(string2);
        }
        this.setDirty(true);
    }

    public void setParameters(Properties properties) {
        for (String string : properties.keySet()) {
            String string2 = properties.getProperty(string);
            this.setParameter(string, string2);
        }
    }

    public String getParameterValue(String string) {
        Parameter parameter = this.getParameter(string);
        if (parameter != null && parameter.isEnabled().booleanValue()) {
            return parameter.getValue();
        }
        return null;
    }

    @Override
    public RMLFileObject getFile(String string) {
        if (this.m_FileObject != null) {
            return this.m_FileObject.getRepository().getFileJ(string);
        }
        return null;
    }

    @Override
    public String getProperty(String string) {
        Parameter parameter = this.getParameter(string);
        if (parameter != null && parameter.isEnabled().booleanValue()) {
            return parameter.getValue();
        }
        return null;
    }

    @Override
    public String resolveRepositoryURL(String string) {
        if (StringUtil.isEmpty(string)) {
            return string;
        }
        if (string.indexOf(58) >= 0) {
            return string;
        }
        if (string.startsWith("/")) {
            return string;
        }
        if (StringUtil.isEmpty(this.m_RepositoryBase)) {
            return string;
        }
        return this.m_RepositoryBase + string;
    }

    @Override
    public String getRelativeRepositoryURL(String string) {
        if (StringUtil.isEmpty(this.m_RepositoryBase)) {
            return string;
        }
        if (string.startsWith(this.m_RepositoryBase)) {
            return string.substring(this.m_RepositoryBase.length());
        }
        return string;
    }

    public void cacheAllProperties() {
        CacheBuilder.build(this);
    }

    public Map<String, String> getAliasMap() {
        return this.m_AliasMap;
    }

    public void setAliasMap(Map<String, String> map) {
        this.m_AliasMap = map;
    }

    public Metadata getMetadata() {
        return this.m_Metadata;
    }

    public void setMetadata(Metadata metadata) {
        this.m_Metadata = metadata;
    }

    public Security getSecurity() {
        return this.m_Security;
    }

    public void setSecurity(Security security) {
        this.m_Security = security;
    }

    public void addPageSetup(PageSetup pageSetup) {
        this.m_PageSetup.add(pageSetup);
        this.notifyChanged("RawReport.PageSetup");
    }

    public void addPageSetup(int n, PageSetup pageSetup) {
        this.m_PageSetup.add(n, pageSetup);
        this.notifyChanged("RawReport.PageSetup");
    }

    public void addAllPageSetups(Collection<PageSetup> collection) {
        this.m_PageSetup.addAll(collection);
        this.notifyChanged("RawReport.PageSetup");
    }

    public int indexOfPageSetup(PageSetup pageSetup) {
        return this.m_PageSetup.indexOf(pageSetup);
    }

    public void removePageSetup(PageSetup pageSetup) {
        this.m_PageSetup.remove(pageSetup);
        this.notifyChanged("RawReport.PageSetup");
    }

    public void removeAllPageSetups(Collection collection) {
        this.m_PageSetup.removeAll(collection);
        this.notifyChanged("RawReport.PageSetup");
    }

    public void removeAllPageSetups() {
        this.m_PageSetup.clear();
        this.notifyChanged("RawReport.PageSetup");
    }

    public PageSetup getPageSetup(int n) {
        return this.m_PageSetup.get(n);
    }

    public int getPageSetupCount() {
        return this.m_PageSetup.size();
    }

    public Iterator<PageSetup> getPageSetupIterator() {
        return this.m_PageSetup.iterator();
    }

    public List<PageSetup> getPageSetupList() {
        return this.m_PageSetup;
    }

    public void setPageSetupList(List<PageSetup> list) {
        this.m_PageSetup = list;
        this.notifyChanged("RawReport.PageSetup");
    }

    public void addParameter(Parameter parameter) {
        this.m_Parameter.add(parameter);
    }

    public void addParameter(int n, Parameter parameter) {
        this.m_Parameter.add(n, parameter);
    }

    public void addAllParameters(Collection<Parameter> collection) {
        this.m_Parameter.addAll(collection);
    }

    public int indexOfParameter(Parameter parameter) {
        return this.m_Parameter.indexOf(parameter);
    }

    public void removeParameter(Parameter parameter) {
        this.m_Parameter.remove(parameter);
    }

    public void removeAllParameters(Collection collection) {
        this.m_Parameter.removeAll(collection);
    }

    public void removeAllParameters() {
        this.m_Parameter.clear();
    }

    public Parameter getParameter(int n) {
        return this.m_Parameter.get(n);
    }

    public int getParameterCount() {
        return this.m_Parameter.size();
    }

    public Iterator<Parameter> getParameterIterator() {
        return this.m_Parameter.iterator();
    }

    public List<Parameter> getParameterList() {
        return this.m_Parameter;
    }

    public void setParameterList(List<Parameter> list) {
        this.m_Parameter = list;
    }

    public void addDataSource(DataSource dataSource) {
        this.m_DataSource.add(dataSource);
        this.notifyChanged("RawReport.DataSource");
    }

    public void addDataSource(int n, DataSource dataSource) {
        this.m_DataSource.add(n, dataSource);
        this.notifyChanged("RawReport.DataSource");
    }

    public void addAllDataSources(Collection<DataSource> collection) {
        this.m_DataSource.addAll(collection);
        this.notifyChanged("RawReport.DataSource");
    }

    public int indexOfDataSource(DataSource dataSource) {
        return this.m_DataSource.indexOf(dataSource);
    }

    public void removeDataSource(DataSource dataSource) {
        this.m_DataSource.remove(dataSource);
        this.notifyChanged("RawReport.DataSource");
    }

    public void removeAllDataSources(Collection collection) {
        this.m_DataSource.removeAll(collection);
        this.notifyChanged("RawReport.DataSource");
    }

    public void removeAllDataSources() {
        this.m_DataSource.clear();
        this.notifyChanged("RawReport.DataSource");
    }

    public DataSource getDataSource(int n) {
        return this.m_DataSource.get(n);
    }

    public int getDataSourceCount() {
        return this.m_DataSource.size();
    }

    public Iterator<DataSource> getDataSourceIterator() {
        return this.m_DataSource.iterator();
    }

    public List<DataSource> getDataSourceList() {
        return this.m_DataSource;
    }

    public void setDataSourceList(List<DataSource> list) {
        this.m_DataSource = list;
        this.notifyChanged("RawReport.DataSource");
    }

    public void addStyle(Style style) {
        String string = style.getName();
        this.m_Style.put(string, style);
        style.setParent(this);
        this.notifyChanged("RawReport.Style");
    }

    public void removeStyle(Style style) {
        String string = style.getName();
        this.m_Style.remove(string);
        style.setParent(null);
        this.notifyChanged("RawReport.Style");
    }

    @Override
    public Style getStyle(String string) {
        return this.m_Style.get(string);
    }

    public Iterator<Style> getStyleIterator() {
        return this.m_Style.values().iterator();
    }

    public int getStyleCount() {
        return this.m_Style.size();
    }

    public Map<String, Style> getStyleMap() {
        return this.m_Style;
    }

    public void setStyleMap(Map<String, Style> map) {
        this.m_Style = map;
        this.notifyChanged("RawReport.Style");
    }

    public void addStylesheet(StylesheetRef stylesheetRef) {
        this.m_Stylesheet.add(stylesheetRef);
        this.notifyChanged("RawReport.Stylesheet");
    }

    public void addStylesheet(int n, StylesheetRef stylesheetRef) {
        this.m_Stylesheet.add(n, stylesheetRef);
        this.notifyChanged("RawReport.Stylesheet");
    }

    public void addAllStylesheets(Collection<StylesheetRef> collection) {
        this.m_Stylesheet.addAll(collection);
        this.notifyChanged("RawReport.Stylesheet");
    }

    public int indexOfStylesheet(StylesheetRef stylesheetRef) {
        return this.m_Stylesheet.indexOf(stylesheetRef);
    }

    public void removeStylesheet(StylesheetRef stylesheetRef) {
        this.m_Stylesheet.remove(stylesheetRef);
        this.notifyChanged("RawReport.Stylesheet");
    }

    public void removeAllStylesheets(Collection collection) {
        this.m_Stylesheet.removeAll(collection);
        this.notifyChanged("RawReport.Stylesheet");
    }

    public void removeAllStylesheets() {
        this.m_Stylesheet.clear();
        this.notifyChanged("RawReport.Stylesheet");
    }

    public StylesheetRef getStylesheet(int n) {
        return this.m_Stylesheet.get(n);
    }

    public int getStylesheetCount() {
        return this.m_Stylesheet.size();
    }

    public Iterator<StylesheetRef> getStylesheetIterator() {
        return this.m_Stylesheet.iterator();
    }

    public List<StylesheetRef> getStylesheetList() {
        return this.m_Stylesheet;
    }

    public void setStylesheetList(List<StylesheetRef> list) {
        this.m_Stylesheet = list;
        this.notifyChanged("RawReport.Stylesheet");
    }

    public void addSection(Section section) {
        this.m_Section.add(section);
        section.setRawReport(this);
        this.notifyChanged("RawReport.Section");
    }

    public void addSection(int n, Section section) {
        this.m_Section.add(n, section);
        section.setRawReport(this);
        this.notifyChanged("RawReport.Section");
    }

    public void addAllSections(Collection<Section> collection) {
        this.m_Section.addAll(collection);
        for (Section section : collection) {
            section.setRawReport(this);
        }
        this.notifyChanged("RawReport.Section");
    }

    public int indexOfSection(Section section) {
        return this.m_Section.indexOf(section);
    }

    public void removeSection(Section section) {
        this.m_Section.remove(section);
        section.setRawReport(null);
        this.notifyChanged("RawReport.Section");
    }

    public void removeAllSections(Collection collection) {
        this.m_Section.removeAll(collection);
        for (Section section : collection) {
            section.setRawReport(null);
        }
        this.notifyChanged("RawReport.Section");
    }

    public void removeAllSections() {
        for (Section section : this.m_Section) {
            section.setRawReport(null);
        }
        this.m_Section.clear();
        this.notifyChanged("RawReport.Section");
    }

    public Section getSection(int n) {
        return this.m_Section.get(n);
    }

    public int getSectionCount() {
        return this.m_Section.size();
    }

    public Iterator<Section> getSectionIterator() {
        return this.m_Section.iterator();
    }

    public List<Section> getSectionList() {
        return this.m_Section;
    }

    public void setSectionList(List<Section> list) {
        this.m_Section = list;
        this.notifyChanged("RawReport.Section");
    }

    public void addSequenceStep(ISequenceStep iSequenceStep) {
        this.m_SequenceStep.add(iSequenceStep);
        this.notifyChanged("RawReport.SequenceStep");
    }

    public void addSequenceStep(int n, ISequenceStep iSequenceStep) {
        this.m_SequenceStep.add(n, iSequenceStep);
        this.notifyChanged("RawReport.SequenceStep");
    }

    public void addAllSequenceSteps(Collection<ISequenceStep> collection) {
        this.m_SequenceStep.addAll(collection);
        this.notifyChanged("RawReport.SequenceStep");
    }

    public int indexOfSequenceStep(ISequenceStep iSequenceStep) {
        return this.m_SequenceStep.indexOf(iSequenceStep);
    }

    public void removeSequenceStep(ISequenceStep iSequenceStep) {
        this.m_SequenceStep.remove(iSequenceStep);
        this.notifyChanged("RawReport.SequenceStep");
    }

    public void removeAllSequenceSteps(Collection collection) {
        this.m_SequenceStep.removeAll(collection);
        this.notifyChanged("RawReport.SequenceStep");
    }

    public void removeAllSequenceSteps() {
        this.m_SequenceStep.clear();
        this.notifyChanged("RawReport.SequenceStep");
    }

    public ISequenceStep getSequenceStep(int n) {
        return this.m_SequenceStep.get(n);
    }

    public int getSequenceStepCount() {
        return this.m_SequenceStep.size();
    }

    public Iterator<ISequenceStep> getSequenceStepIterator() {
        return this.m_SequenceStep.iterator();
    }

    public List<ISequenceStep> getSequenceStepList() {
        return this.m_SequenceStep;
    }

    public void setSequenceStepList(List<ISequenceStep> list) {
        this.m_SequenceStep = list;
        this.notifyChanged("RawReport.SequenceStep");
    }

    public void addRenderDetails(RenderDetails renderDetails) {
        String string = renderDetails.getMimeType();
        this.m_RenderDetails.put(string, renderDetails);
    }

    public void removeRenderDetails(RenderDetails renderDetails) {
        String string = renderDetails.getMimeType();
        this.m_RenderDetails.remove(string);
    }

    public RenderDetails getRenderDetails(String string) {
        return this.m_RenderDetails.get(string);
    }

    public Iterator<RenderDetails> getRenderDetailsIterator() {
        return this.m_RenderDetails.values().iterator();
    }

    public int getRenderDetailsCount() {
        return this.m_RenderDetails.size();
    }

    public Map<String, RenderDetails> getRenderDetailsMap() {
        return this.m_RenderDetails;
    }

    public void setRenderDetailsMap(Map<String, RenderDetails> map) {
        this.m_RenderDetails = map;
    }

    @Override
    public IResourceProvider getResourceProvider() {
        return this.m_ResourceProvider;
    }

    public void setResourceProvider(IResourceProvider iResourceProvider) {
        this.m_ResourceProvider = iResourceProvider;
    }

    public Locale getLocale() {
        return this.m_Locale;
    }

    public void setLocale(Locale locale) {
        this.m_Locale = locale;
    }

    public boolean isKeepPageCount() {
        return this.m_KeepPageCount;
    }

    public void setKeepPageCount(boolean bl) {
        this.m_KeepPageCount = bl;
    }

    public boolean isCacheAllProperties() {
        return this.m_CacheAllProperties;
    }

    public void setCacheAllProperties(boolean bl) {
        this.m_CacheAllProperties = bl;
    }

    public String getRepositoryBase() {
        return this.m_RepositoryBase;
    }

    public void setRepositoryBase(String string) {
        this.m_RepositoryBase = string;
    }

    public boolean isGridEnabled() {
        return this.m_GridEnabled;
    }

    public void setGridEnabled(boolean bl) {
        this.m_GridEnabled = bl;
    }

    public boolean isGridVisible() {
        return this.m_GridVisible;
    }

    public void setGridVisible(boolean bl) {
        this.m_GridVisible = bl;
    }

    public int getGridX() {
        return this.m_GridX;
    }

    public void setGridX(int n) {
        this.m_GridX = n;
    }

    public int getGridY() {
        return this.m_GridY;
    }

    public void setGridY(int n) {
        this.m_GridY = n;
    }

    public String getDescription() {
        return this.m_Description;
    }

    public void setDescription(String string) {
        this.m_Description = string;
    }

    public boolean isDisableCSVAutoWrap() {
        return this.m_DisableCSVAutoWrap;
    }

    public void setDisableCSVAutoWrap(boolean bl) {
        this.m_DisableCSVAutoWrap = bl;
    }

    public boolean isDisableExcelAutoWrap() {
        return this.m_DisableExcelAutoWrap;
    }

    public void setDisableExcelAutoWrap(boolean bl) {
        this.m_DisableExcelAutoWrap = bl;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (this.m_ChangeListeners == null) {
            this.m_ChangeListeners = new HashSet<ChangeListener>();
        }
        this.m_ChangeListeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.m_ChangeListeners.remove(changeListener);
        if (this.m_ChangeListeners.size() == 0) {
            this.m_ChangeListeners = null;
        }
    }

    public void notifyChanged(String string) {
        if (this.m_ChangeListeners != null) {
            for (ChangeListener changeListener : this.m_ChangeListeners) {
                changeListener.beanChanged(this, string);
            }
        }
    }

    @Override
    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    public Script getFunctionDefinitions() {
        if (this.m_FunctionDefinitions != null) {
            return this.m_FunctionDefinitions;
        }
        return (Script)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
    }

    public void setFunctionDefinitions(Script script) {
        this.m_FunctionDefinitions = script;
    }

    public Script getOnRenderBegin() {
        if (this.m_OnRenderBegin != null) {
            return this.m_OnRenderBegin;
        }
        return (Script)this.getDefaultPropertyValue(m_IndexOffset + 2 - 1);
    }

    public void setOnRenderBegin(Script script) {
        this.m_OnRenderBegin = script;
        if (this.m_OnRenderBegin != null) {
            this.m_OnRenderBegin.setTagName("on-render-begin");
        }
    }

    public Script getOnRenderEnd() {
        if (this.m_OnRenderEnd != null) {
            return this.m_OnRenderEnd;
        }
        return (Script)this.getDefaultPropertyValue(m_IndexOffset + 3 - 1);
    }

    public void setOnRenderEnd(Script script) {
        this.m_OnRenderEnd = script;
        if (this.m_OnRenderEnd != null) {
            this.m_OnRenderEnd.setTagName("on-render-end");
        }
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
        super.getPropertyNames(set);
    }

    @Override
    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    @Override
    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyIndex(string);
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            return super.getProperty(name);
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyName(n);
        }
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        if (n < m_IndexOffset) {
            return super.getPropertyType(n);
        }
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        if (n < m_IndexOffset) {
            super.setPropertyValue(n, object);
        } else {
            try {
                switch (n -= m_IndexOffset) {
                    case 0: {
                        this.m_FunctionDefinitions = (Script)object;
                        break;
                    }
                    case 1: {
                        this.m_OnRenderBegin = (Script)object;
                        if (this.m_OnRenderBegin != null) {
                            this.m_OnRenderBegin.setTagName("on-render-begin");
                        }
                        break;
                    }
                    case 2: {
                        this.m_OnRenderEnd = (Script)object;
                        if (this.m_OnRenderEnd != null) {
                            this.m_OnRenderEnd.setTagName("on-render-end");
                        }
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("No such property index: " + n + " in " + this.getClass());
                    }
                }
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("Error setting " + n + " with " + object + "(" + object.getClass() + ") : " + exception);
            }
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return super.getPropertyValue(name);
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return false;
    }

    @Override
    protected Object getLocalPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getLocalPropertyValue(n);
        }
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_FunctionDefinitions;
            }
            case 1: {
                return this.m_OnRenderBegin;
            }
            case 2: {
                return this.m_OnRenderEnd;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + this.getClass());
    }

    @Override
    protected Object getDefaultPropertyValue(int n) {
        if (n < m_IndexOffset) {
            return super.getDefaultPropertyValue(n);
        }
        return null;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public RawReport deepCopy() {
        RawReport rawReport = new RawReport();
        this.copyInto(rawReport);
        return rawReport;
    }

    protected void copyInto(RawReport rawReport) {
        super.copyInto(rawReport);
        rawReport.m_ResourceProvider = this.m_ResourceProvider;
        rawReport.m_Locale = this.m_Locale;
        rawReport.m_KeepPageCount = this.m_KeepPageCount;
        rawReport.m_CacheAllProperties = this.m_CacheAllProperties;
        rawReport.m_RepositoryBase = this.m_RepositoryBase;
        rawReport.m_GridEnabled = this.m_GridEnabled;
        rawReport.m_GridVisible = this.m_GridVisible;
        rawReport.m_GridX = this.m_GridX;
        rawReport.m_GridY = this.m_GridY;
        rawReport.m_Description = this.m_Description;
        rawReport.m_DisableCSVAutoWrap = this.m_DisableCSVAutoWrap;
        rawReport.m_DisableExcelAutoWrap = this.m_DisableExcelAutoWrap;
        if (this.m_Metadata != null) {
            rawReport.m_Metadata = this.m_Metadata.deepCopy();
        }
        if (this.m_Security != null) {
            rawReport.m_Security = this.m_Security.deepCopy();
        }
        if (this.m_FunctionDefinitions != null) {
            rawReport.m_FunctionDefinitions = this.m_FunctionDefinitions.deepCopy();
        }
        if (this.m_OnRenderBegin != null) {
            rawReport.m_OnRenderBegin = this.m_OnRenderBegin.deepCopy();
        }
        if (this.m_OnRenderEnd != null) {
            rawReport.m_OnRenderEnd = this.m_OnRenderEnd.deepCopy();
        }
        rawReport.m_PageSetup = new ArrayList<PageSetup>();
        for (PageSetup object : this.m_PageSetup) {
            rawReport.addPageSetup(object.deepCopy());
        }
        rawReport.m_Parameter = new ArrayList<Parameter>();
        for (Parameter parameter : this.m_Parameter) {
            rawReport.addParameter(parameter.deepCopy());
        }
        rawReport.m_DataSource = new ArrayList<DataSource>();
        for (DataSource dataSource : this.m_DataSource) {
            rawReport.addDataSource(dataSource.deepCopy());
        }
        rawReport.m_Style = new HashMap<String, Style>();
        for (Map.Entry entry : this.m_Style.entrySet()) {
            rawReport.addStyle(((Style)entry.getValue()).deepCopy());
        }
        rawReport.m_Stylesheet = new ArrayList<StylesheetRef>();
        for (StylesheetRef stylesheetRef : this.m_Stylesheet) {
            rawReport.addStylesheet(stylesheetRef.deepCopy());
        }
        rawReport.m_Section = new ArrayList<Section>();
        for (Section section : this.m_Section) {
            rawReport.addSection(section.deepCopy());
        }
        rawReport.m_SequenceStep = new ArrayList<ISequenceStep>();
        for (ISequenceStep iSequenceStep : this.m_SequenceStep) {
            rawReport.addSequenceStep(iSequenceStep.deepCopy());
        }
        rawReport.m_RenderDetails = new HashMap<String, RenderDetails>();
        for (Map.Entry entry : this.m_RenderDetails.entrySet()) {
            rawReport.addRenderDetails(((RenderDetails)entry.getValue()).deepCopy());
        }
    }

    static {
        try {
            m_IndexOffset = StyledElement.getStaticPropertyCount();
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                RawReport.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                RawReport.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            RawReport.logError("Error in property initialization", throwable);
        }
    }
}

