/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.model.ISectionInvocation;
import com.elixirtech.report2.raw.model.ISequenceStep;
import com.elixirtech.report2.raw.model.Parameter;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.ChangeListener;
import com.elixirtech.sax.ChangeNotifier;
import com.elixirtech.sax.IBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SectionInvocation
implements IBean,
PropertyImplementor,
ChangeNotifier,
PropertyHolder,
ISequenceStep,
ISectionInvocation {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(SectionInvocation.class);
    protected boolean m_IsLoaded;
    protected List<Parameter> m_Parameter = new ArrayList<Parameter>();
    protected String m_ReportName;
    protected String m_SectionName = "";
    protected String m_DataSourceName;
    protected Boolean m_Enabled = Boolean.FALSE;
    private Set<ChangeListener> m_ChangeListeners;
    private static String[] m_PropertyNameStrings = new String[]{"SectionInvocation.ReportName".intern(), "SectionInvocation.SectionName".intern(), "SectionInvocation.DataSourceName".intern(), "SectionInvocation.Enabled".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"String", "Choice.Section", "Choice.DataSource", "Boolean"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "section-invocation";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
        Iterator<Parameter> iterator = this.m_Parameter.iterator();
        while (iterator.hasNext()) {
            ((IBean)iterator.next()).loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Parameter != null) {
            Iterator<Parameter> iterator = this.m_Parameter.iterator();
            while (iterator.hasNext()) {
                ((IBean)iterator.next()).dispose();
            }
        }
        this.m_Parameter = null;
    }

    public void copyAttrs(Element element) {
        if (this.m_ReportName != null) {
            element.setAttribute("report", this.m_ReportName);
        }
        if (this.m_SectionName != null) {
            element.setAttribute("section", this.m_SectionName);
        }
        if (this.m_DataSourceName != null) {
            element.setAttribute("data-source", this.m_DataSourceName);
        }
        if (this.m_Enabled != null) {
            element.setAttribute("enabled", this.m_Enabled != false ? "Yes" : "No");
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        SectionInvocation sectionInvocation = (SectionInvocation)this.getClass().newInstance();
        return sectionInvocation;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Render ");
        if (this.m_ReportName != null && this.m_ReportName.trim().length() > 0) {
            stringBuilder.append(this.m_ReportName + ":");
        }
        stringBuilder.append(this.m_SectionName);
        if (this.m_DataSourceName != null && this.m_DataSourceName.length() > 0) {
            stringBuilder.append(" with data from " + this.m_DataSourceName);
        }
        return stringBuilder.toString();
    }

    public void renameSection(String string, String string2) {
        if (string.equals(this.getSectionName())) {
            this.setSectionName(string2);
        }
    }

    @Override
    public void addParameter(Parameter parameter) {
        this.m_Parameter.add(parameter);
    }

    public void addParameter(int n, Parameter parameter) {
        this.m_Parameter.add(n, parameter);
    }

    public void addAllParameters(Collection<Parameter> collection) {
        this.m_Parameter.addAll(collection);
    }

    public int indexOfParameter(Parameter parameter) {
        return this.m_Parameter.indexOf(parameter);
    }

    public void removeParameter(Parameter parameter) {
        this.m_Parameter.remove(parameter);
    }

    public void removeAllParameters(Collection collection) {
        this.m_Parameter.removeAll(collection);
    }

    @Override
    public void removeAllParameters() {
        this.m_Parameter.clear();
    }

    @Override
    public Parameter getParameter(int n) {
        return this.m_Parameter.get(n);
    }

    @Override
    public int getParameterCount() {
        return this.m_Parameter.size();
    }

    public Iterator<Parameter> getParameterIterator() {
        return this.m_Parameter.iterator();
    }

    public List<Parameter> getParameterList() {
        return this.m_Parameter;
    }

    public void setParameterList(List<Parameter> list) {
        this.m_Parameter = list;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        if (this.m_ChangeListeners == null) {
            this.m_ChangeListeners = new HashSet<ChangeListener>();
        }
        this.m_ChangeListeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.m_ChangeListeners.remove(changeListener);
        if (this.m_ChangeListeners.size() == 0) {
            this.m_ChangeListeners = null;
        }
    }

    public void notifyChanged(String string) {
        if (this.m_ChangeListeners != null) {
            for (ChangeListener changeListener : this.m_ChangeListeners) {
                changeListener.beanChanged(this, string);
            }
        }
    }

    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    @Override
    public String getReportName() {
        if (this.m_ReportName != null) {
            return this.m_ReportName;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
    }

    @Override
    public void setReportName(String string) {
        this.m_ReportName = string;
        if (this.m_ReportName != null) {
            this.m_ReportName = this.m_ReportName.trim();
        }
    }

    @Override
    public String getSectionName() {
        if (this.m_SectionName != null) {
            return this.m_SectionName;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 2 - 1);
    }

    @Override
    public void setSectionName(String string) {
        this.m_SectionName = string;
        if (this.m_SectionName != null) {
            this.m_SectionName = this.m_SectionName.trim();
        }
    }

    @Override
    public String getDataSourceName() {
        if (this.m_DataSourceName != null) {
            return this.m_DataSourceName;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 3 - 1);
    }

    @Override
    public void setDataSourceName(String string) {
        this.m_DataSourceName = string;
        if (this.m_DataSourceName != null) {
            this.m_DataSourceName = this.m_DataSourceName.trim();
        }
    }

    public boolean isEnabled() {
        Boolean bl = this.m_Enabled;
        if (bl == null) {
            bl = (Boolean)this.getDefaultPropertyValue(m_IndexOffset + 4 - 1);
        }
        return bl;
    }

    public void setEnabled(boolean bl) {
        this.m_Enabled = bl;
    }

    public void setEnabled(Boolean bl) {
        this.m_Enabled = bl;
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
    }

    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            throw new IllegalArgumentException("Name: " + string + " not found in " + this.getClass().getName());
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            throw new IllegalArgumentException("Name: " + name.getName() + " not found in " + this.getClass().getName());
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        try {
            switch (n -= m_IndexOffset) {
                case 0: {
                    this.m_ReportName = (String)object;
                    if (this.m_ReportName != null) {
                        this.m_ReportName = this.m_ReportName.trim();
                    }
                    break;
                }
                case 1: {
                    this.m_SectionName = (String)object;
                    if (this.m_SectionName != null) {
                        this.m_SectionName = this.m_SectionName.trim();
                    }
                    break;
                }
                case 2: {
                    this.m_DataSourceName = (String)object;
                    if (this.m_DataSourceName != null) {
                        this.m_DataSourceName = this.m_DataSourceName.trim();
                    }
                    break;
                }
                case 3: {
                    this.m_Enabled = (Boolean)object;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No such property index: " + n + " in " + this.getClass());
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error setting " + n + " with " + object + "(" + object.getClass() + ") : " + exception);
        }
    }

    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            return null;
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public Object getPropertyValue(int n) {
        Object object = this.getLocalPropertyValue(n);
        if (object == null) {
            object = this.getDefaultPropertyValue(n);
        }
        return object;
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return false;
    }

    @Override
    public boolean isPropertyEditable(int n) {
        return true;
    }

    protected Object getLocalPropertyValue(int n) {
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_ReportName;
            }
            case 1: {
                return this.m_SectionName;
            }
            case 2: {
                return this.m_DataSourceName;
            }
            case 3: {
                return this.m_Enabled;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + this.getClass());
    }

    protected Object getDefaultPropertyValue(int n) {
        return null;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    @Override
    public SectionInvocation deepCopy() {
        SectionInvocation sectionInvocation = new SectionInvocation();
        this.copyInto(sectionInvocation);
        return sectionInvocation;
    }

    protected void copyInto(SectionInvocation sectionInvocation) {
        sectionInvocation.m_ReportName = this.m_ReportName;
        sectionInvocation.m_SectionName = this.m_SectionName;
        sectionInvocation.m_DataSourceName = this.m_DataSourceName;
        sectionInvocation.m_Enabled = this.m_Enabled;
        sectionInvocation.m_Parameter = new ArrayList<Parameter>();
        for (Parameter parameter : this.m_Parameter) {
            sectionInvocation.addParameter(parameter.deepCopy());
        }
    }

    static {
        try {
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                SectionInvocation.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                SectionInvocation.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            SectionInvocation.logError("Error in property initialization", throwable);
        }
    }
}

