/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.arch.Elixir;
import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.arch.IAdaptable;
import com.elixirtech.arch.StringUtil;
import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.IMasterPropertyList;
import com.elixirtech.property.IStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyHolder;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.StyleItem;
import com.elixirtech.report2.raw.property.PropertyAdapter;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Style
implements IBean,
Comparable<Style>,
PropertyHolder,
IStyle {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(Style.class);
    private IAdaptable m_Parent;
    protected boolean m_IsLoaded;
    private IMasterPropertyList m_MasterPropertyList;
    protected Map<String, StyleItem> m_Default = new HashMap<String, StyleItem>();
    protected String m_Name;
    protected String m_BaseName;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    public Style() {
        this.m_MasterPropertyList = (IMasterPropertyList)Elixir.get(IMasterPropertyList.class);
    }

    @Override
    public String getTagName() {
        return "style";
    }

    public IAdaptable getParent() {
        return this.m_Parent;
    }

    public void setParent(IAdaptable iAdaptable) {
        this.m_Parent = iAdaptable;
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
        for (IBean iBean : this.m_Default.values()) {
            iBean.loaded();
        }
    }

    @Override
    public void dispose() {
        if (this.m_Default != null) {
            for (IBean iBean : this.m_Default.values()) {
                iBean.dispose();
            }
        }
        this.m_Default = null;
    }

    public void copyAttrs(Element element) {
        if (this.m_Name != null) {
            element.setAttribute("name", this.m_Name);
        }
        if (this.m_BaseName != null) {
            element.setAttribute("base-name", this.m_BaseName);
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        Style style = (Style)this.getClass().newInstance();
        style.m_Name = this.m_Name;
        style.m_BaseName = this.m_BaseName;
        return style;
    }

    public Style(Style style) {
        this();
        this.m_Name = style.m_Name;
        this.m_BaseName = style.m_BaseName;
        Iterator<StyleItem> iterator = style.m_Default.values().iterator();
        while (iterator.hasNext()) {
            this.addStyleItem(new StyleItem(iterator.next()));
        }
    }

    public String toString() {
        if (this.m_BaseName == null || this.m_BaseName.trim().length() == 0) {
            return this.m_Name;
        }
        return this.m_Name + " extends " + this.m_BaseName;
    }

    @Override
    public Object getValue(Name name) {
        StyleItem styleItem = this.getStyleItem(name.getName());
        if (styleItem != null) {
            return this.m_MasterPropertyList.getValue(new Name(styleItem.getName()), styleItem.getValue());
        }
        IStyle iStyle = this.getBaseStyle();
        if (iStyle != null) {
            return iStyle.getValue(name);
        }
        return null;
    }

    @Override
    public int compareTo(Style style) {
        return this.m_Name.compareTo(style.m_Name);
    }

    public void getPropertyNames(Set set) {
        for (String string : this.m_Default.keySet()) {
            set.add(BeanUtil.getName(string));
        }
    }

    @Override
    public Property getProperty(Name name) {
        PropertyType propertyType;
        StyleItem styleItem = this.getStyleItem(name.getName());
        if (styleItem != null && (propertyType = this.m_MasterPropertyList.getPropertyType(name)) != null) {
            return new Property(new PropertyAdapter(styleItem, name, propertyType), 0);
        }
        return null;
    }

    protected IStyle getBaseStyle() {
        if (this.m_Parent != null && StringUtil.notEmpty(this.m_BaseName)) {
            IResourceProvider iResourceProvider = this.m_Parent.getAdapter(IResourceProvider.class);
            return iResourceProvider.getStyle(this.m_BaseName);
        }
        return null;
    }

    public void addStyleItem(StyleItem styleItem) {
        String string = styleItem.getName();
        this.m_Default.put(string, styleItem);
    }

    public void removeStyleItem(StyleItem styleItem) {
        String string = styleItem.getName();
        this.m_Default.remove(string);
    }

    public StyleItem getStyleItem(String string) {
        return this.m_Default.get(string);
    }

    public Iterator<StyleItem> getStyleItemIterator() {
        return this.m_Default.values().iterator();
    }

    public int getStyleItemCount() {
        return this.m_Default.size();
    }

    public Map<String, StyleItem> getStyleItemMap() {
        return this.m_Default;
    }

    public void setStyleItemMap(Map<String, StyleItem> map) {
        this.m_Default = map;
    }

    @Override
    public String getName() {
        return this.m_Name;
    }

    public void setName(String string) {
        this.m_Name = string;
        if (this.m_Name != null) {
            this.m_Name = this.m_Name.trim();
        }
    }

    public String getBaseName() {
        return this.m_BaseName;
    }

    public void setBaseName(String string) {
        this.m_BaseName = string;
        if (this.m_BaseName != null) {
            this.m_BaseName = this.m_BaseName.trim();
        }
    }

    public Style deepCopy() {
        Style style = new Style();
        this.copyInto(style);
        return style;
    }

    protected void copyInto(Style style) {
        style.m_Name = this.m_Name;
        style.m_BaseName = this.m_BaseName;
        style.m_Default = new HashMap<String, StyleItem>();
        for (Map.Entry<String, StyleItem> entry : this.m_Default.entrySet()) {
            style.addStyleItem(entry.getValue().deepCopy());
        }
    }
}

