/*
 * Decompiled with CFR 0.152.
 */
package com.elixirtech.report2.raw.model;

import com.elixirtech.arch.ElxLoggerJ;
import com.elixirtech.i18n.Name;
import com.elixirtech.jdom.Element;
import com.elixirtech.property.DefaultStyle;
import com.elixirtech.property.IStyle;
import com.elixirtech.property.Property;
import com.elixirtech.property.PropertyImplementor;
import com.elixirtech.property.PropertyType;
import com.elixirtech.report2.raw.StyleManager;
import com.elixirtech.report2.raw.model.IResourceProvider;
import com.elixirtech.report2.raw.model.IStyledElement;
import com.elixirtech.report2.raw.model.Style;
import com.elixirtech.sax.BeanUtil;
import com.elixirtech.sax.IBean;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Set;

public abstract class StyledElement
implements IBean,
PropertyImplementor,
IStyledElement {
    private static ElxLoggerJ m_Log = ElxLoggerJ.getLogger(StyledElement.class);
    protected boolean m_IsLoaded;
    protected String m_StyleName;
    private static String[] m_PropertyNameStrings = new String[]{"StyledElement.StyleName".intern()};
    private static String[] m_PropertyTypeStrings = new String[]{"Choice.Style"};
    private static int m_IndexOffset;
    private static Name[] m_PropertyNames;
    private static PropertyType[] m_PropertyTypes;
    protected IStyle m_Style;

    protected static void logError(String string) {
        m_Log.error((Object)string);
    }

    protected static void logError(String string, Throwable throwable) {
        m_Log.error((Object)string, throwable);
    }

    protected static void logInfo(String string) {
        m_Log.info((Object)string);
    }

    public static boolean isHidden(String string) {
        return false;
    }

    @Override
    public String getTagName() {
        return "styled-element";
    }

    @Override
    public void loaded() {
        this.m_IsLoaded = true;
        this.cacheStyle();
    }

    @Override
    public void dispose() {
    }

    public void copyAttrs(Element element) {
        if (this.m_StyleName != null) {
            element.setAttribute("style", this.m_StyleName);
        }
    }

    public Object shallowCopy() throws InstantiationException, IllegalAccessException {
        try {
            StyledElement styledElement = (StyledElement)this.getClass().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return styledElement;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new InstantiationException("shallowCopy: " + noSuchMethodException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new InstantiationException("shallowCopy: " + invocationTargetException);
        }
    }

    protected void cacheStyle() {
        IResourceProvider iResourceProvider;
        if (this.m_StyleName == null) {
            this.m_StyleName = "";
        }
        if ((iResourceProvider = this.getResourceProvider()) != null) {
            this.m_Style = iResourceProvider.getStyle(this.m_StyleName);
        }
    }

    protected String getDefaultStyle() {
        return this.getTagName();
    }

    @Override
    public abstract IResourceProvider getResourceProvider();

    @Override
    public abstract IStyledElement getParentStyledElement();

    public void cacheProperties() {
        int n = this.getPropertyCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getLocalPropertyValue(i);
            if (object != null) continue;
            object = this.getDefaultPropertyValue(i);
            this.setPropertyValue(i, object);
        }
    }

    public String getStyleName() {
        if (this.m_StyleName != null) {
            return this.m_StyleName;
        }
        return (String)this.getDefaultPropertyValue(m_IndexOffset + 1 - 1);
    }

    public void setStyleName(String string) {
        this.m_StyleName = string;
        if (this.m_StyleName != null) {
            this.m_StyleName = this.m_StyleName.trim();
        }
        this.cacheStyle();
    }

    @Override
    public void getPropertyNames(Set<Name> set) {
        set.addAll(Arrays.asList(m_PropertyNames));
    }

    public int getPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public static int getStaticPropertyCount() {
        return m_IndexOffset + m_PropertyNameStrings.length;
    }

    public int getPropertyIndex(String string) {
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            throw new IllegalArgumentException("Name: " + string + " not found in " + this.getClass().getName());
        }
        return n += m_IndexOffset;
    }

    @Override
    public Property getProperty(Name name) {
        int n = BeanUtil.indexOf(name.getName(), m_PropertyNameStrings);
        if (n < 0) {
            throw new IllegalArgumentException("Name: " + name.getName() + " not found in " + this.getClass().getName());
        }
        return new Property(this, n += m_IndexOffset);
    }

    @Override
    public Name getPropertyName(int n) {
        return m_PropertyNames[n - m_IndexOffset];
    }

    @Override
    public PropertyType getPropertyType(int n) {
        return m_PropertyTypes[n - m_IndexOffset];
    }

    @Override
    public void setPropertyValue(int n, Object object) {
        try {
            switch (n -= m_IndexOffset) {
                case 0: {
                    this.m_StyleName = (String)object;
                    if (this.m_StyleName != null) {
                        this.m_StyleName = this.m_StyleName.trim();
                    }
                    this.cacheStyle();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("No such property index: " + n + " in " + this.getClass());
                }
            }
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Error setting " + n + " with " + object + "(" + object.getClass() + ") : " + exception);
        }
    }

    @Override
    public Object getPropertyValue(Name name) {
        String string = name.getName();
        int n = BeanUtil.indexOf(string, m_PropertyNameStrings);
        if (n < 0) {
            Style style;
            Object object;
            Object object2 = null;
            if (this.m_Style != null) {
                object2 = this.m_Style.getValue(name);
            }
            if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
                object2 = object.getPropertyValue(name);
            }
            if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
                object2 = style.getValue(name);
            }
            if (object2 == null) {
                object2 = DefaultStyle.current().getValue(name);
            }
            return object2;
        }
        return this.getPropertyValue(m_IndexOffset + n);
    }

    @Override
    public Object getPropertyValue(int n) {
        Object object = this.getLocalPropertyValue(n);
        if (object == null) {
            object = this.getDefaultPropertyValue(n);
        }
        return object;
    }

    @Override
    public boolean isLocalPropertyValue(int n) {
        return this.getLocalPropertyValue(n) != null;
    }

    @Override
    public boolean isPropertyEditable(int n) {
        return true;
    }

    protected Object getLocalPropertyValue(int n) {
        switch (n - m_IndexOffset) {
            case 0: {
                return this.m_StyleName;
            }
        }
        throw new IllegalArgumentException("No such property index " + n + " in " + this.getClass());
    }

    protected Object getDefaultPropertyValue(int n) {
        Style style;
        Object object;
        Object object2 = null;
        Name name = m_PropertyNames[n - m_IndexOffset];
        if (this.m_Style != null) {
            object2 = this.m_Style.getValue(name);
        }
        if (object2 == null && StyleManager.isInherited(name) && (object = this.getParentStyledElement()) != null) {
            object2 = object.getPropertyValue(name);
        }
        if (object2 == null && (object = this.getResourceProvider()) != null && (style = object.getStyle(this.getDefaultStyle())) != null) {
            object2 = style.getValue(name);
        }
        if (object2 == null) {
            object2 = DefaultStyle.current().getValue(name);
        }
        return object2;
    }

    public static int getIndexOffset() {
        return m_IndexOffset;
    }

    public abstract StyledElement deepCopy();

    protected void copyInto(StyledElement styledElement) {
        styledElement.m_StyleName = this.m_StyleName;
    }

    public void setStyle(IStyle iStyle) {
        this.m_Style = iStyle;
        this.m_StyleName = this.m_Style.getName();
    }

    @Override
    public IStyle getStyle() {
        return this.m_Style;
    }

    static {
        try {
            int n = m_PropertyNameStrings.length;
            m_PropertyNames = new Name[n];
            m_PropertyTypes = new PropertyType[n];
            for (int i = 0; i < n; ++i) {
                StyledElement.m_PropertyNames[i] = BeanUtil.getName(m_PropertyNameStrings[i]);
                StyledElement.m_PropertyTypes[i] = BeanUtil.getType(m_PropertyTypeStrings[i]);
            }
        }
        catch (Throwable throwable) {
            StyledElement.logError("Error in property initialization", throwable);
        }
    }
}

